/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class EnchantmentPredicate {
    public static final EnchantmentPredicate ANY = new EnchantmentPredicate();
    private final Enchantment enchantment;
    private final MinMaxBounds levels;

    public EnchantmentPredicate() {
        this.enchantment = null;
        this.levels = MinMaxBounds.UNBOUNDED;
    }

    public EnchantmentPredicate(@Nullable Enchantment enchantment, MinMaxBounds levels) {
        this.enchantment = enchantment;
        this.levels = levels;
    }

    public boolean test(Map<Enchantment, Integer> enchantmentsIn) {
        if (this.enchantment != null) {
            if (!enchantmentsIn.containsKey(this.enchantment)) {
                return false;
            }
            int i = enchantmentsIn.get(this.enchantment);
            if (this.levels != null && !this.levels.test(i)) {
                return false;
            }
        } else if (this.levels != null) {
            for (Integer integer : enchantmentsIn.values()) {
                if (!this.levels.test(integer.intValue())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static EnchantmentPredicate deserialize(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            ResourceLocation resourcelocation;
            JsonObject jsonobject = JsonUtils.getJsonObject(element, "enchantment");
            Enchantment enchantment = null;
            if (jsonobject.has("enchantment") && (enchantment = Enchantment.REGISTRY.getObject(resourcelocation = new ResourceLocation(JsonUtils.getString(jsonobject, "enchantment")))) == null) {
                throw new JsonSyntaxException("Unknown enchantment '" + String.valueOf(resourcelocation) + "'");
            }
            MinMaxBounds minmaxbounds = MinMaxBounds.deserialize(jsonobject.get("levels"));
            return new EnchantmentPredicate(enchantment, minmaxbounds);
        }
        return ANY;
    }

    public static EnchantmentPredicate[] deserializeArray(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonArray jsonarray = JsonUtils.getJsonArray(element, "enchantments");
            EnchantmentPredicate[] aenchantmentpredicate = new EnchantmentPredicate[jsonarray.size()];
            for (int i = 0; i < aenchantmentpredicate.length; ++i) {
                aenchantmentpredicate[i] = EnchantmentPredicate.deserialize(jsonarray.get(i));
            }
            return aenchantmentpredicate;
        }
        return new EnchantmentPredicate[0];
    }
}

