/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class EnterBlockTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("enter_block");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void addListener(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners enterblocktrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (enterblocktrigger$listeners == null) {
            enterblocktrigger$listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, enterblocktrigger$listeners);
        }
        enterblocktrigger$listeners.add(listener);
    }

    @Override
    public void removeListener(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners enterblocktrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (enterblocktrigger$listeners != null) {
            enterblocktrigger$listeners.remove(listener);
            if (enterblocktrigger$listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    @Override
    public void removeAllListeners(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    @Override
    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        Block block = null;
        if (json.has("block")) {
            ResourceLocation resourcelocation = new ResourceLocation(JsonUtils.getString(json, "block"));
            if (!Block.REGISTRY.containsKey(resourcelocation)) {
                throw new JsonSyntaxException("Unknown block type '" + String.valueOf(resourcelocation) + "'");
            }
            block = Block.REGISTRY.getObject(resourcelocation);
        }
        HashMap map = null;
        if (json.has("state")) {
            if (block == null) {
                throw new JsonSyntaxException("Can't define block state without a specific block type");
            }
            BlockStateContainer blockstatecontainer = block.getBlockState();
            for (Map.Entry entry : JsonUtils.getJsonObject(json, "state").entrySet()) {
                IProperty<?> iproperty = blockstatecontainer.getProperty((String)entry.getKey());
                if (iproperty == null) {
                    throw new JsonSyntaxException("Unknown block state property '" + (String)entry.getKey() + "' for block '" + String.valueOf(Block.REGISTRY.getNameForObject(block)) + "'");
                }
                String s = JsonUtils.getString((JsonElement)entry.getValue(), (String)entry.getKey());
                Optional<?> optional = iproperty.parseValue(s);
                if (!optional.isPresent()) {
                    throw new JsonSyntaxException("Invalid block state value '" + s + "' for property '" + (String)entry.getKey() + "' on block '" + String.valueOf(Block.REGISTRY.getNameForObject(block)) + "'");
                }
                if (map == null) {
                    map = Maps.newHashMap();
                }
                map.put(iproperty, optional.get());
            }
        }
        return new Instance(block, map);
    }

    public void trigger(EntityPlayerMP player, IBlockState state) {
        Listeners enterblocktrigger$listeners = this.listeners.get(player.getAdvancements());
        if (enterblocktrigger$listeners != null) {
            enterblocktrigger$listeners.trigger(state);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(IBlockState state) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!listener.getCriterionInstance().test(state)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener<Instance> listener1 : list) {
                    listener1.grantCriterion(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final Block block;
        private final Map<IProperty<?>, Object> properties;

        public Instance(@Nullable Block blockIn, @Nullable Map<IProperty<?>, Object> propertiesIn) {
            super(ID);
            this.block = blockIn;
            this.properties = propertiesIn;
        }

        public boolean test(IBlockState state) {
            if (this.block != null && state.getBlock() != this.block) {
                return false;
            }
            if (this.properties != null) {
                for (Map.Entry<IProperty<?>, Object> entry : this.properties.entrySet()) {
                    if (state.getValue(entry.getKey()) == entry.getValue()) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

