/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NBTPredicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.advancements.critereon.ItemPredicates;

public class ItemPredicate {
    public static final ItemPredicate ANY = new ItemPredicate();
    private final Item item;
    private final Integer data;
    private final MinMaxBounds count;
    private final MinMaxBounds durability;
    private final EnchantmentPredicate[] enchantments;
    private final PotionType potion;
    private final NBTPredicate nbt;

    public ItemPredicate() {
        this.item = null;
        this.data = null;
        this.potion = null;
        this.count = MinMaxBounds.UNBOUNDED;
        this.durability = MinMaxBounds.UNBOUNDED;
        this.enchantments = new EnchantmentPredicate[0];
        this.nbt = NBTPredicate.ANY;
    }

    public ItemPredicate(@Nullable Item item, @Nullable Integer data, MinMaxBounds count, MinMaxBounds durability, EnchantmentPredicate[] enchantments, @Nullable PotionType potion, NBTPredicate nbt) {
        this.item = item;
        this.data = data;
        this.count = count;
        this.durability = durability;
        this.enchantments = enchantments;
        this.potion = potion;
        this.nbt = nbt;
    }

    public boolean test(ItemStack item) {
        if (this.item != null && item.getItem() != this.item) {
            return false;
        }
        if (this.data != null && item.getMetadata() != this.data.intValue()) {
            return false;
        }
        if (!this.count.test(item.getCount())) {
            return false;
        }
        if (this.durability != MinMaxBounds.UNBOUNDED && !item.isItemStackDamageable()) {
            return false;
        }
        if (!this.durability.test(item.getMaxDamage() - item.getItemDamage())) {
            return false;
        }
        if (!this.nbt.test(item)) {
            return false;
        }
        Map<Enchantment, Integer> map = EnchantmentHelper.getEnchantments(item);
        for (int i = 0; i < this.enchantments.length; ++i) {
            if (this.enchantments[i].test(map)) continue;
            return false;
        }
        PotionType potiontype = PotionUtils.getPotionFromItem(item);
        return this.potion == null || this.potion == potiontype;
    }

    public static ItemPredicate deserialize(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            ResourceLocation resourcelocation;
            JsonObject jsonobject = JsonUtils.getJsonObject(element, "item");
            if (jsonobject.has("type")) {
                ResourceLocation rl = new ResourceLocation(JsonUtils.getString(jsonobject, "type"));
                Map<ResourceLocation, Function<JsonObject, ItemPredicate>> map = ItemPredicates.getPredicates();
                if (map.containsKey(rl)) {
                    return map.get(rl).apply(jsonobject);
                }
                throw new JsonSyntaxException("There is no ItemPredicate of type " + String.valueOf(rl));
            }
            MinMaxBounds minmaxbounds = MinMaxBounds.deserialize(jsonobject.get("count"));
            MinMaxBounds minmaxbounds1 = MinMaxBounds.deserialize(jsonobject.get("durability"));
            Integer integer = jsonobject.has("data") ? Integer.valueOf(JsonUtils.getInt(jsonobject, "data")) : null;
            NBTPredicate nbtpredicate = NBTPredicate.deserialize(jsonobject.get("nbt"));
            Item item = null;
            if (jsonobject.has("item") && (item = Item.REGISTRY.getObject(resourcelocation = new ResourceLocation(JsonUtils.getString(jsonobject, "item")))) == null) {
                throw new JsonSyntaxException("Unknown item id '" + String.valueOf(resourcelocation) + "'");
            }
            EnchantmentPredicate[] aenchantmentpredicate = EnchantmentPredicate.deserializeArray(jsonobject.get("enchantments"));
            PotionType potiontype = null;
            if (jsonobject.has("potion")) {
                ResourceLocation resourcelocation1 = new ResourceLocation(JsonUtils.getString(jsonobject, "potion"));
                if (!PotionType.REGISTRY.containsKey(resourcelocation1)) {
                    throw new JsonSyntaxException("Unknown potion '" + String.valueOf(resourcelocation1) + "'");
                }
                potiontype = PotionType.REGISTRY.getObject(resourcelocation1);
            }
            return new ItemPredicate(item, integer, minmaxbounds, minmaxbounds1, aenchantmentpredicate, potiontype, nbtpredicate);
        }
        return ANY;
    }

    public static ItemPredicate[] deserializeArray(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonArray jsonarray = JsonUtils.getJsonArray(element, "items");
            ItemPredicate[] aitempredicate = new ItemPredicate[jsonarray.size()];
            for (int i = 0; i < aitempredicate.length; ++i) {
                aitempredicate[i] = ItemPredicate.deserialize(jsonarray.get(i));
            }
            return aitempredicate;
        }
        return new ItemPredicate[0];
    }
}

