/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class MobEffectsPredicate {
    public static final MobEffectsPredicate ANY = new MobEffectsPredicate(Collections.emptyMap());
    private final Map<Potion, InstancePredicate> effects;

    public MobEffectsPredicate(Map<Potion, InstancePredicate> effects) {
        this.effects = effects;
    }

    public boolean test(Entity entityIn) {
        if (this == ANY) {
            return true;
        }
        return entityIn instanceof EntityLivingBase ? this.test(((EntityLivingBase)entityIn).getActivePotionMap()) : false;
    }

    public boolean test(EntityLivingBase entityIn) {
        return this == ANY ? true : this.test(entityIn.getActivePotionMap());
    }

    public boolean test(Map<Potion, PotionEffect> potions) {
        if (this == ANY) {
            return true;
        }
        for (Map.Entry<Potion, InstancePredicate> entry : this.effects.entrySet()) {
            PotionEffect potioneffect = potions.get(entry.getKey());
            if (entry.getValue().test(potioneffect)) continue;
            return false;
        }
        return true;
    }

    public static MobEffectsPredicate deserialize(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonObject jsonobject = JsonUtils.getJsonObject(element, "effects");
            HashMap map = Maps.newHashMap();
            for (Map.Entry entry : jsonobject.entrySet()) {
                ResourceLocation resourcelocation = new ResourceLocation((String)entry.getKey());
                Potion potion = Potion.REGISTRY.getObject(resourcelocation);
                if (potion == null) {
                    throw new JsonSyntaxException("Unknown effect '" + String.valueOf(resourcelocation) + "'");
                }
                InstancePredicate mobeffectspredicate$instancepredicate = InstancePredicate.deserialize(JsonUtils.getJsonObject((JsonElement)entry.getValue(), (String)entry.getKey()));
                map.put(potion, mobeffectspredicate$instancepredicate);
            }
            return new MobEffectsPredicate(map);
        }
        return ANY;
    }

    public static class InstancePredicate {
        private final MinMaxBounds amplifier;
        private final MinMaxBounds duration;
        @Nullable
        private final Boolean ambient;
        @Nullable
        private final Boolean visible;

        public InstancePredicate(MinMaxBounds amplifier, MinMaxBounds duration, @Nullable Boolean ambient, @Nullable Boolean visible) {
            this.amplifier = amplifier;
            this.duration = duration;
            this.ambient = ambient;
            this.visible = visible;
        }

        public boolean test(@Nullable PotionEffect effect) {
            if (effect == null) {
                return false;
            }
            if (!this.amplifier.test(effect.getAmplifier())) {
                return false;
            }
            if (!this.duration.test(effect.getDuration())) {
                return false;
            }
            return this.ambient != null && this.ambient.booleanValue() != effect.getIsAmbient() ? false : this.visible == null || this.visible.booleanValue() == effect.doesShowParticles();
        }

        public static InstancePredicate deserialize(JsonObject object) {
            MinMaxBounds minmaxbounds = MinMaxBounds.deserialize(object.get("amplifier"));
            MinMaxBounds minmaxbounds1 = MinMaxBounds.deserialize(object.get("duration"));
            Boolean obool = object.has("ambient") ? Boolean.valueOf(JsonUtils.getBoolean(object, "ambient")) : null;
            Boolean obool1 = object.has("visible") ? Boolean.valueOf(JsonUtils.getBoolean(object, "visible")) : null;
            return new InstancePredicate(minmaxbounds, minmaxbounds1, obool, obool1);
        }
    }
}

