/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block.state;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MapPopulator;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Cartesian;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStateContainer {
    private static final Pattern NAME_PATTERN = Pattern.compile("^[a-z0-9_]+$");
    private static final Function<IProperty<?>, String> GET_NAME_FUNC = new Function<IProperty<?>, String>(){

        @Nullable
        public String apply(@Nullable IProperty<?> p_apply_1_) {
            return p_apply_1_ == null ? "<NULL>" : p_apply_1_.getName();
        }
    };
    private final Block block;
    private final ImmutableSortedMap<String, IProperty<?>> properties;
    private final ImmutableList<IBlockState> validStates;

    public BlockStateContainer(Block blockIn, IProperty<?> ... properties) {
        this(blockIn, properties, (ImmutableMap<IUnlistedProperty<?>, Optional<?>>)null);
    }

    protected StateImplementation createState(Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties, @Nullable ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
        return new StateImplementation(block, properties);
    }

    protected BlockStateContainer(Block blockIn, IProperty<?>[] properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
        this.block = blockIn;
        HashMap map = Maps.newHashMap();
        for (IProperty<?> iproperty : properties) {
            BlockStateContainer.validateProperty(blockIn, iproperty);
            map.put(iproperty.getName(), iproperty);
        }
        this.properties = ImmutableSortedMap.copyOf((Map)map);
        LinkedHashMap map2 = Maps.newLinkedHashMap();
        ArrayList list1 = Lists.newArrayList();
        for (List<Comparable<?>> list : Cartesian.cartesianProduct(this.getAllowedValues())) {
            Map map1 = MapPopulator.createMap(this.properties.values(), list);
            StateImplementation blockstatecontainer$stateimplementation = this.createState(blockIn, ImmutableMap.copyOf(map1), unlistedProperties);
            map2.put(map1, blockstatecontainer$stateimplementation);
            list1.add(blockstatecontainer$stateimplementation);
        }
        for (StateImplementation blockstatecontainer$stateimplementation1 : list1) {
            blockstatecontainer$stateimplementation1.buildPropertyValueTable(map2);
        }
        this.validStates = ImmutableList.copyOf((Collection)list1);
    }

    public static <T extends Comparable<T>> String validateProperty(Block block, IProperty<T> property) {
        String s = property.getName();
        if (!NAME_PATTERN.matcher(s).matches()) {
            throw new IllegalArgumentException("Block: " + String.valueOf(block.getClass()) + " has invalidly named property: " + s);
        }
        for (Comparable t : property.getAllowedValues()) {
            String s1 = property.getName(t);
            if (NAME_PATTERN.matcher(s1).matches()) continue;
            throw new IllegalArgumentException("Block: " + String.valueOf(block.getClass()) + " has property: " + s + " with invalidly named value: " + s1);
        }
        return s;
    }

    public ImmutableList<IBlockState> getValidStates() {
        return this.validStates;
    }

    private List<Iterable<Comparable<?>>> getAllowedValues() {
        ArrayList list = Lists.newArrayList();
        for (IProperty iproperty : this.properties.values()) {
            list.add(iproperty.getAllowedValues());
        }
        return list;
    }

    public IBlockState getBaseState() {
        return (IBlockState)this.validStates.get(0);
    }

    public Block getBlock() {
        return this.block;
    }

    public Collection<IProperty<?>> getProperties() {
        return this.properties.values();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("block", (Object)Block.REGISTRY.getNameForObject(this.block)).add("properties", (Object)Iterables.transform((Iterable)this.properties.values(), GET_NAME_FUNC)).toString();
    }

    @Nullable
    public IProperty<?> getProperty(String propertyName) {
        return (IProperty)this.properties.get((Object)propertyName);
    }

    public static class StateImplementation
    extends BlockStateBase {
        private final Block block;
        private final ImmutableMap<IProperty<?>, Comparable<?>> properties;
        protected ImmutableTable<IProperty<?>, Comparable<?>, IBlockState> propertyValueTable;

        protected StateImplementation(Block blockIn, ImmutableMap<IProperty<?>, Comparable<?>> propertiesIn) {
            this.block = blockIn;
            this.properties = propertiesIn;
        }

        protected StateImplementation(Block blockIn, ImmutableMap<IProperty<?>, Comparable<?>> propertiesIn, ImmutableTable<IProperty<?>, Comparable<?>, IBlockState> propertyValueTable) {
            this.block = blockIn;
            this.properties = propertiesIn;
            this.propertyValueTable = propertyValueTable;
        }

        @Override
        public Collection<IProperty<?>> getPropertyKeys() {
            return Collections.unmodifiableCollection(this.properties.keySet());
        }

        @Override
        public <T extends Comparable<T>> T getValue(IProperty<T> property) {
            Comparable comparable = (Comparable)this.properties.get(property);
            if (comparable == null) {
                throw new IllegalArgumentException("Cannot get property " + String.valueOf(property) + " as it does not exist in " + String.valueOf(this.block.getBlockState()));
            }
            return (T)((Comparable)property.getValueClass().cast(comparable));
        }

        @Override
        public <T extends Comparable<T>, V extends T> IBlockState withProperty(IProperty<T> property, V value) {
            Comparable comparable = (Comparable)this.properties.get(property);
            if (comparable == null) {
                throw new IllegalArgumentException("Cannot set property " + String.valueOf(property) + " as it does not exist in " + String.valueOf(this.block.getBlockState()));
            }
            if (comparable == value) {
                return this;
            }
            IBlockState iblockstate = (IBlockState)this.propertyValueTable.get(property, value);
            if (iblockstate == null) {
                throw new IllegalArgumentException("Cannot set property " + String.valueOf(property) + " to " + String.valueOf(value) + " on block " + String.valueOf(Block.REGISTRY.getNameForObject(this.block)) + ", it is not an allowed value");
            }
            return iblockstate;
        }

        @Override
        public ImmutableMap<IProperty<?>, Comparable<?>> getProperties() {
            return this.properties;
        }

        @Override
        public Block getBlock() {
            return this.block;
        }

        public boolean equals(Object p_equals_1_) {
            return this == p_equals_1_;
        }

        public int hashCode() {
            return this.properties.hashCode();
        }

        public void buildPropertyValueTable(Map<Map<IProperty<?>, Comparable<?>>, StateImplementation> map) {
            if (this.propertyValueTable != null) {
                throw new IllegalStateException();
            }
            HashBasedTable table = HashBasedTable.create();
            for (Map.Entry entry : this.properties.entrySet()) {
                IProperty iproperty = (IProperty)entry.getKey();
                for (Comparable comparable : iproperty.getAllowedValues()) {
                    if (comparable == entry.getValue()) continue;
                    table.put((Object)iproperty, (Object)comparable, (Object)map.get(this.getPropertiesWithValue(iproperty, comparable)));
                }
            }
            this.propertyValueTable = ImmutableTable.copyOf((Table)table);
        }

        private Map<IProperty<?>, Comparable<?>> getPropertiesWithValue(IProperty<?> property, Comparable<?> value) {
            HashMap map = Maps.newHashMap(this.properties);
            map.put(property, value);
            return map;
        }

        @Override
        public Material getMaterial() {
            return this.block.getMaterial(this);
        }

        @Override
        public boolean isFullBlock() {
            return this.block.isFullBlock(this);
        }

        @Override
        public boolean canEntitySpawn(Entity entityIn) {
            return this.block.canEntitySpawn(this, entityIn);
        }

        @Override
        public int getLightOpacity() {
            return this.block.getLightOpacity(this);
        }

        @Override
        public int getLightValue() {
            return this.block.getLightValue(this);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean isTranslucent() {
            return this.block.isTranslucent(this);
        }

        @Override
        public boolean useNeighborBrightness() {
            return this.block.getUseNeighborBrightness(this);
        }

        @Override
        public MapColor getMapColor(IBlockAccess p_185909_1_, BlockPos p_185909_2_) {
            return this.block.getMapColor(this, p_185909_1_, p_185909_2_);
        }

        @Override
        public IBlockState withRotation(Rotation rot) {
            return this.block.withRotation(this, rot);
        }

        @Override
        public IBlockState withMirror(Mirror mirrorIn) {
            return this.block.withMirror(this, mirrorIn);
        }

        @Override
        public boolean isFullCube() {
            return this.block.isFullCube(this);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean hasCustomBreakingProgress() {
            return this.block.hasCustomBreakingProgress(this);
        }

        @Override
        public EnumBlockRenderType getRenderType() {
            return this.block.getRenderType(this);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int getPackedLightmapCoords(IBlockAccess source, BlockPos pos) {
            return this.block.getPackedLightmapCoords(this, source, pos);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public float getAmbientOcclusionLightValue() {
            return this.block.getAmbientOcclusionLightValue(this);
        }

        @Override
        public boolean isBlockNormalCube() {
            return this.block.isBlockNormalCube(this);
        }

        @Override
        public boolean isNormalCube() {
            return this.block.isNormalCube(this);
        }

        @Override
        public boolean canProvidePower() {
            return this.block.canProvidePower(this);
        }

        @Override
        public int getWeakPower(IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
            return this.block.getWeakPower(this, blockAccess, pos, side);
        }

        @Override
        public boolean hasComparatorInputOverride() {
            return this.block.hasComparatorInputOverride(this);
        }

        @Override
        public int getComparatorInputOverride(World worldIn, BlockPos pos) {
            return this.block.getComparatorInputOverride(this, worldIn, pos);
        }

        @Override
        public float getBlockHardness(World worldIn, BlockPos pos) {
            return this.block.getBlockHardness(this, worldIn, pos);
        }

        @Override
        public float getPlayerRelativeBlockHardness(EntityPlayer player, World worldIn, BlockPos pos) {
            return this.block.getPlayerRelativeBlockHardness(this, player, worldIn, pos);
        }

        @Override
        public int getStrongPower(IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
            return this.block.getStrongPower(this, blockAccess, pos, side);
        }

        @Override
        public EnumPushReaction getPushReaction() {
            return this.block.getPushReaction(this);
        }

        @Override
        public IBlockState getActualState(IBlockAccess blockAccess, BlockPos pos) {
            return this.block.getActualState(this, blockAccess, pos);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public AxisAlignedBB getSelectedBoundingBox(World worldIn, BlockPos pos) {
            return this.block.getSelectedBoundingBox(this, worldIn, pos);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean shouldSideBeRendered(IBlockAccess blockAccess, BlockPos pos, EnumFacing facing) {
            return this.block.shouldSideBeRendered(this, blockAccess, pos, facing);
        }

        @Override
        public boolean isOpaqueCube() {
            return this.block.isOpaqueCube(this);
        }

        @Override
        @Nullable
        public AxisAlignedBB getCollisionBoundingBox(IBlockAccess worldIn, BlockPos pos) {
            return this.block.getCollisionBoundingBox(this, worldIn, pos);
        }

        @Override
        public void addCollisionBoxToList(World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185908_6_) {
            this.block.addCollisionBoxToList(this, worldIn, pos, entityBox, collidingBoxes, entityIn, p_185908_6_);
        }

        @Override
        public AxisAlignedBB getBoundingBox(IBlockAccess blockAccess, BlockPos pos) {
            return this.block.getBoundingBox(this, blockAccess, pos);
        }

        @Override
        public RayTraceResult collisionRayTrace(World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
            return this.block.collisionRayTrace(this, worldIn, pos, start, end);
        }

        @Override
        public boolean isTopSolid() {
            return this.block.isTopSolid(this);
        }

        @Override
        public Vec3d getOffset(IBlockAccess access, BlockPos pos) {
            return this.block.getOffset(this, access, pos);
        }

        @Override
        public boolean onBlockEventReceived(World worldIn, BlockPos pos, int id, int param) {
            return this.block.eventReceived(this, worldIn, pos, id, param);
        }

        @Override
        public void neighborChanged(World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
            this.block.neighborChanged(this, worldIn, pos, blockIn, fromPos);
        }

        @Override
        public boolean causesSuffocation() {
            return this.block.causesSuffocation(this);
        }

        @Override
        public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
            return this.block.getBlockFaceShape(worldIn, this, pos, facing);
        }

        @Override
        public ImmutableTable<IProperty<?>, Comparable<?>, IBlockState> getPropertyValueTable() {
            return this.propertyValueTable;
        }

        @Override
        public int getLightOpacity(IBlockAccess world, BlockPos pos) {
            return this.block.getLightOpacity(this, world, pos);
        }

        @Override
        public int getLightValue(IBlockAccess world, BlockPos pos) {
            return this.block.getLightValue(this, world, pos);
        }

        @Override
        public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
            return this.block.isSideSolid(this, world, pos, side);
        }

        @Override
        public boolean doesSideBlockChestOpening(IBlockAccess world, BlockPos pos, EnumFacing side) {
            return this.block.doesSideBlockChestOpening(this, world, pos, side);
        }

        @Override
        public boolean doesSideBlockRendering(IBlockAccess world, BlockPos pos, EnumFacing side) {
            return this.block.doesSideBlockRendering(this, world, pos, side);
        }
    }

    public static class Builder {
        private final Block block;
        private final List<IProperty<?>> listed = Lists.newArrayList();
        private final List<IUnlistedProperty<?>> unlisted = Lists.newArrayList();

        public Builder(Block block) {
            this.block = block;
        }

        public Builder add(IProperty<?> ... props) {
            for (IProperty<?> prop : props) {
                this.listed.add(prop);
            }
            return this;
        }

        public Builder add(IUnlistedProperty<?> ... props) {
            for (IUnlistedProperty<?> prop : props) {
                this.unlisted.add(prop);
            }
            return this;
        }

        public BlockStateContainer build() {
            IProperty[] listed = new IProperty[this.listed.size()];
            listed = this.listed.toArray(listed);
            if (this.unlisted.size() == 0) {
                return new BlockStateContainer(this.block, listed);
            }
            IUnlistedProperty[] unlisted = new IUnlistedProperty[this.unlisted.size()];
            unlisted = this.unlisted.toArray(unlisted);
            return new ExtendedBlockState(this.block, listed, unlisted);
        }
    }
}

