/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.advancements;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.advancements.AdvancementTabType;
import net.minecraft.client.gui.advancements.GuiAdvancement;
import net.minecraft.client.gui.advancements.GuiAdvancementTab;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.play.client.CPacketSeenAdvancements;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiScreenAdvancements
extends GuiScreen
implements ClientAdvancementManager.IListener {
    private static final ResourceLocation WINDOW = new ResourceLocation("textures/gui/advancements/window.png");
    private static final ResourceLocation TABS = new ResourceLocation("textures/gui/advancements/tabs.png");
    private final ClientAdvancementManager clientAdvancementManager;
    private final Map<Advancement, GuiAdvancementTab> tabs = Maps.newLinkedHashMap();
    private GuiAdvancementTab selectedTab;
    private int scrollMouseX;
    private int scrollMouseY;
    private boolean isScrolling;
    private static int tabPage;
    private static int maxPages;

    public GuiScreenAdvancements(ClientAdvancementManager p_i47383_1_) {
        this.clientAdvancementManager = p_i47383_1_;
    }

    @Override
    public void initGui() {
        this.tabs.clear();
        this.selectedTab = null;
        this.clientAdvancementManager.setListener(this);
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            this.clientAdvancementManager.setSelectedTab(this.tabs.values().iterator().next().getAdvancement(), true);
        } else {
            this.clientAdvancementManager.setSelectedTab(this.selectedTab == null ? null : this.selectedTab.getAdvancement(), true);
        }
        if (this.tabs.size() > AdvancementTabType.MAX_TABS) {
            int guiLeft = (this.width - 252) / 2;
            int guiTop = (this.height - 140) / 2;
            this.buttonList.add(new GuiButton(101, guiLeft, guiTop - 50, 20, 20, "<"));
            this.buttonList.add(new GuiButton(102, guiLeft + 252 - 20, guiTop - 50, 20, 20, ">"));
            maxPages = this.tabs.size() / AdvancementTabType.MAX_TABS;
        }
    }

    @Override
    public void onGuiClosed() {
        this.clientAdvancementManager.setListener(null);
        NetHandlerPlayClient nethandlerplayclient = this.mc.getConnection();
        if (nethandlerplayclient != null) {
            nethandlerplayclient.sendPacket(CPacketSeenAdvancements.closedScreen());
        }
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            int i = (this.width - 252) / 2;
            int j = (this.height - 140) / 2;
            for (GuiAdvancementTab guiadvancementtab : this.tabs.values()) {
                if (guiadvancementtab.getPage() != tabPage || !guiadvancementtab.isMouseOver(i, j, mouseX, mouseY)) continue;
                this.clientAdvancementManager.setSelectedTab(guiadvancementtab.getAdvancement(), true);
                break;
            }
        }
        super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        if (keyCode == this.mc.gameSettings.keyBindAdvancements.getKeyCode()) {
            this.mc.displayGuiScreen(null);
            this.mc.setIngameFocus();
        } else {
            super.keyTyped(typedChar, keyCode);
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        int i = (this.width - 252) / 2;
        int j = (this.height - 140) / 2;
        if (Mouse.isButtonDown((int)0)) {
            if (!this.isScrolling) {
                this.isScrolling = true;
            } else if (this.selectedTab != null) {
                this.selectedTab.scroll(mouseX - this.scrollMouseX, mouseY - this.scrollMouseY);
            }
            this.scrollMouseX = mouseX;
            this.scrollMouseY = mouseY;
        } else {
            this.isScrolling = false;
        }
        this.drawDefaultBackground();
        this.renderInside(mouseX, mouseY, i, j);
        this.renderWindow(i, j);
        super.drawScreen(mouseX, mouseY, partialTicks);
        if (maxPages != 0) {
            String page = String.format("%d / %d", tabPage + 1, maxPages + 1);
            int width = this.fontRenderer.getStringWidth(page);
            GlStateManager.disableLighting();
            this.fontRenderer.drawStringWithShadow(page, i + 126 - width / 2, j - 44, -1);
        }
        this.renderToolTips(mouseX, mouseY, i, j);
    }

    private void renderInside(int p_191936_1_, int p_191936_2_, int p_191936_3_, int p_191936_4_) {
        GuiAdvancementTab guiadvancementtab = this.selectedTab;
        if (guiadvancementtab == null) {
            GuiScreenAdvancements.drawRect(p_191936_3_ + 9, p_191936_4_ + 18, p_191936_3_ + 9 + 234, p_191936_4_ + 18 + 113, -16777216);
            String s = I18n.format("advancements.empty", new Object[0]);
            int i = this.fontRenderer.getStringWidth(s);
            this.fontRenderer.drawString(s, p_191936_3_ + 9 + 117 - i / 2, p_191936_4_ + 18 + 56 - this.fontRenderer.FONT_HEIGHT / 2, -1);
            this.fontRenderer.drawString(":(", p_191936_3_ + 9 + 117 - this.fontRenderer.getStringWidth(":(") / 2, p_191936_4_ + 18 + 113 - this.fontRenderer.FONT_HEIGHT, -1);
        } else {
            GlStateManager.pushMatrix();
            GlStateManager.translate(p_191936_3_ + 9, p_191936_4_ + 18, -400.0f);
            GlStateManager.enableDepth();
            guiadvancementtab.drawContents();
            GlStateManager.popMatrix();
            GlStateManager.depthFunc(515);
            GlStateManager.disableDepth();
        }
    }

    public void renderWindow(int p_191934_1_, int p_191934_2_) {
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.enableBlend();
        RenderHelper.disableStandardItemLighting();
        this.mc.getTextureManager().bindTexture(WINDOW);
        this.drawTexturedModalRect(p_191934_1_, p_191934_2_, 0, 0, 252, 140);
        if (this.tabs.size() > 1) {
            this.mc.getTextureManager().bindTexture(TABS);
            for (GuiAdvancementTab guiadvancementtab : this.tabs.values()) {
                if (guiadvancementtab.getPage() != tabPage) continue;
                guiadvancementtab.drawTab(p_191934_1_, p_191934_2_, guiadvancementtab == this.selectedTab);
            }
            GlStateManager.enableRescaleNormal();
            GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            RenderHelper.enableGUIStandardItemLighting();
            for (GuiAdvancementTab guiadvancementtab1 : this.tabs.values()) {
                if (guiadvancementtab1.getPage() != tabPage) continue;
                guiadvancementtab1.drawIcon(p_191934_1_, p_191934_2_, this.itemRender);
            }
            GlStateManager.disableBlend();
        }
        this.fontRenderer.drawString(I18n.format("gui.advancements", new Object[0]), p_191934_1_ + 8, p_191934_2_ + 6, 0x404040);
    }

    private void renderToolTips(int p_191937_1_, int p_191937_2_, int p_191937_3_, int p_191937_4_) {
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.selectedTab != null) {
            GlStateManager.pushMatrix();
            GlStateManager.enableDepth();
            GlStateManager.translate(p_191937_3_ + 9, p_191937_4_ + 18, 400.0f);
            this.selectedTab.drawToolTips(p_191937_1_ - p_191937_3_ - 9, p_191937_2_ - p_191937_4_ - 18, p_191937_3_, p_191937_4_);
            GlStateManager.disableDepth();
            GlStateManager.popMatrix();
        }
        if (this.tabs.size() > 1) {
            for (GuiAdvancementTab guiadvancementtab : this.tabs.values()) {
                if (guiadvancementtab.getPage() != tabPage || !guiadvancementtab.isMouseOver(p_191937_3_, p_191937_4_, p_191937_1_, p_191937_2_)) continue;
                this.drawHoveringText(guiadvancementtab.getTitle(), p_191937_1_, p_191937_2_);
            }
        }
    }

    @Override
    public void rootAdvancementAdded(Advancement advancementIn) {
        GuiAdvancementTab guiadvancementtab = GuiAdvancementTab.create(this.mc, this, this.tabs.size(), advancementIn);
        if (guiadvancementtab != null) {
            this.tabs.put(advancementIn, guiadvancementtab);
        }
    }

    @Override
    public void rootAdvancementRemoved(Advancement advancementIn) {
    }

    @Override
    public void nonRootAdvancementAdded(Advancement advancementIn) {
        GuiAdvancementTab guiadvancementtab = this.getTab(advancementIn);
        if (guiadvancementtab != null) {
            guiadvancementtab.addAdvancement(advancementIn);
        }
    }

    @Override
    public void nonRootAdvancementRemoved(Advancement advancementIn) {
    }

    @Override
    public void onUpdateAdvancementProgress(Advancement advancementIn, AdvancementProgress progress) {
        GuiAdvancement guiadvancement = this.getAdvancementGui(advancementIn);
        if (guiadvancement != null) {
            guiadvancement.setAdvancementProgress(progress);
        }
    }

    @Override
    public void setSelectedTab(@Nullable Advancement advancementIn) {
        this.selectedTab = this.tabs.get(advancementIn);
    }

    @Override
    public void advancementsCleared() {
        this.tabs.clear();
        this.selectedTab = null;
    }

    @Nullable
    public GuiAdvancement getAdvancementGui(Advancement p_191938_1_) {
        GuiAdvancementTab guiadvancementtab = this.getTab(p_191938_1_);
        return guiadvancementtab == null ? null : guiadvancementtab.getAdvancementGui(p_191938_1_);
    }

    @Nullable
    private GuiAdvancementTab getTab(Advancement p_191935_1_) {
        while (p_191935_1_.getParent() != null) {
            p_191935_1_ = p_191935_1_.getParent();
        }
        return this.tabs.get(p_191935_1_);
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        if (button.id == 101) {
            tabPage = Math.max(tabPage - 1, 0);
        } else if (button.id == 102) {
            tabPage = Math.min(tabPage + 1, maxPages);
        }
    }
}

