/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.recipebook;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.RecipeBook;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RecipeList {
    private List<IRecipe> recipes = Lists.newArrayList();
    private final BitSet craftable = new BitSet();
    private final BitSet canFit = new BitSet();
    private final BitSet inBook = new BitSet();
    private boolean singleResultItem = true;

    public boolean isNotEmpty() {
        return !this.inBook.isEmpty();
    }

    public void updateKnownRecipes(RecipeBook book) {
        for (int i = 0; i < this.recipes.size(); ++i) {
            this.inBook.set(i, book.isUnlocked(this.recipes.get(i)));
        }
    }

    public void canCraft(RecipeItemHelper handler, int width, int height, RecipeBook book) {
        for (int i = 0; i < this.recipes.size(); ++i) {
            IRecipe irecipe = this.recipes.get(i);
            boolean flag = irecipe.canFit(width, height) && book.isUnlocked(irecipe);
            this.canFit.set(i, flag);
            this.craftable.set(i, flag && handler.canCraft(irecipe, null));
        }
    }

    public boolean isCraftable(IRecipe recipe) {
        return this.craftable.get(this.recipes.indexOf(recipe));
    }

    public boolean containsCraftableRecipes() {
        return !this.craftable.isEmpty();
    }

    public boolean containsValidRecipes() {
        return !this.canFit.isEmpty();
    }

    public List<IRecipe> getRecipes() {
        return this.recipes;
    }

    public List<IRecipe> getRecipes(boolean onlyCraftable) {
        ArrayList list = Lists.newArrayList();
        int i = this.inBook.nextSetBit(0);
        while (i >= 0) {
            if ((onlyCraftable ? this.craftable : this.canFit).get(i)) {
                list.add(this.recipes.get(i));
            }
            i = this.inBook.nextSetBit(i + 1);
        }
        return list;
    }

    public List<IRecipe> getDisplayRecipes(boolean onlyCraftable) {
        ArrayList list = Lists.newArrayList();
        int i = this.inBook.nextSetBit(0);
        while (i >= 0) {
            if (this.canFit.get(i) && this.craftable.get(i) == onlyCraftable) {
                list.add(this.recipes.get(i));
            }
            i = this.inBook.nextSetBit(i + 1);
        }
        return list;
    }

    public void add(IRecipe recipe) {
        this.recipes.add(recipe);
        if (this.singleResultItem) {
            ItemStack itemstack1;
            ItemStack itemstack = this.recipes.get(0).getRecipeOutput();
            this.singleResultItem = ItemStack.areItemsEqual(itemstack, itemstack1 = recipe.getRecipeOutput()) && ItemStack.areItemStackTagsEqual(itemstack, itemstack1);
        }
    }

    public boolean hasSingleResultItem() {
        return this.singleResultItem;
    }
}

