/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.toasts;

import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AdvancementToast
implements IToast {
    private final Advancement advancement;
    private boolean hasPlayedSound = false;

    public AdvancementToast(Advancement advancementIn) {
        this.advancement = advancementIn;
    }

    @Override
    public IToast.Visibility draw(GuiToast toastGui, long delta) {
        toastGui.getMinecraft().getTextureManager().bindTexture(TEXTURE_TOASTS);
        GlStateManager.color(1.0f, 1.0f, 1.0f);
        DisplayInfo displayinfo = this.advancement.getDisplay();
        toastGui.drawTexturedModalRect(0, 0, 0, 0, 160, 32);
        if (displayinfo != null) {
            int i;
            List<String> list = toastGui.getMinecraft().fontRenderer.listFormattedStringToWidth(displayinfo.getTitle().getFormattedText(), 125);
            int n = i = displayinfo.getFrame() == FrameType.CHALLENGE ? 0xFF88FF : 0xFFFF00;
            if (list.size() == 1) {
                toastGui.getMinecraft().fontRenderer.drawString(I18n.format("advancements.toast." + displayinfo.getFrame().getName(), new Object[0]), 30, 7, i | 0xFF000000);
                toastGui.getMinecraft().fontRenderer.drawString(displayinfo.getTitle().getFormattedText(), 30, 18, -1);
            } else {
                int j = 1500;
                float f = 300.0f;
                if (delta < 1500L) {
                    int k = MathHelper.floor(MathHelper.clamp((float)(1500L - delta) / 300.0f, 0.0f, 1.0f) * 255.0f) << 24 | 0x4000000;
                    toastGui.getMinecraft().fontRenderer.drawString(I18n.format("advancements.toast." + displayinfo.getFrame().getName(), new Object[0]), 30, 11, i | k);
                } else {
                    int i1 = MathHelper.floor(MathHelper.clamp((float)(delta - 1500L) / 300.0f, 0.0f, 1.0f) * 252.0f) << 24 | 0x4000000;
                    int l = 16 - list.size() * toastGui.getMinecraft().fontRenderer.FONT_HEIGHT / 2;
                    for (String s : list) {
                        toastGui.getMinecraft().fontRenderer.drawString(s, 30, l, 0xFFFFFF | i1);
                        l += toastGui.getMinecraft().fontRenderer.FONT_HEIGHT;
                    }
                }
            }
            if (!this.hasPlayedSound && delta > 0L) {
                this.hasPlayedSound = true;
                if (displayinfo.getFrame() == FrameType.CHALLENGE) {
                    toastGui.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.getRecord(SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f));
                }
            }
            RenderHelper.enableGUIStandardItemLighting();
            toastGui.getMinecraft().getRenderItem().renderItemAndEffectIntoGUI(null, displayinfo.getIcon(), 8, 8);
            return delta >= 5000L ? IToast.Visibility.HIDE : IToast.Visibility.SHOW;
        }
        return IToast.Visibility.HIDE;
    }
}

