/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.toasts;

import com.google.common.collect.Queues;
import java.util.Arrays;
import java.util.Deque;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiToast
extends Gui {
    private final Minecraft mc;
    private final ToastInstance<?>[] visible = new ToastInstance[5];
    private final Deque<IToast> toastsQueue = Queues.newArrayDeque();

    public GuiToast(Minecraft mcIn) {
        this.mc = mcIn;
    }

    public void drawToast(ScaledResolution resolution) {
        if (!this.mc.gameSettings.hideGUI) {
            RenderHelper.disableStandardItemLighting();
            for (int i = 0; i < this.visible.length; ++i) {
                ToastInstance<?> toastinstance = this.visible[i];
                if (toastinstance != null && toastinstance.render(resolution.getScaledWidth(), i)) {
                    this.visible[i] = null;
                }
                if (this.visible[i] != null || this.toastsQueue.isEmpty()) continue;
                this.visible[i] = new ToastInstance(this, this.toastsQueue.removeFirst());
            }
        }
    }

    @Nullable
    public <T extends IToast> T getToast(Class<? extends T> p_192990_1_, Object p_192990_2_) {
        for (ToastInstance<?> toastinstance : this.visible) {
            if (toastinstance == null || !p_192990_1_.isAssignableFrom(toastinstance.getToast().getClass()) || !toastinstance.getToast().getType().equals(p_192990_2_)) continue;
            return (T)toastinstance.getToast();
        }
        for (IToast itoast : this.toastsQueue) {
            if (!p_192990_1_.isAssignableFrom(itoast.getClass()) || !itoast.getType().equals(p_192990_2_)) continue;
            return (T)itoast;
        }
        return null;
    }

    public void clear() {
        Arrays.fill(this.visible, null);
        this.toastsQueue.clear();
    }

    public void add(IToast toastIn) {
        this.toastsQueue.add(toastIn);
    }

    public Minecraft getMinecraft() {
        return this.mc;
    }

    @SideOnly(value=Side.CLIENT)
    static class ToastInstance<T extends IToast> {
        private final T toast;
        private long animationTime = -1L;
        private long visibleTime = -1L;
        private IToast.Visibility visibility = IToast.Visibility.SHOW;
        final /* synthetic */ GuiToast this$0;

        private ToastInstance(T toastIn) {
            this.this$0 = this$0;
            this.toast = toastIn;
        }

        public T getToast() {
            return this.toast;
        }

        private float getVisibility(long p_193686_1_) {
            float f = MathHelper.clamp((float)(p_193686_1_ - this.animationTime) / 600.0f, 0.0f, 1.0f);
            f *= f;
            return this.visibility == IToast.Visibility.HIDE ? 1.0f - f : f;
        }

        public boolean render(int p_193684_1_, int p_193684_2_) {
            long i = Minecraft.getSystemTime();
            if (this.animationTime == -1L) {
                this.animationTime = i;
                this.visibility.playSound(this.this$0.mc.getSoundHandler());
            }
            if (this.visibility == IToast.Visibility.SHOW && i - this.animationTime <= 600L) {
                this.visibleTime = i;
            }
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)p_193684_1_ - 160.0f * this.getVisibility(i), p_193684_2_ * 32, 500 + p_193684_2_);
            IToast.Visibility itoast$visibility = this.toast.draw(this.this$0, i - this.visibleTime);
            GlStateManager.popMatrix();
            if (itoast$visibility != this.visibility) {
                this.animationTime = i - (long)((int)((1.0f - this.getVisibility(i)) * 600.0f));
                this.visibility = itoast$visibility;
                this.visibility.playSound(this.this$0.mc.getSoundHandler());
            }
            return this.visibility == IToast.Visibility.HIDE && i - this.animationTime > 600L;
        }
    }
}

