/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ChunkProviderClient
implements IChunkProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Chunk blankChunk;
    private final Long2ObjectMap<Chunk> loadedChunks = new Long2ObjectOpenHashMap<Chunk>(8192){

        protected void rehash(int p_rehash_1_) {
            if (p_rehash_1_ > this.key.length) {
                super.rehash(p_rehash_1_);
            }
        }
    };
    private final World world;

    public ChunkProviderClient(World worldIn) {
        this.blankChunk = new EmptyChunk(worldIn, 0, 0);
        this.world = worldIn;
    }

    public void unloadChunk(int x, int z) {
        Chunk chunk = this.provideChunk(x, z);
        if (!chunk.isEmpty()) {
            chunk.onUnload();
        }
        this.loadedChunks.remove(ChunkPos.asLong(x, z));
    }

    @Override
    @Nullable
    public Chunk getLoadedChunk(int x, int z) {
        return (Chunk)this.loadedChunks.get(ChunkPos.asLong(x, z));
    }

    public Chunk loadChunk(int chunkX, int chunkZ) {
        Chunk chunk = new Chunk(this.world, chunkX, chunkZ);
        this.loadedChunks.put(ChunkPos.asLong(chunkX, chunkZ), (Object)chunk);
        MinecraftForge.EVENT_BUS.post(new ChunkEvent.Load(chunk));
        chunk.markLoaded(true);
        return chunk;
    }

    @Override
    public Chunk provideChunk(int x, int z) {
        return (Chunk)MoreObjects.firstNonNull((Object)this.getLoadedChunk(x, z), (Object)this.blankChunk);
    }

    @Override
    public boolean tick() {
        long i = System.currentTimeMillis();
        for (Chunk chunk : this.loadedChunks.values()) {
            chunk.onTick(System.currentTimeMillis() - i > 5L);
        }
        if (System.currentTimeMillis() - i > 100L) {
            LOGGER.info("Warning: Clientside chunk ticking took {} ms", (Object)(System.currentTimeMillis() - i));
        }
        return false;
    }

    @Override
    public String makeString() {
        return "MultiplayerChunkCache: " + this.loadedChunks.size() + ", " + this.loadedChunks.size();
    }

    @Override
    public boolean isChunkGeneratedAt(int x, int z) {
        return this.loadedChunks.containsKey(ChunkPos.asLong(x, z));
    }
}

