/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.AdvancementToast;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.play.client.CPacketSeenAdvancements;
import net.minecraft.network.play.server.SPacketAdvancementInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ClientAdvancementManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Minecraft mc;
    private final AdvancementList advancementList = new AdvancementList();
    private final Map<Advancement, AdvancementProgress> advancementToProgress = Maps.newHashMap();
    @Nullable
    private IListener listener;
    @Nullable
    private Advancement selectedTab;

    public ClientAdvancementManager(Minecraft p_i47380_1_) {
        this.mc = p_i47380_1_;
    }

    public void read(SPacketAdvancementInfo packetIn) {
        if (packetIn.isFirstSync()) {
            this.advancementList.clear();
            this.advancementToProgress.clear();
        }
        this.advancementList.removeAll(packetIn.getAdvancementsToRemove());
        this.advancementList.loadAdvancements(packetIn.getAdvancementsToAdd());
        for (Map.Entry<ResourceLocation, AdvancementProgress> entry : packetIn.getProgressUpdates().entrySet()) {
            Advancement advancement = this.advancementList.getAdvancement(entry.getKey());
            if (advancement != null) {
                AdvancementProgress advancementprogress = entry.getValue();
                advancementprogress.update(advancement.getCriteria(), advancement.getRequirements());
                this.advancementToProgress.put(advancement, advancementprogress);
                if (this.listener != null) {
                    this.listener.onUpdateAdvancementProgress(advancement, advancementprogress);
                }
                if (packetIn.isFirstSync() || !advancementprogress.isDone() || advancement.getDisplay() == null || !advancement.getDisplay().shouldShowToast()) continue;
                this.mc.getToastGui().add(new AdvancementToast(advancement));
                continue;
            }
            LOGGER.warn("Server informed client about progress for unknown advancement " + String.valueOf(entry.getKey()));
        }
    }

    public AdvancementList getAdvancementList() {
        return this.advancementList;
    }

    public void setSelectedTab(@Nullable Advancement advancementIn, boolean tellServer) {
        NetHandlerPlayClient nethandlerplayclient = this.mc.getConnection();
        if (nethandlerplayclient != null && advancementIn != null && tellServer) {
            nethandlerplayclient.sendPacket(CPacketSeenAdvancements.openedTab(advancementIn));
        }
        if (this.selectedTab != advancementIn) {
            this.selectedTab = advancementIn;
            if (this.listener != null) {
                this.listener.setSelectedTab(advancementIn);
            }
        }
    }

    public void setListener(@Nullable IListener listenerIn) {
        this.listener = listenerIn;
        this.advancementList.setListener(listenerIn);
        if (listenerIn != null) {
            for (Map.Entry<Advancement, AdvancementProgress> entry : this.advancementToProgress.entrySet()) {
                listenerIn.onUpdateAdvancementProgress(entry.getKey(), entry.getValue());
            }
            listenerIn.setSelectedTab(this.selectedTab);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static interface IListener
    extends AdvancementList.Listener {
        public void onUpdateAdvancementProgress(Advancement var1, AdvancementProgress var2);

        public void setSelectedTab(@Nullable Advancement var1);
    }
}

