/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.debug.DebugRendererChunkBorder;
import net.minecraft.client.renderer.debug.DebugRendererCollisionBox;
import net.minecraft.client.renderer.debug.DebugRendererHeightMap;
import net.minecraft.client.renderer.debug.DebugRendererNeighborsUpdate;
import net.minecraft.client.renderer.debug.DebugRendererPathfinding;
import net.minecraft.client.renderer.debug.DebugRendererSolidFace;
import net.minecraft.client.renderer.debug.DebugRendererWater;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DebugRenderer {
    public final IDebugRenderer pathfinding;
    public final IDebugRenderer water;
    public final IDebugRenderer chunkBorder;
    public final IDebugRenderer heightMap;
    public final IDebugRenderer collisionBox;
    public final IDebugRenderer neighborsUpdate;
    public final IDebugRenderer solidFace;
    private boolean chunkBorderEnabled;
    private boolean pathfindingEnabled;
    private boolean waterEnabled;
    private boolean heightMapEnabled;
    private boolean collisionBoxEnabled;
    private boolean neighborsUpdateEnabled;
    private boolean solidFaceEnabled;

    public DebugRenderer(Minecraft clientIn) {
        this.pathfinding = new DebugRendererPathfinding(clientIn);
        this.water = new DebugRendererWater(clientIn);
        this.chunkBorder = new DebugRendererChunkBorder(clientIn);
        this.heightMap = new DebugRendererHeightMap(clientIn);
        this.collisionBox = new DebugRendererCollisionBox(clientIn);
        this.neighborsUpdate = new DebugRendererNeighborsUpdate(clientIn);
        this.solidFace = new DebugRendererSolidFace(clientIn);
    }

    public boolean shouldRender() {
        return this.chunkBorderEnabled || this.pathfindingEnabled || this.waterEnabled || this.heightMapEnabled || this.collisionBoxEnabled || this.neighborsUpdateEnabled || this.solidFaceEnabled;
    }

    public boolean toggleChunkBorders() {
        this.chunkBorderEnabled = !this.chunkBorderEnabled;
        return this.chunkBorderEnabled;
    }

    public void renderDebug(float partialTicks, long finishTimeNano) {
        if (this.pathfindingEnabled) {
            this.pathfinding.render(partialTicks, finishTimeNano);
        }
        if (this.chunkBorderEnabled && !Minecraft.getMinecraft().isReducedDebug()) {
            this.chunkBorder.render(partialTicks, finishTimeNano);
        }
        if (this.waterEnabled) {
            this.water.render(partialTicks, finishTimeNano);
        }
        if (this.heightMapEnabled) {
            this.heightMap.render(partialTicks, finishTimeNano);
        }
        if (this.collisionBoxEnabled) {
            this.collisionBox.render(partialTicks, finishTimeNano);
        }
        if (this.neighborsUpdateEnabled) {
            this.neighborsUpdate.render(partialTicks, finishTimeNano);
        }
        if (this.solidFaceEnabled) {
            this.solidFace.render(partialTicks, finishTimeNano);
        }
    }

    public static void renderDebugText(String str, int x, int y, int z, float partialTicks, int color) {
        DebugRenderer.renderDebugText(str, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, partialTicks, color);
    }

    public static void renderDebugText(String str, double x, double y, double z, float partialTicks, int color) {
        Minecraft minecraft = Minecraft.getMinecraft();
        if (minecraft.player != null && minecraft.getRenderManager() != null && minecraft.getRenderManager().options != null) {
            FontRenderer fontrenderer = minecraft.fontRenderer;
            EntityPlayerSP entityplayer = minecraft.player;
            double d0 = entityplayer.lastTickPosX + (entityplayer.posX - entityplayer.lastTickPosX) * (double)partialTicks;
            double d1 = entityplayer.lastTickPosY + (entityplayer.posY - entityplayer.lastTickPosY) * (double)partialTicks;
            double d2 = entityplayer.lastTickPosZ + (entityplayer.posZ - entityplayer.lastTickPosZ) * (double)partialTicks;
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)(x - d0), (float)(y - d1) + 0.07f, (float)(z - d2));
            GlStateManager.glNormal3f(0.0f, 1.0f, 0.0f);
            GlStateManager.scale(0.02f, -0.02f, 0.02f);
            RenderManager rendermanager = minecraft.getRenderManager();
            GlStateManager.rotate(-rendermanager.playerViewY, 0.0f, 1.0f, 0.0f);
            GlStateManager.rotate((float)(rendermanager.options.thirdPersonView == 2 ? 1 : -1) * rendermanager.playerViewX, 1.0f, 0.0f, 0.0f);
            GlStateManager.disableLighting();
            GlStateManager.enableTexture2D();
            GlStateManager.enableDepth();
            GlStateManager.depthMask(true);
            GlStateManager.scale(-1.0f, 1.0f, 1.0f);
            fontrenderer.drawString(str, -fontrenderer.getStringWidth(str) / 2, 0, color);
            GlStateManager.enableLighting();
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.popMatrix();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static interface IDebugRenderer {
        public void render(float var1, long var2);
    }
}

