/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DebugRendererPathfinding
implements DebugRenderer.IDebugRenderer {
    private final Minecraft minecraft;
    private final Map<Integer, Path> pathMap = Maps.newHashMap();
    private final Map<Integer, Float> pathMaxDistance = Maps.newHashMap();
    private final Map<Integer, Long> creationMap = Maps.newHashMap();
    private EntityPlayer player;
    private double xo;
    private double yo;
    private double zo;

    public DebugRendererPathfinding(Minecraft minecraftIn) {
        this.minecraft = minecraftIn;
    }

    public void addPath(int eid, Path pathIn, float distance) {
        this.pathMap.put(eid, pathIn);
        this.creationMap.put(eid, System.currentTimeMillis());
        this.pathMaxDistance.put(eid, Float.valueOf(distance));
    }

    @Override
    public void render(float partialTicks, long finishTimeNano) {
        if (!this.pathMap.isEmpty()) {
            long i = System.currentTimeMillis();
            this.player = this.minecraft.player;
            this.xo = this.player.lastTickPosX + (this.player.posX - this.player.lastTickPosX) * (double)partialTicks;
            this.yo = this.player.lastTickPosY + (this.player.posY - this.player.lastTickPosY) * (double)partialTicks;
            this.zo = this.player.lastTickPosZ + (this.player.posZ - this.player.lastTickPosZ) * (double)partialTicks;
            GlStateManager.pushMatrix();
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            GlStateManager.color(0.0f, 1.0f, 0.0f, 0.75f);
            GlStateManager.disableTexture2D();
            GlStateManager.glLineWidth(6.0f);
            for (Integer integer : this.pathMap.keySet()) {
                Path path = this.pathMap.get(integer);
                float f = this.pathMaxDistance.get(integer).floatValue();
                this.renderPathLine(partialTicks, path);
                PathPoint pathpoint = path.getTarget();
                if (this.addDistanceToPlayer(pathpoint) > 40.0f) continue;
                RenderGlobal.renderFilledBox(new AxisAlignedBB((float)pathpoint.x + 0.25f, (float)pathpoint.y + 0.25f, (double)pathpoint.z + 0.25, (float)pathpoint.x + 0.75f, (float)pathpoint.y + 0.75f, (float)pathpoint.z + 0.75f).offset(-this.xo, -this.yo, -this.zo), 0.0f, 1.0f, 0.0f, 0.5f);
                for (int j = 0; j < path.getCurrentPathLength(); ++j) {
                    PathPoint pathpoint1 = path.getPathPointFromIndex(j);
                    if (this.addDistanceToPlayer(pathpoint1) > 40.0f) continue;
                    float f1 = j == path.getCurrentPathIndex() ? 1.0f : 0.0f;
                    float f2 = j == path.getCurrentPathIndex() ? 0.0f : 1.0f;
                    RenderGlobal.renderFilledBox(new AxisAlignedBB((float)pathpoint1.x + 0.5f - f, (float)pathpoint1.y + 0.01f * (float)j, (float)pathpoint1.z + 0.5f - f, (float)pathpoint1.x + 0.5f + f, (float)pathpoint1.y + 0.25f + 0.01f * (float)j, (float)pathpoint1.z + 0.5f + f).offset(-this.xo, -this.yo, -this.zo), f1, 0.0f, f2, 0.5f);
                }
            }
            for (Integer integer1 : this.pathMap.keySet()) {
                Path path1 = this.pathMap.get(integer1);
                for (PathPoint pathpoint3 : path1.getClosedSet()) {
                    if (this.addDistanceToPlayer(pathpoint3) > 40.0f) continue;
                    DebugRenderer.renderDebugText(String.format("%s", new Object[]{pathpoint3.nodeType}), (double)pathpoint3.x + 0.5, (double)pathpoint3.y + 0.75, (double)pathpoint3.z + 0.5, partialTicks, -65536);
                    DebugRenderer.renderDebugText(String.format("%.2f", Float.valueOf(pathpoint3.costMalus)), (double)pathpoint3.x + 0.5, (double)pathpoint3.y + 0.25, (double)pathpoint3.z + 0.5, partialTicks, -65536);
                }
                for (PathPoint pathpoint4 : path1.getOpenSet()) {
                    if (this.addDistanceToPlayer(pathpoint4) > 40.0f) continue;
                    DebugRenderer.renderDebugText(String.format("%s", new Object[]{pathpoint4.nodeType}), (double)pathpoint4.x + 0.5, (double)pathpoint4.y + 0.75, (double)pathpoint4.z + 0.5, partialTicks, -16776961);
                    DebugRenderer.renderDebugText(String.format("%.2f", Float.valueOf(pathpoint4.costMalus)), (double)pathpoint4.x + 0.5, (double)pathpoint4.y + 0.25, (double)pathpoint4.z + 0.5, partialTicks, -16776961);
                }
                for (int k = 0; k < path1.getCurrentPathLength(); ++k) {
                    PathPoint pathpoint2 = path1.getPathPointFromIndex(k);
                    if (this.addDistanceToPlayer(pathpoint2) > 40.0f) continue;
                    DebugRenderer.renderDebugText(String.format("%s", new Object[]{pathpoint2.nodeType}), (double)pathpoint2.x + 0.5, (double)pathpoint2.y + 0.75, (double)pathpoint2.z + 0.5, partialTicks, -1);
                    DebugRenderer.renderDebugText(String.format("%.2f", Float.valueOf(pathpoint2.costMalus)), (double)pathpoint2.x + 0.5, (double)pathpoint2.y + 0.25, (double)pathpoint2.z + 0.5, partialTicks, -1);
                }
            }
            for (Integer integer2 : this.creationMap.keySet().toArray(new Integer[0])) {
                if (i - this.creationMap.get(integer2) <= 20000L) continue;
                this.pathMap.remove(integer2);
                this.creationMap.remove(integer2);
            }
            GlStateManager.enableTexture2D();
            GlStateManager.disableBlend();
            GlStateManager.popMatrix();
        }
    }

    public void renderPathLine(float finishTimeNano, Path pathIn) {
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder bufferbuilder = tessellator.getBuffer();
        bufferbuilder.begin(3, DefaultVertexFormats.POSITION_COLOR);
        for (int i = 0; i < pathIn.getCurrentPathLength(); ++i) {
            PathPoint pathpoint = pathIn.getPathPointFromIndex(i);
            if (this.addDistanceToPlayer(pathpoint) > 40.0f) continue;
            float f = (float)i / (float)pathIn.getCurrentPathLength() * 0.33f;
            int j = i == 0 ? 0 : MathHelper.hsvToRGB(f, 0.9f, 0.9f);
            int k = j >> 16 & 0xFF;
            int l = j >> 8 & 0xFF;
            int i1 = j & 0xFF;
            bufferbuilder.pos((double)pathpoint.x - this.xo + 0.5, (double)pathpoint.y - this.yo + 0.5, (double)pathpoint.z - this.zo + 0.5).color(k, l, i1, 255).endVertex();
        }
        tessellator.draw();
    }

    private float addDistanceToPlayer(PathPoint point) {
        return (float)(Math.abs((double)point.x - this.player.posX) + Math.abs((double)point.y - this.player.posY) + Math.abs((double)point.z - this.player.posZ));
    }
}

