/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import net.minecraft.client.model.ModelBed;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityBedRenderer
extends TileEntitySpecialRenderer<TileEntityBed> {
    private static final ResourceLocation[] TEXTURES;
    private ModelBed model = new ModelBed();
    private int version = this.model.getModelVersion();

    @Override
    public void render(TileEntityBed te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        int i;
        if (this.version != this.model.getModelVersion()) {
            this.model = new ModelBed();
            this.version = this.model.getModelVersion();
        }
        boolean flag = te.getWorld() != null;
        boolean flag1 = flag ? te.isHeadPiece() : true;
        EnumDyeColor enumdyecolor = te != null ? te.getColor() : EnumDyeColor.RED;
        int n = i = flag ? te.getBlockMetadata() & 3 : 0;
        if (destroyStage >= 0) {
            this.bindTexture(DESTROY_STAGES[destroyStage]);
            GlStateManager.matrixMode(5890);
            GlStateManager.pushMatrix();
            GlStateManager.scale(4.0f, 4.0f, 1.0f);
            GlStateManager.translate(0.0625f, 0.0625f, 0.0625f);
            GlStateManager.matrixMode(5888);
        } else {
            ResourceLocation resourcelocation = TEXTURES[enumdyecolor.getMetadata()];
            if (resourcelocation != null) {
                this.bindTexture(resourcelocation);
            }
        }
        if (flag) {
            this.renderPiece(flag1, x, y, z, i, alpha);
        } else {
            GlStateManager.pushMatrix();
            this.renderPiece(true, x, y, z, i, alpha);
            this.renderPiece(false, x, y, z - 1.0, i, alpha);
            GlStateManager.popMatrix();
        }
        if (destroyStage >= 0) {
            GlStateManager.matrixMode(5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode(5888);
        }
    }

    private void renderPiece(boolean p_193847_1_, double x, double y, double z, int p_193847_8_, float alpha) {
        this.model.preparePiece(p_193847_1_);
        GlStateManager.pushMatrix();
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        if (p_193847_8_ == EnumFacing.NORTH.getHorizontalIndex()) {
            f = 0.0f;
        } else if (p_193847_8_ == EnumFacing.SOUTH.getHorizontalIndex()) {
            f = 180.0f;
            f1 = 1.0f;
            f2 = 1.0f;
        } else if (p_193847_8_ == EnumFacing.WEST.getHorizontalIndex()) {
            f = -90.0f;
            f2 = 1.0f;
        } else if (p_193847_8_ == EnumFacing.EAST.getHorizontalIndex()) {
            f = 90.0f;
            f1 = 1.0f;
        }
        GlStateManager.translate((float)x + f1, (float)y + 0.5625f, (float)z + f2);
        GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate(f, 0.0f, 0.0f, 1.0f);
        GlStateManager.enableRescaleNormal();
        GlStateManager.pushMatrix();
        this.model.render();
        GlStateManager.popMatrix();
        GlStateManager.color(1.0f, 1.0f, 1.0f, alpha);
        GlStateManager.popMatrix();
    }

    static {
        EnumDyeColor[] aenumdyecolor = EnumDyeColor.values();
        TEXTURES = new ResourceLocation[aenumdyecolor.length];
        for (EnumDyeColor enumdyecolor : aenumdyecolor) {
            TileEntityBedRenderer.TEXTURES[enumdyecolor.getMetadata()] = new ResourceLocation("textures/entity/bed/" + enumdyecolor.getDyeColorName() + ".png");
        }
    }
}

