/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.gson.JsonParseException;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreenResourcePacks;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackListEntry;
import net.minecraft.client.resources.data.PackMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ResourcePackListEntryServer
extends ResourcePackListEntry {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IResourcePack resourcePack;
    private final ResourceLocation resourcePackIcon;

    public ResourcePackListEntryServer(GuiScreenResourcePacks resourcePacksGUIIn, IResourcePack resourcePackIn) {
        super(resourcePacksGUIIn);
        DynamicTexture dynamictexture;
        this.resourcePack = resourcePackIn;
        try {
            dynamictexture = new DynamicTexture(resourcePackIn.getPackImage());
        }
        catch (IOException ioexception) {
            dynamictexture = TextureUtil.MISSING_TEXTURE;
        }
        this.resourcePackIcon = this.mc.getTextureManager().getDynamicTextureLocation("texturepackicon", dynamictexture);
    }

    @Override
    protected int getResourcePackFormat() {
        return 3;
    }

    @Override
    protected String getResourcePackDescription() {
        try {
            PackMetadataSection packmetadatasection = (PackMetadataSection)this.resourcePack.getPackMetadata(this.mc.getResourcePackRepository().rprMetadataSerializer, "pack");
            if (packmetadatasection != null) {
                return packmetadatasection.getPackDescription().getFormattedText();
            }
        }
        catch (JsonParseException jsonparseexception) {
            LOGGER.error("Couldn't load metadata info", (Throwable)jsonparseexception);
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't load metadata info", (Throwable)ioexception);
        }
        return String.valueOf((Object)TextFormatting.RED) + "Missing pack.mcmeta :(";
    }

    @Override
    protected boolean canMoveRight() {
        return false;
    }

    @Override
    protected boolean canMoveLeft() {
        return false;
    }

    @Override
    protected boolean canMoveUp() {
        return false;
    }

    @Override
    protected boolean canMoveDown() {
        return false;
    }

    @Override
    protected String getResourcePackName() {
        return "Server";
    }

    @Override
    protected void bindResourcePackIcon() {
        this.mc.getTextureManager().bindTexture(this.resourcePackIcon);
    }

    @Override
    protected boolean showHoverOverlay() {
        return false;
    }

    @Override
    public boolean isServerPack() {
        return true;
    }
}

