/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.RecipeBook;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RecipeBookClient
extends RecipeBook {
    public static final Map<CreativeTabs, List<RecipeList>> RECIPES_BY_TAB = Maps.newHashMap();
    public static final List<RecipeList> ALL_RECIPES = Lists.newArrayList();

    private static RecipeList newRecipeList(CreativeTabs srcTab) {
        RecipeList recipelist = new RecipeList();
        ALL_RECIPES.add(recipelist);
        RECIPES_BY_TAB.computeIfAbsent(srcTab, p_194085_0_ -> new ArrayList()).add(recipelist);
        RECIPES_BY_TAB.computeIfAbsent(CreativeTabs.SEARCH, p_194083_0_ -> new ArrayList()).add(recipelist);
        return recipelist;
    }

    private static CreativeTabs getItemStackTab(ItemStack stackIn) {
        CreativeTabs creativetabs = stackIn.getItem().getCreativeTab();
        if (creativetabs == CreativeTabs.BUILDING_BLOCKS || creativetabs == CreativeTabs.TOOLS || creativetabs == CreativeTabs.REDSTONE) {
            return creativetabs;
        }
        return creativetabs == CreativeTabs.COMBAT ? CreativeTabs.TOOLS : CreativeTabs.MISC;
    }

    public static void rebuildTable() {
        RECIPES_BY_TAB.clear();
        ALL_RECIPES.clear();
        HashBasedTable table = HashBasedTable.create();
        for (IRecipe irecipe : CraftingManager.REGISTRY) {
            RecipeList recipelist;
            if (irecipe.isDynamic()) continue;
            CreativeTabs creativetabs = RecipeBookClient.getItemStackTab(irecipe.getRecipeOutput());
            String s = irecipe.getGroup();
            if (s.isEmpty()) {
                recipelist = RecipeBookClient.newRecipeList(creativetabs);
            } else {
                recipelist = (RecipeList)table.get((Object)creativetabs, (Object)s);
                if (recipelist == null) {
                    recipelist = RecipeBookClient.newRecipeList(creativetabs);
                    table.put((Object)creativetabs, (Object)s, (Object)recipelist);
                }
            }
            recipelist.add(irecipe);
        }
    }

    static {
        RecipeBookClient.rebuildTable();
    }
}

