/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.client.util.ISearchTree;
import net.minecraft.client.util.SuffixArray;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SearchTree<T>
implements ISearchTree<T> {
    protected SuffixArray<T> byName = new SuffixArray();
    protected SuffixArray<T> byId = new SuffixArray();
    private final Function<T, Iterable<String>> nameFunc;
    private final Function<T, Iterable<ResourceLocation>> idFunc;
    private final List<T> contents = Lists.newArrayList();
    private Object2IntMap<T> numericContents = new Object2IntOpenHashMap();

    public SearchTree(Function<T, Iterable<String>> nameFuncIn, Function<T, Iterable<ResourceLocation>> idFuncIn) {
        this.nameFunc = nameFuncIn;
        this.idFunc = idFuncIn;
    }

    public void recalculate() {
        this.byName = new SuffixArray();
        this.byId = new SuffixArray();
        for (T t : this.contents) {
            this.index(t);
        }
        this.byName.generate();
        this.byId.generate();
    }

    public void add(T element) {
        this.numericContents.put(element, this.contents.size());
        this.contents.add(element);
        this.index(element);
    }

    private void index(T element) {
        this.idFunc.apply(element).forEach(p_194039_2_ -> this.byId.add(element, p_194039_2_.toString().toLowerCase(Locale.ROOT)));
        this.nameFunc.apply(element).forEach(p_194041_2_ -> this.byName.add(element, p_194041_2_.toLowerCase(Locale.ROOT)));
    }

    @Override
    public List<T> search(String searchText) {
        ArrayList list = this.byName.search(searchText);
        if (searchText.indexOf(58) < 0) {
            return list;
        }
        List<T> list1 = this.byId.search(searchText);
        return list1.isEmpty() ? list : Lists.newArrayList(new MergingIterator<T>(list.iterator(), list1.iterator(), this.numericContents));
    }

    @SideOnly(value=Side.CLIENT)
    static class MergingIterator<T>
    extends AbstractIterator<T> {
        private final Iterator<T> leftItr;
        private final Iterator<T> rightItr;
        private final Object2IntMap<T> numbers;
        private T left;
        private T right;

        public MergingIterator(Iterator<T> leftIn, Iterator<T> rightIn, Object2IntMap<T> numbersIn) {
            this.leftItr = leftIn;
            this.rightItr = rightIn;
            this.numbers = numbersIn;
            this.left = leftIn.hasNext() ? leftIn.next() : null;
            this.right = rightIn.hasNext() ? rightIn.next() : null;
        }

        protected T computeNext() {
            T t;
            if (this.left == null && this.right == null) {
                return (T)this.endOfData();
            }
            int i = this.left == this.right ? 0 : (this.left == null ? 1 : (this.right == null ? -1 : Integer.compare(this.numbers.getInt(this.left), this.numbers.getInt(this.right))));
            T t2 = t = i <= 0 ? this.left : this.right;
            if (i <= 0) {
                this.left = this.leftItr.hasNext() ? this.leftItr.next() : null;
                Object v1 = this.left;
            }
            if (i >= 0) {
                this.right = this.rightItr.hasNext() ? this.rightItr.next() : null;
            }
            return t;
        }
    }
}

