/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.creativetab;

import javax.annotation.Nullable;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class CreativeTabs {
    public static CreativeTabs[] CREATIVE_TAB_ARRAY = new CreativeTabs[12];
    public static final CreativeTabs BUILDING_BLOCKS = new CreativeTabs(0, "buildingBlocks"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack createIcon() {
            return new ItemStack(Item.getItemFromBlock(Blocks.BRICK_BLOCK));
        }
    };
    public static final CreativeTabs DECORATIONS = new CreativeTabs(1, "decorations"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack createIcon() {
            return new ItemStack(Item.getItemFromBlock(Blocks.DOUBLE_PLANT), 1, BlockDoublePlant.EnumPlantType.PAEONIA.getMeta());
        }
    };
    public static final CreativeTabs REDSTONE = new CreativeTabs(2, "redstone"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack createIcon() {
            return new ItemStack(Items.REDSTONE);
        }
    };
    public static final CreativeTabs TRANSPORTATION = new CreativeTabs(3, "transportation"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack createIcon() {
            return new ItemStack(Item.getItemFromBlock(Blocks.GOLDEN_RAIL));
        }
    };
    public static final CreativeTabs MISC = new CreativeTabs(6, "misc"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack createIcon() {
            return new ItemStack(Items.LAVA_BUCKET);
        }
    };
    public static final CreativeTabs SEARCH = new CreativeTabs(5, "search"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack createIcon() {
            return new ItemStack(Items.COMPASS);
        }
    }.setBackgroundImageName("item_search.png");
    public static final CreativeTabs FOOD = new CreativeTabs(7, "food"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack createIcon() {
            return new ItemStack(Items.APPLE);
        }
    };
    public static final CreativeTabs TOOLS = new CreativeTabs(8, "tools"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack createIcon() {
            return new ItemStack(Items.IRON_AXE);
        }
    }.setRelevantEnchantmentTypes(EnumEnchantmentType.ALL, EnumEnchantmentType.DIGGER, EnumEnchantmentType.FISHING_ROD, EnumEnchantmentType.BREAKABLE);
    public static final CreativeTabs COMBAT = new CreativeTabs(9, "combat"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack createIcon() {
            return new ItemStack(Items.GOLDEN_SWORD);
        }
    }.setRelevantEnchantmentTypes(EnumEnchantmentType.ALL, EnumEnchantmentType.ARMOR, EnumEnchantmentType.ARMOR_FEET, EnumEnchantmentType.ARMOR_HEAD, EnumEnchantmentType.ARMOR_LEGS, EnumEnchantmentType.ARMOR_CHEST, EnumEnchantmentType.BOW, EnumEnchantmentType.WEAPON, EnumEnchantmentType.WEARABLE, EnumEnchantmentType.BREAKABLE);
    public static final CreativeTabs BREWING = new CreativeTabs(10, "brewing"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack createIcon() {
            return PotionUtils.addPotionToItemStack(new ItemStack(Items.POTIONITEM), PotionTypes.WATER);
        }
    };
    public static final CreativeTabs MATERIALS = MISC;
    public static final CreativeTabs HOTBAR = new CreativeTabs(4, "hotbar"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack createIcon() {
            return new ItemStack(Blocks.BOOKSHELF);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void displayAllRelevantItems(NonNullList<ItemStack> p_78018_1_) {
            throw new RuntimeException("Implement exception client-side.");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean isAlignedRight() {
            return true;
        }
    };
    public static final CreativeTabs INVENTORY = new CreativeTabs(11, "inventory"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack createIcon() {
            return new ItemStack(Item.getItemFromBlock(Blocks.CHEST));
        }
    }.setBackgroundImageName("inventory.png").setNoScrollbar().setNoTitle();
    private final int index;
    private final String tabLabel;
    private String backgroundTexture = "items.png";
    private boolean hasScrollbar = true;
    private boolean drawTitle = true;
    private EnumEnchantmentType[] enchantmentTypes = new EnumEnchantmentType[0];
    private ItemStack icon;

    public CreativeTabs(String label) {
        this(CreativeTabs.getNextID(), label);
    }

    public CreativeTabs(int index, String label) {
        if (index >= CREATIVE_TAB_ARRAY.length) {
            CreativeTabs[] tmp = new CreativeTabs[index + 1];
            for (int x = 0; x < CREATIVE_TAB_ARRAY.length; ++x) {
                tmp[x] = CREATIVE_TAB_ARRAY[x];
            }
            CREATIVE_TAB_ARRAY = tmp;
        }
        this.index = index;
        this.tabLabel = label;
        this.icon = ItemStack.EMPTY;
        CreativeTabs.CREATIVE_TAB_ARRAY[index] = this;
    }

    @SideOnly(value=Side.CLIENT)
    public int getIndex() {
        return this.index;
    }

    @SideOnly(value=Side.CLIENT)
    public String getTabLabel() {
        return this.tabLabel;
    }

    @SideOnly(value=Side.CLIENT)
    public String getTranslationKey() {
        return "itemGroup." + this.getTabLabel();
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getIcon() {
        if (this.icon.isEmpty()) {
            this.icon = this.createIcon();
        }
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract ItemStack createIcon();

    @SideOnly(value=Side.CLIENT)
    public String getBackgroundImageName() {
        return this.backgroundTexture;
    }

    public CreativeTabs setBackgroundImageName(String texture) {
        this.backgroundTexture = texture;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean drawInForegroundOfTab() {
        return this.drawTitle;
    }

    public CreativeTabs setNoTitle() {
        this.drawTitle = false;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasScrollbar() {
        return this.hasScrollbar;
    }

    public CreativeTabs setNoScrollbar() {
        this.hasScrollbar = false;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColumn() {
        if (this.index > 11) {
            return (this.index - 12) % 10 % 5;
        }
        return this.index % 6;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isOnTopRow() {
        if (this.index > 11) {
            return (this.index - 12) % 10 < 5;
        }
        return this.index < 6;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAlignedRight() {
        return this.getColumn() == 5;
    }

    public EnumEnchantmentType[] getRelevantEnchantmentTypes() {
        return this.enchantmentTypes;
    }

    public CreativeTabs setRelevantEnchantmentTypes(EnumEnchantmentType ... types) {
        this.enchantmentTypes = types;
        return this;
    }

    public boolean hasRelevantEnchantmentType(@Nullable EnumEnchantmentType enchantmentType) {
        if (enchantmentType != null) {
            for (EnumEnchantmentType enumenchantmenttype : this.enchantmentTypes) {
                if (enumenchantmenttype != enchantmentType) continue;
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void displayAllRelevantItems(NonNullList<ItemStack> p_78018_1_) {
        for (Item item : Item.REGISTRY) {
            item.getSubItems(this, p_78018_1_);
        }
    }

    public int getTabPage() {
        if (this.index > 11) {
            return (this.index - 12) / 10 + 1;
        }
        return 0;
    }

    public static int getNextID() {
        return CREATIVE_TAB_ARRAY.length;
    }

    public boolean hasSearchBar() {
        return this.index == CreativeTabs.SEARCH.index;
    }

    public int getSearchbarWidth() {
        return 89;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getBackgroundImage() {
        return new ResourceLocation("textures/gui/container/creative_inventory/tab_" + this.getBackgroundImageName());
    }

    public int getLabelColor() {
        return 0x404040;
    }
}

