/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartMobSpawner;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityIllusionIllager;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityDragonFireball;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityList {
    public static final ResourceLocation LIGHTNING_BOLT = new ResourceLocation("lightning_bolt");
    private static final ResourceLocation PLAYER = new ResourceLocation("player");
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Map<ResourceLocation, EntityEggInfo> ENTITY_EGGS = Maps.newLinkedHashMap();
    private static final Set<ResourceLocation> EXTRA_NAMES = Sets.newHashSet();

    @Nullable
    public static ResourceLocation getKey(Entity entityIn) {
        return EntityList.getKey(entityIn.getClass());
    }

    @Nullable
    public static ResourceLocation getKey(Class<? extends Entity> entityIn) {
        EntityEntry entry = EntityRegistry.getEntry(entityIn);
        return entry == null ? null : entry.getRegistryName();
    }

    @Nullable
    public static String getEntityString(Entity entityIn) {
        EntityEntry entry = EntityRegistry.getEntry(entityIn.getClass());
        return entry == null ? null : entry.getName();
    }

    @Nullable
    public static String getTranslationName(@Nullable ResourceLocation entityType) {
        EntityEntry entry = ForgeRegistries.ENTITIES.getValue(entityType);
        return entry == null ? null : entry.getName();
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static Class<? extends Entity> getClassFromID(int entityID) {
        EntityEntry entry = GameData.getEntityRegistry().getValue(entityID);
        return entry == null ? null : entry.getEntityClass();
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static Class<? extends Entity> getClassFromName(String p_192839_0_) {
        EntityEntry entry = ForgeRegistries.ENTITIES.getValue(new ResourceLocation(p_192839_0_));
        return entry == null ? null : entry.getEntityClass();
    }

    public static int getID(Class<? extends Entity> cls) {
        EntityEntry entry = EntityRegistry.getEntry(cls);
        return entry == null ? -1 : GameData.getEntityRegistry().getID(entry);
    }

    @Nullable
    public static Class<? extends Entity> getClass(ResourceLocation key) {
        EntityEntry entry = ForgeRegistries.ENTITIES.getValue(key);
        return entry == null ? null : entry.getEntityClass();
    }

    @Nullable
    public static Entity newEntity(@Nullable Class<? extends Entity> clazz, World worldIn) {
        if (clazz == null) {
            return null;
        }
        try {
            EntityEntry entry = EntityRegistry.getEntry(clazz);
            if (entry != null) {
                return entry.newInstance(worldIn);
            }
            return clazz.getConstructor(World.class).newInstance(worldIn);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static Entity createEntityByID(int entityID, World worldIn) {
        EntityEntry entry = GameData.getEntityRegistry().getValue(entityID);
        return entry == null ? null : entry.newInstance(worldIn);
    }

    @Nullable
    public static Entity createEntityByIDFromName(ResourceLocation name, World worldIn) {
        EntityEntry entry = ForgeRegistries.ENTITIES.getValue(name);
        return entry == null ? null : entry.newInstance(worldIn);
    }

    @Nullable
    public static Entity createEntityFromNBT(NBTTagCompound nbt, World worldIn) {
        ResourceLocation resourcelocation = new ResourceLocation(nbt.getString("id"));
        Entity entity = EntityList.createEntityByIDFromName(resourcelocation, worldIn);
        if (entity == null) {
            LOGGER.warn("Skipping Entity with id {}", (Object)resourcelocation);
        } else {
            try {
                entity.readFromNBT(nbt);
            }
            catch (Exception e) {
                FMLLog.log.error("An Entity {}({}) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", (Object)nbt.getString("id"), (Object)entity.getName(), (Object)e);
                entity = null;
            }
        }
        return entity;
    }

    public static Set<ResourceLocation> getEntityNameList() {
        return Sets.union(ForgeRegistries.ENTITIES.getKeys(), EXTRA_NAMES);
    }

    public static boolean isMatchingName(Entity entityIn, ResourceLocation entityName) {
        ResourceLocation resourcelocation = EntityList.getKey(entityIn.getClass());
        if (resourcelocation != null) {
            return resourcelocation.equals(entityName);
        }
        if (entityIn instanceof EntityPlayer) {
            return PLAYER.equals(entityName);
        }
        return entityIn instanceof EntityLightningBolt ? LIGHTNING_BOLT.equals(entityName) : false;
    }

    public static boolean isRegistered(ResourceLocation entityName) {
        return PLAYER.equals(entityName) || EntityList.getEntityNameList().contains(entityName);
    }

    public static String getValidTypeNames() {
        StringBuilder stringbuilder = new StringBuilder();
        for (ResourceLocation resourcelocation : EntityList.getEntityNameList()) {
            stringbuilder.append(resourcelocation).append(", ");
        }
        stringbuilder.append(PLAYER);
        return stringbuilder.toString();
    }

    public static void init() {
        EntityList.register(1, "item", EntityItem.class, "Item");
        EntityList.register(2, "xp_orb", EntityXPOrb.class, "XPOrb");
        EntityList.register(3, "area_effect_cloud", EntityAreaEffectCloud.class, "AreaEffectCloud");
        EntityList.register(4, "elder_guardian", EntityElderGuardian.class, "ElderGuardian");
        EntityList.register(5, "wither_skeleton", EntityWitherSkeleton.class, "WitherSkeleton");
        EntityList.register(6, "stray", EntityStray.class, "Stray");
        EntityList.register(7, "egg", EntityEgg.class, "ThrownEgg");
        EntityList.register(8, "leash_knot", EntityLeashKnot.class, "LeashKnot");
        EntityList.register(9, "painting", EntityPainting.class, "Painting");
        EntityList.register(10, "arrow", EntityTippedArrow.class, "Arrow");
        EntityList.register(11, "snowball", EntitySnowball.class, "Snowball");
        EntityList.register(12, "fireball", EntityLargeFireball.class, "Fireball");
        EntityList.register(13, "small_fireball", EntitySmallFireball.class, "SmallFireball");
        EntityList.register(14, "ender_pearl", EntityEnderPearl.class, "ThrownEnderpearl");
        EntityList.register(15, "eye_of_ender_signal", EntityEnderEye.class, "EyeOfEnderSignal");
        EntityList.register(16, "potion", EntityPotion.class, "ThrownPotion");
        EntityList.register(17, "xp_bottle", EntityExpBottle.class, "ThrownExpBottle");
        EntityList.register(18, "item_frame", EntityItemFrame.class, "ItemFrame");
        EntityList.register(19, "wither_skull", EntityWitherSkull.class, "WitherSkull");
        EntityList.register(20, "tnt", EntityTNTPrimed.class, "PrimedTnt");
        EntityList.register(21, "falling_block", EntityFallingBlock.class, "FallingSand");
        EntityList.register(22, "fireworks_rocket", EntityFireworkRocket.class, "FireworksRocketEntity");
        EntityList.register(23, "husk", EntityHusk.class, "Husk");
        EntityList.register(24, "spectral_arrow", EntitySpectralArrow.class, "SpectralArrow");
        EntityList.register(25, "shulker_bullet", EntityShulkerBullet.class, "ShulkerBullet");
        EntityList.register(26, "dragon_fireball", EntityDragonFireball.class, "DragonFireball");
        EntityList.register(27, "zombie_villager", EntityZombieVillager.class, "ZombieVillager");
        EntityList.register(28, "skeleton_horse", EntitySkeletonHorse.class, "SkeletonHorse");
        EntityList.register(29, "zombie_horse", EntityZombieHorse.class, "ZombieHorse");
        EntityList.register(30, "armor_stand", EntityArmorStand.class, "ArmorStand");
        EntityList.register(31, "donkey", EntityDonkey.class, "Donkey");
        EntityList.register(32, "mule", EntityMule.class, "Mule");
        EntityList.register(33, "evocation_fangs", EntityEvokerFangs.class, "EvocationFangs");
        EntityList.register(34, "evocation_illager", EntityEvoker.class, "EvocationIllager");
        EntityList.register(35, "vex", EntityVex.class, "Vex");
        EntityList.register(36, "vindication_illager", EntityVindicator.class, "VindicationIllager");
        EntityList.register(37, "illusion_illager", EntityIllusionIllager.class, "IllusionIllager");
        EntityList.register(40, "commandblock_minecart", EntityMinecartCommandBlock.class, EntityMinecart.Type.COMMAND_BLOCK.getName());
        EntityList.register(41, "boat", EntityBoat.class, "Boat");
        EntityList.register(42, "minecart", EntityMinecartEmpty.class, EntityMinecart.Type.RIDEABLE.getName());
        EntityList.register(43, "chest_minecart", EntityMinecartChest.class, EntityMinecart.Type.CHEST.getName());
        EntityList.register(44, "furnace_minecart", EntityMinecartFurnace.class, EntityMinecart.Type.FURNACE.getName());
        EntityList.register(45, "tnt_minecart", EntityMinecartTNT.class, EntityMinecart.Type.TNT.getName());
        EntityList.register(46, "hopper_minecart", EntityMinecartHopper.class, EntityMinecart.Type.HOPPER.getName());
        EntityList.register(47, "spawner_minecart", EntityMinecartMobSpawner.class, EntityMinecart.Type.SPAWNER.getName());
        EntityList.register(50, "creeper", EntityCreeper.class, "Creeper");
        EntityList.register(51, "skeleton", EntitySkeleton.class, "Skeleton");
        EntityList.register(52, "spider", EntitySpider.class, "Spider");
        EntityList.register(53, "giant", EntityGiantZombie.class, "Giant");
        EntityList.register(54, "zombie", EntityZombie.class, "Zombie");
        EntityList.register(55, "slime", EntitySlime.class, "Slime");
        EntityList.register(56, "ghast", EntityGhast.class, "Ghast");
        EntityList.register(57, "zombie_pigman", EntityPigZombie.class, "PigZombie");
        EntityList.register(58, "enderman", EntityEnderman.class, "Enderman");
        EntityList.register(59, "cave_spider", EntityCaveSpider.class, "CaveSpider");
        EntityList.register(60, "silverfish", EntitySilverfish.class, "Silverfish");
        EntityList.register(61, "blaze", EntityBlaze.class, "Blaze");
        EntityList.register(62, "magma_cube", EntityMagmaCube.class, "LavaSlime");
        EntityList.register(63, "ender_dragon", EntityDragon.class, "EnderDragon");
        EntityList.register(64, "wither", EntityWither.class, "WitherBoss");
        EntityList.register(65, "bat", EntityBat.class, "Bat");
        EntityList.register(66, "witch", EntityWitch.class, "Witch");
        EntityList.register(67, "endermite", EntityEndermite.class, "Endermite");
        EntityList.register(68, "guardian", EntityGuardian.class, "Guardian");
        EntityList.register(69, "shulker", EntityShulker.class, "Shulker");
        EntityList.register(90, "pig", EntityPig.class, "Pig");
        EntityList.register(91, "sheep", EntitySheep.class, "Sheep");
        EntityList.register(92, "cow", EntityCow.class, "Cow");
        EntityList.register(93, "chicken", EntityChicken.class, "Chicken");
        EntityList.register(94, "squid", EntitySquid.class, "Squid");
        EntityList.register(95, "wolf", EntityWolf.class, "Wolf");
        EntityList.register(96, "mooshroom", EntityMooshroom.class, "MushroomCow");
        EntityList.register(97, "snowman", EntitySnowman.class, "SnowMan");
        EntityList.register(98, "ocelot", EntityOcelot.class, "Ozelot");
        EntityList.register(99, "villager_golem", EntityIronGolem.class, "VillagerGolem");
        EntityList.register(100, "horse", EntityHorse.class, "Horse");
        EntityList.register(101, "rabbit", EntityRabbit.class, "Rabbit");
        EntityList.register(102, "polar_bear", EntityPolarBear.class, "PolarBear");
        EntityList.register(103, "llama", EntityLlama.class, "Llama");
        EntityList.register(104, "llama_spit", EntityLlamaSpit.class, "LlamaSpit");
        EntityList.register(105, "parrot", EntityParrot.class, "Parrot");
        EntityList.register(120, "villager", EntityVillager.class, "Villager");
        EntityList.register(200, "ender_crystal", EntityEnderCrystal.class, "EnderCrystal");
        EntityList.addSpawnInfo("bat", 4996656, 986895);
        EntityList.addSpawnInfo("blaze", 16167425, 16775294);
        EntityList.addSpawnInfo("cave_spider", 803406, 11013646);
        EntityList.addSpawnInfo("chicken", 0xA1A1A1, 0xFF0000);
        EntityList.addSpawnInfo("cow", 4470310, 0xA1A1A1);
        EntityList.addSpawnInfo("creeper", 894731, 0);
        EntityList.addSpawnInfo("donkey", 5457209, 8811878);
        EntityList.addSpawnInfo("elder_guardian", 13552826, 7632531);
        EntityList.addSpawnInfo("enderman", 0x161616, 0);
        EntityList.addSpawnInfo("endermite", 0x161616, 0x6E6E6E);
        EntityList.addSpawnInfo("evocation_illager", 0x959B9B, 1973274);
        EntityList.addSpawnInfo("ghast", 0xF9F9F9, 0xBCBCBC);
        EntityList.addSpawnInfo("guardian", 5931634, 15826224);
        EntityList.addSpawnInfo("horse", 12623485, 0xEEE500);
        EntityList.addSpawnInfo("husk", 7958625, 15125652);
        EntityList.addSpawnInfo("llama", 12623485, 10051392);
        EntityList.addSpawnInfo("magma_cube", 0x340000, 0xFCFC00);
        EntityList.addSpawnInfo("mooshroom", 10489616, 0xB7B7B7);
        EntityList.addSpawnInfo("mule", 1769984, 5321501);
        EntityList.addSpawnInfo("ocelot", 15720061, 5653556);
        EntityList.addSpawnInfo("parrot", 894731, 0xFF0000);
        EntityList.addSpawnInfo("pig", 15771042, 14377823);
        EntityList.addSpawnInfo("polar_bear", 0xF2F2F2, 0x959590);
        EntityList.addSpawnInfo("rabbit", 10051392, 7555121);
        EntityList.addSpawnInfo("sheep", 0xE7E7E7, 0xFFB5B5);
        EntityList.addSpawnInfo("shulker", 9725844, 5060690);
        EntityList.addSpawnInfo("silverfish", 0x6E6E6E, 0x303030);
        EntityList.addSpawnInfo("skeleton", 0xC1C1C1, 0x494949);
        EntityList.addSpawnInfo("skeleton_horse", 6842447, 15066584);
        EntityList.addSpawnInfo("slime", 5349438, 8306542);
        EntityList.addSpawnInfo("spider", 3419431, 11013646);
        EntityList.addSpawnInfo("squid", 2243405, 7375001);
        EntityList.addSpawnInfo("stray", 0x617677, 0xDDEAEA);
        EntityList.addSpawnInfo("vex", 8032420, 15265265);
        EntityList.addSpawnInfo("villager", 5651507, 12422002);
        EntityList.addSpawnInfo("vindication_illager", 0x959B9B, 2580065);
        EntityList.addSpawnInfo("witch", 0x340000, 5349438);
        EntityList.addSpawnInfo("wither_skeleton", 0x141414, 0x474D4D);
        EntityList.addSpawnInfo("wolf", 0xD7D3D3, 13545366);
        EntityList.addSpawnInfo("zombie", 44975, 7969893);
        EntityList.addSpawnInfo("zombie_horse", 3232308, 9945732);
        EntityList.addSpawnInfo("zombie_pigman", 15373203, 5009705);
        EntityList.addSpawnInfo("zombie_villager", 5651507, 7969893);
        EXTRA_NAMES.add(LIGHTNING_BOLT);
    }

    private static void register(int id, String name, Class<? extends Entity> clazz, String oldName) {
        try {
            clazz.getConstructor(World.class);
        }
        catch (NoSuchMethodException nosuchmethodexception) {
            throw new RuntimeException("Invalid class " + String.valueOf(clazz) + " no constructor taking " + World.class.getName());
        }
        if ((clazz.getModifiers() & 0x400) == 1024) {
            throw new RuntimeException("Invalid abstract class " + String.valueOf(clazz));
        }
        ResourceLocation resourcelocation = new ResourceLocation(name);
        GameData.registerEntity(id, resourcelocation, clazz, oldName);
    }

    protected static EntityEggInfo addSpawnInfo(String id, int primaryColor, int secondaryColor) {
        ResourceLocation resourcelocation = new ResourceLocation(id);
        EntityEggInfo egg = new EntityEggInfo(resourcelocation, primaryColor, secondaryColor);
        EntityEntry entry = ForgeRegistries.ENTITIES.getValue(resourcelocation);
        if (entry != null) {
            entry.setEgg(egg);
        }
        return ENTITY_EGGS.put(resourcelocation, egg);
    }

    public static class EntityEggInfo {
        public final ResourceLocation spawnedID;
        public final int primaryColor;
        public final int secondaryColor;
        public final StatBase killEntityStat;
        public final StatBase entityKilledByStat;

        public EntityEggInfo(ResourceLocation idIn, int primaryColorIn, int secondaryColorIn) {
            this.spawnedID = idIn;
            this.primaryColor = primaryColorIn;
            this.secondaryColor = secondaryColorIn;
            this.killEntityStat = StatList.getStatKillEntity(this);
            this.entityKilledByStat = StatList.getStatEntityKilledBy(this);
        }

        public EntityEggInfo(ResourceLocation id, int primaryColor, int secondaryColor, StatBase killEntityStatistic, StatBase entityKilledByStatistic) {
            this.spawnedID = id;
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
            this.killEntityStat = killEntityStatistic;
            this.entityKilledByStat = entityKilledByStatistic;
        }
    }
}

