/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.math.Vec3d;

public class EntityAIPlay
extends EntityAIBase {
    private final EntityVillager villager;
    private EntityLivingBase targetVillager;
    private final double speed;
    private int playTime;

    public EntityAIPlay(EntityVillager villagerIn, double speedIn) {
        this.villager = villagerIn;
        this.speed = speedIn;
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        Vec3d vec3d;
        if (this.villager.getGrowingAge() >= 0) {
            return false;
        }
        if (this.villager.getRNG().nextInt(400) != 0) {
            return false;
        }
        List<EntityVillager> list = this.villager.world.getEntitiesWithinAABB(EntityVillager.class, this.villager.getEntityBoundingBox().grow(6.0, 3.0, 6.0));
        double d0 = Double.MAX_VALUE;
        for (EntityVillager entityvillager : list) {
            double d1;
            if (entityvillager == this.villager || entityvillager.isPlaying() || entityvillager.getGrowingAge() >= 0 || (d1 = entityvillager.getDistanceSq(this.villager)) > d0) continue;
            d0 = d1;
            this.targetVillager = entityvillager;
        }
        return this.targetVillager != null || (vec3d = RandomPositionGenerator.findRandomTarget(this.villager, 16, 3)) != null;
    }

    @Override
    public boolean shouldContinueExecuting() {
        return this.playTime > 0;
    }

    @Override
    public void startExecuting() {
        if (this.targetVillager != null) {
            this.villager.setPlaying(true);
        }
        this.playTime = 1000;
    }

    @Override
    public void resetTask() {
        this.villager.setPlaying(false);
        this.targetVillager = null;
    }

    @Override
    public void updateTask() {
        --this.playTime;
        if (this.targetVillager != null) {
            if (this.villager.getDistanceSq(this.targetVillager) > 4.0) {
                this.villager.getNavigator().tryMoveToEntityLiving(this.targetVillager, this.speed);
            }
        } else if (this.villager.getNavigator().noPath()) {
            Vec3d vec3d = RandomPositionGenerator.findRandomTarget(this.villager, 16, 3);
            if (vec3d == null) {
                return;
            }
            this.villager.getNavigator().tryMoveToXYZ(vec3d.x, vec3d.y, vec3d.z, this.speed);
        }
    }
}

