/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityTameable;

public class EntityAISit
extends EntityAIBase {
    private final EntityTameable tameable;
    private boolean isSitting;

    public EntityAISit(EntityTameable entityIn) {
        this.tameable = entityIn;
        this.setMutexBits(5);
    }

    @Override
    public boolean shouldExecute() {
        if (!this.tameable.isTamed()) {
            return false;
        }
        if (this.tameable.isInWater()) {
            return false;
        }
        if (!this.tameable.onGround) {
            return false;
        }
        EntityLivingBase entitylivingbase = this.tameable.getOwner();
        if (entitylivingbase == null) {
            return true;
        }
        return this.tameable.getDistanceSq(entitylivingbase) < 144.0 && entitylivingbase.getRevengeTarget() != null ? false : this.isSitting;
    }

    @Override
    public void startExecuting() {
        this.tameable.getNavigator().clearPath();
        this.tameable.setSitting(true);
    }

    @Override
    public void resetTask() {
        this.tameable.setSitting(false);
    }

    public void setSitting(boolean sitting) {
        this.isSitting = sitting;
    }
}

