/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class EntityAIWanderAvoidWaterFlying
extends EntityAIWanderAvoidWater {
    public EntityAIWanderAvoidWaterFlying(EntityCreature p_i47413_1_, double p_i47413_2_) {
        super(p_i47413_1_, p_i47413_2_);
    }

    @Override
    @Nullable
    protected Vec3d getPosition() {
        Vec3d vec3d = null;
        if (this.entity.isInWater() || this.entity.isOverWater()) {
            vec3d = RandomPositionGenerator.getLandPos(this.entity, 15, 15);
        }
        if (this.entity.getRNG().nextFloat() >= this.probability) {
            vec3d = this.getTreePos();
        }
        return vec3d == null ? super.getPosition() : vec3d;
    }

    @Nullable
    private Vec3d getTreePos() {
        BlockPos blockpos = new BlockPos(this.entity);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
        for (BlockPos blockPos : BlockPos.MutableBlockPos.getAllInBoxMutable(MathHelper.floor(this.entity.posX - 3.0), MathHelper.floor(this.entity.posY - 6.0), MathHelper.floor(this.entity.posZ - 3.0), MathHelper.floor(this.entity.posX + 3.0), MathHelper.floor(this.entity.posY + 6.0), MathHelper.floor(this.entity.posZ + 3.0))) {
            Block block;
            boolean flag;
            if (blockpos.equals(blockPos) || !(flag = (block = this.entity.world.getBlockState(blockpos$mutableblockpos1.setPos(blockPos).move(EnumFacing.DOWN)).getBlock()) instanceof BlockLeaves || block == Blocks.LOG || block == Blocks.LOG2) || !this.entity.world.isAirBlock(blockPos) || !this.entity.world.isAirBlock(blockpos$mutableblockpos.setPos(blockPos).move(EnumFacing.UP))) continue;
            return new Vec3d(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        }
        return null;
    }
}

