/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntitySpellcasterIllager
extends AbstractIllager {
    private static final DataParameter<Byte> SPELL = EntityDataManager.createKey(EntitySpellcasterIllager.class, DataSerializers.BYTE);
    protected int spellTicks;
    private SpellType activeSpell = SpellType.NONE;

    public EntitySpellcasterIllager(World p_i47506_1_) {
        super(p_i47506_1_);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(SPELL, (byte)0);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.spellTicks = compound.getInteger("SpellTicks");
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setInteger("SpellTicks", this.spellTicks);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AbstractIllager.IllagerArmPose getArmPose() {
        return this.isSpellcasting() ? AbstractIllager.IllagerArmPose.SPELLCASTING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public boolean isSpellcasting() {
        return this.world.isRemote ? this.dataManager.get(SPELL) > 0 : this.spellTicks > 0;
    }

    public void setSpellType(SpellType spellType) {
        this.activeSpell = spellType;
        this.dataManager.set(SPELL, (byte)spellType.id);
    }

    protected SpellType getSpellType() {
        return !this.world.isRemote ? this.activeSpell : SpellType.getFromId(this.dataManager.get(SPELL).byteValue());
    }

    @Override
    protected void updateAITasks() {
        super.updateAITasks();
        if (this.spellTicks > 0) {
            --this.spellTicks;
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.world.isRemote && this.isSpellcasting()) {
            SpellType entityspellcasterillager$spelltype = this.getSpellType();
            double d0 = entityspellcasterillager$spelltype.particleSpeed[0];
            double d1 = entityspellcasterillager$spelltype.particleSpeed[1];
            double d2 = entityspellcasterillager$spelltype.particleSpeed[2];
            float f = this.renderYawOffset * ((float)Math.PI / 180) + MathHelper.cos((float)this.ticksExisted * 0.6662f) * 0.25f;
            float f1 = MathHelper.cos(f);
            float f2 = MathHelper.sin(f);
            this.world.spawnParticle(EnumParticleTypes.SPELL_MOB, this.posX + (double)f1 * 0.6, this.posY + 1.8, this.posZ + (double)f2 * 0.6, d0, d1, d2, new int[0]);
            this.world.spawnParticle(EnumParticleTypes.SPELL_MOB, this.posX - (double)f1 * 0.6, this.posY + 1.8, this.posZ - (double)f2 * 0.6, d0, d1, d2, new int[0]);
        }
    }

    protected int getSpellTicks() {
        return this.spellTicks;
    }

    protected abstract SoundEvent getSpellSound();

    public static enum SpellType {
        NONE(0, 0.0, 0.0, 0.0),
        SUMMON_VEX(1, 0.7, 0.7, 0.8),
        FANGS(2, 0.4, 0.3, 0.35),
        WOLOLO(3, 0.7, 0.5, 0.2),
        DISAPPEAR(4, 0.3, 0.3, 0.8),
        BLINDNESS(5, 0.1, 0.1, 0.2);

        private final int id;
        private final double[] particleSpeed;

        private SpellType(int idIn, double xParticleSpeed, double yParticleSpeed, double zParticleSpeed) {
            this.id = idIn;
            this.particleSpeed = new double[]{xParticleSpeed, yParticleSpeed, zParticleSpeed};
        }

        public static SpellType getFromId(int idIn) {
            for (SpellType entityspellcasterillager$spelltype : SpellType.values()) {
                if (idIn != entityspellcasterillager$spelltype.id) continue;
                return entityspellcasterillager$spelltype;
            }
            return NONE;
        }
    }

    public abstract class AIUseSpell
    extends EntityAIBase {
        protected int spellWarmup;
        protected int spellCooldown;

        protected AIUseSpell() {
        }

        @Override
        public boolean shouldExecute() {
            if (EntitySpellcasterIllager.this.getAttackTarget() == null) {
                return false;
            }
            return EntitySpellcasterIllager.this.isSpellcasting() ? false : EntitySpellcasterIllager.this.ticksExisted >= this.spellCooldown;
        }

        @Override
        public boolean shouldContinueExecuting() {
            return EntitySpellcasterIllager.this.getAttackTarget() != null && this.spellWarmup > 0;
        }

        @Override
        public void startExecuting() {
            this.spellWarmup = this.getCastWarmupTime();
            EntitySpellcasterIllager.this.spellTicks = this.getCastingTime();
            this.spellCooldown = EntitySpellcasterIllager.this.ticksExisted + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                EntitySpellcasterIllager.this.playSound(soundevent, 1.0f, 1.0f);
            }
            EntitySpellcasterIllager.this.setSpellType(this.getSpellType());
        }

        @Override
        public void updateTask() {
            --this.spellWarmup;
            if (this.spellWarmup == 0) {
                this.castSpell();
                EntitySpellcasterIllager.this.playSound(EntitySpellcasterIllager.this.getSpellSound(), 1.0f, 1.0f);
            }
        }

        protected abstract void castSpell();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        protected abstract SpellType getSpellType();
    }

    public class AICastingApell
    extends EntityAIBase {
        public AICastingApell() {
            this.setMutexBits(3);
        }

        @Override
        public boolean shouldExecute() {
            return EntitySpellcasterIllager.this.getSpellTicks() > 0;
        }

        @Override
        public void startExecuting() {
            super.startExecuting();
            EntitySpellcasterIllager.this.navigator.clearPath();
        }

        @Override
        public void resetTask() {
            super.resetTask();
            EntitySpellcasterIllager.this.setSpellType(SpellType.NONE);
        }

        @Override
        public void updateTask() {
            if (EntitySpellcasterIllager.this.getAttackTarget() != null) {
                EntitySpellcasterIllager.this.getLookHelper().setLookPositionWithEntity(EntitySpellcasterIllager.this.getAttackTarget(), EntitySpellcasterIllager.this.getHorizontalFaceSpeed(), EntitySpellcasterIllager.this.getVerticalFaceSpeed());
            }
        }
    }
}

