/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import java.util.List;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ContainerEnchantment
extends Container {
    public IInventory tableInventory = new InventoryBasic("Enchant", true, 2){

        @Override
        public int getInventoryStackLimit() {
            return 64;
        }

        @Override
        public void markDirty() {
            super.markDirty();
            ContainerEnchantment.this.onCraftMatrixChanged(this);
        }
    };
    private final World world;
    private final BlockPos position;
    private final Random rand = new Random();
    public int xpSeed;
    public int[] enchantLevels = new int[3];
    public int[] enchantClue = new int[]{-1, -1, -1};
    public int[] worldClue = new int[]{-1, -1, -1};

    @SideOnly(value=Side.CLIENT)
    public ContainerEnchantment(InventoryPlayer playerInv, World worldIn) {
        this(playerInv, worldIn, BlockPos.ORIGIN);
    }

    public ContainerEnchantment(InventoryPlayer playerInv, World worldIn, BlockPos pos) {
        this.world = worldIn;
        this.position = pos;
        this.xpSeed = playerInv.player.getXPSeed();
        this.addSlotToContainer(new Slot(this, this.tableInventory, 0, 15, 47){

            @Override
            public boolean isItemValid(ItemStack stack) {
                return true;
            }

            @Override
            public int getSlotStackLimit() {
                return 1;
            }
        });
        this.addSlotToContainer(new Slot(this, this.tableInventory, 1, 35, 47){
            List<ItemStack> ores = OreDictionary.getOres("gemLapis");

            @Override
            public boolean isItemValid(ItemStack stack) {
                for (ItemStack ore : this.ores) {
                    if (!OreDictionary.itemMatches(ore, stack, false)) continue;
                    return true;
                }
                return false;
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot(playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlotToContainer(new Slot(playerInv, k, 8 + k * 18, 142));
        }
    }

    protected void broadcastData(IContainerListener crafting) {
        crafting.sendWindowProperty(this, 0, this.enchantLevels[0]);
        crafting.sendWindowProperty(this, 1, this.enchantLevels[1]);
        crafting.sendWindowProperty(this, 2, this.enchantLevels[2]);
        crafting.sendWindowProperty(this, 3, this.xpSeed & 0xFFFFFFF0);
        crafting.sendWindowProperty(this, 4, this.enchantClue[0]);
        crafting.sendWindowProperty(this, 5, this.enchantClue[1]);
        crafting.sendWindowProperty(this, 6, this.enchantClue[2]);
        crafting.sendWindowProperty(this, 7, this.worldClue[0]);
        crafting.sendWindowProperty(this, 8, this.worldClue[1]);
        crafting.sendWindowProperty(this, 9, this.worldClue[2]);
    }

    @Override
    public void addListener(IContainerListener listener) {
        super.addListener(listener);
        this.broadcastData(listener);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (int i = 0; i < this.listeners.size(); ++i) {
            IContainerListener icontainerlistener = (IContainerListener)this.listeners.get(i);
            this.broadcastData(icontainerlistener);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int data) {
        if (id >= 0 && id <= 2) {
            this.enchantLevels[id] = data;
        } else if (id == 3) {
            this.xpSeed = data;
        } else if (id >= 4 && id <= 6) {
            this.enchantClue[id - 4] = data;
        } else if (id >= 7 && id <= 9) {
            this.worldClue[id - 7] = data;
        } else {
            super.updateProgressBar(id, data);
        }
    }

    @Override
    public void onCraftMatrixChanged(IInventory inventoryIn) {
        if (inventoryIn == this.tableInventory) {
            ItemStack itemstack = inventoryIn.getStackInSlot(0);
            if (!itemstack.isEmpty() && itemstack.isItemEnchantable()) {
                if (!this.world.isRemote) {
                    boolean l = false;
                    float power = 0.0f;
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            if (j == 0 && k == 0 || !this.world.isAirBlock(this.position.add(k, 0, j)) || !this.world.isAirBlock(this.position.add(k, 1, j))) continue;
                            power += ForgeHooks.getEnchantPower(this.world, this.position.add(k * 2, 0, j * 2));
                            power += ForgeHooks.getEnchantPower(this.world, this.position.add(k * 2, 1, j * 2));
                            if (k == 0 || j == 0) continue;
                            power += ForgeHooks.getEnchantPower(this.world, this.position.add(k * 2, 0, j));
                            power += ForgeHooks.getEnchantPower(this.world, this.position.add(k * 2, 1, j));
                            power += ForgeHooks.getEnchantPower(this.world, this.position.add(k, 0, j * 2));
                            power += ForgeHooks.getEnchantPower(this.world, this.position.add(k, 1, j * 2));
                        }
                    }
                    this.rand.setSeed(this.xpSeed);
                    for (int i1 = 0; i1 < 3; ++i1) {
                        this.enchantLevels[i1] = EnchantmentHelper.calcItemStackEnchantability(this.rand, i1, (int)power, itemstack);
                        this.enchantClue[i1] = -1;
                        this.worldClue[i1] = -1;
                        if (this.enchantLevels[i1] < i1 + 1) {
                            this.enchantLevels[i1] = 0;
                        }
                        this.enchantLevels[i1] = ForgeEventFactory.onEnchantmentLevelSet(this.world, this.position, i1, (int)power, itemstack, this.enchantLevels[i1]);
                    }
                    for (int j1 = 0; j1 < 3; ++j1) {
                        List<EnchantmentData> list;
                        if (this.enchantLevels[j1] <= 0 || (list = this.getEnchantmentList(itemstack, j1, this.enchantLevels[j1])) == null || list.isEmpty()) continue;
                        EnchantmentData enchantmentdata = list.get(this.rand.nextInt(list.size()));
                        this.enchantClue[j1] = Enchantment.getEnchantmentID(enchantmentdata.enchantment);
                        this.worldClue[j1] = enchantmentdata.enchantmentLevel;
                    }
                    this.detectAndSendChanges();
                }
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.enchantLevels[i] = 0;
                    this.enchantClue[i] = -1;
                    this.worldClue[i] = -1;
                }
            }
        }
    }

    @Override
    public boolean enchantItem(EntityPlayer playerIn, int id) {
        ItemStack itemstack = this.tableInventory.getStackInSlot(0);
        ItemStack itemstack1 = this.tableInventory.getStackInSlot(1);
        int i = id + 1;
        if ((itemstack1.isEmpty() || itemstack1.getCount() < i) && !playerIn.capabilities.isCreativeMode) {
            return false;
        }
        if (this.enchantLevels[id] > 0 && !itemstack.isEmpty() && (playerIn.experienceLevel >= i && playerIn.experienceLevel >= this.enchantLevels[id] || playerIn.capabilities.isCreativeMode)) {
            List<EnchantmentData> list;
            if (!this.world.isRemote && !(list = this.getEnchantmentList(itemstack, id, this.enchantLevels[id])).isEmpty()) {
                boolean flag;
                playerIn.onEnchant(itemstack, i);
                boolean bl = flag = itemstack.getItem() == Items.BOOK;
                if (flag) {
                    itemstack = new ItemStack(Items.ENCHANTED_BOOK);
                    this.tableInventory.setInventorySlotContents(0, itemstack);
                }
                for (int j = 0; j < list.size(); ++j) {
                    EnchantmentData enchantmentdata = list.get(j);
                    if (flag) {
                        ItemEnchantedBook.addEnchantment(itemstack, enchantmentdata);
                        continue;
                    }
                    itemstack.addEnchantment(enchantmentdata.enchantment, enchantmentdata.enchantmentLevel);
                }
                if (!playerIn.capabilities.isCreativeMode) {
                    itemstack1.shrink(i);
                    if (itemstack1.isEmpty()) {
                        this.tableInventory.setInventorySlotContents(1, ItemStack.EMPTY);
                    }
                }
                playerIn.addStat(StatList.ITEM_ENCHANTED);
                if (playerIn instanceof EntityPlayerMP) {
                    CriteriaTriggers.ENCHANTED_ITEM.trigger((EntityPlayerMP)playerIn, itemstack, i);
                }
                this.tableInventory.markDirty();
                this.xpSeed = playerIn.getXPSeed();
                this.onCraftMatrixChanged(this.tableInventory);
                this.world.playSound(null, this.position, SoundEvents.BLOCK_ENCHANTMENT_TABLE_USE, SoundCategory.BLOCKS, 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f);
            }
            return true;
        }
        return false;
    }

    private List<EnchantmentData> getEnchantmentList(ItemStack stack, int enchantSlot, int level) {
        this.rand.setSeed(this.xpSeed + enchantSlot);
        List<EnchantmentData> list = EnchantmentHelper.buildEnchantmentList(this.rand, stack, level, false);
        if (stack.getItem() == Items.BOOK && list.size() > 1) {
            list.remove(this.rand.nextInt(list.size()));
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public int getLapisAmount() {
        ItemStack itemstack = this.tableInventory.getStackInSlot(1);
        return itemstack.isEmpty() ? 0 : itemstack.getCount();
    }

    @Override
    public void onContainerClosed(EntityPlayer playerIn) {
        super.onContainerClosed(playerIn);
        if (!this.world.isRemote) {
            this.clearContainer(playerIn, playerIn.world, this.tableInventory);
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer playerIn) {
        if (this.world.getBlockState(this.position).getBlock() != Blocks.ENCHANTING_TABLE) {
            return false;
        }
        return playerIn.getDistanceSq((double)this.position.getX() + 0.5, (double)this.position.getY() + 0.5, (double)this.position.getZ() + 0.5) <= 64.0;
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(index);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if (index == 0) {
                if (!this.mergeItemStack(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (index == 1) {
                if (!this.mergeItemStack(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (itemstack1.getItem() == Items.DYE && EnumDyeColor.byDyeDamage(itemstack1.getMetadata()) == EnumDyeColor.BLUE) {
                if (!this.mergeItemStack(itemstack1, 1, 2, true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (((Slot)this.inventorySlots.get(0)).getHasStack() || !((Slot)this.inventorySlots.get(0)).isItemValid(itemstack1)) {
                    return ItemStack.EMPTY;
                }
                if (itemstack1.hasTagCompound()) {
                    ((Slot)this.inventorySlots.get(0)).putStack(itemstack1.splitStack(1));
                } else if (!itemstack1.isEmpty()) {
                    ((Slot)this.inventorySlots.get(0)).putStack(new ItemStack(itemstack1.getItem(), 1, itemstack1.getMetadata()));
                    itemstack1.shrink(1);
                }
            }
            if (itemstack1.isEmpty()) {
                slot.putStack(ItemStack.EMPTY);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }
}

