/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.block.BlockRedSandstone;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockWall;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemAir;
import net.minecraft.item.ItemAnvilBlock;
import net.minecraft.item.ItemAppleGold;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemArmorStand;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemBed;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemBoat;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemBucketMilk;
import net.minecraft.item.ItemCarrotOnAStick;
import net.minecraft.item.ItemChorusFruit;
import net.minecraft.item.ItemClock;
import net.minecraft.item.ItemCloth;
import net.minecraft.item.ItemCoal;
import net.minecraft.item.ItemColored;
import net.minecraft.item.ItemCompass;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemEgg;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemEmptyMap;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemEndCrystal;
import net.minecraft.item.ItemEnderEye;
import net.minecraft.item.ItemEnderPearl;
import net.minecraft.item.ItemExpBottle;
import net.minecraft.item.ItemFireball;
import net.minecraft.item.ItemFirework;
import net.minecraft.item.ItemFireworkCharge;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemGlassBottle;
import net.minecraft.item.ItemHangingEntity;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemKnowledgeBook;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemLeaves;
import net.minecraft.item.ItemLilyPad;
import net.minecraft.item.ItemLingeringPotion;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemPiston;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemRedstone;
import net.minecraft.item.ItemSaddle;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemShulkerBox;
import net.minecraft.item.ItemSign;
import net.minecraft.item.ItemSimpleFoiled;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemSnow;
import net.minecraft.item.ItemSnowball;
import net.minecraft.item.ItemSoup;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemSpectralArrow;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTippedArrow;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.util.registry.RegistrySimple;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Item
extends IForgeRegistryEntry.Impl<Item> {
    public static final RegistryNamespaced<ResourceLocation, Item> REGISTRY = GameData.getWrapper(Item.class);
    private static final Map<Block, Item> BLOCK_TO_ITEM = GameData.getBlockItemMap();
    private static final IItemPropertyGetter DAMAGED_GETTER = new IItemPropertyGetter(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public float apply(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
            return stack.isItemDamaged() ? 1.0f : 0.0f;
        }
    };
    private static final IItemPropertyGetter DAMAGE_GETTER = new IItemPropertyGetter(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public float apply(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
            return MathHelper.clamp((float)stack.getItemDamage() / (float)stack.getMaxDamage(), 0.0f, 1.0f);
        }
    };
    private static final IItemPropertyGetter LEFTHANDED_GETTER = new IItemPropertyGetter(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public float apply(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
            return entityIn != null && entityIn.getPrimaryHand() != EnumHandSide.RIGHT ? 1.0f : 0.0f;
        }
    };
    private static final IItemPropertyGetter COOLDOWN_GETTER = new IItemPropertyGetter(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public float apply(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
            return entityIn instanceof EntityPlayer ? ((EntityPlayer)entityIn).getCooldownTracker().getCooldown(stack.getItem(), 0.0f) : 0.0f;
        }
    };
    private final IRegistry<ResourceLocation, IItemPropertyGetter> properties = new RegistrySimple<ResourceLocation, IItemPropertyGetter>();
    protected static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    private CreativeTabs tabToDisplayOn;
    protected static Random itemRand = new Random();
    protected int maxStackSize = 64;
    private int maxDamage;
    protected boolean bFull3D;
    protected boolean hasSubtypes;
    private Item containerItem;
    private String translationKey;
    protected boolean canRepair = true;
    private Map<String, Integer> toolClasses = new HashMap<String, Integer>();
    @SideOnly(value=Side.CLIENT)
    @Nullable
    private TileEntityItemStackRenderer teisr;

    public static int getIdFromItem(Item itemIn) {
        return itemIn == null ? 0 : REGISTRY.getIDForObject(itemIn);
    }

    public static Item getItemById(int id) {
        return REGISTRY.getObjectById(id);
    }

    public static Item getItemFromBlock(Block blockIn) {
        Item item = BLOCK_TO_ITEM.get(blockIn);
        return item == null ? Items.AIR : item;
    }

    @Nullable
    public static Item getByNameOrId(String id) {
        Item item = REGISTRY.getObject(new ResourceLocation(id));
        if (item == null) {
            try {
                return Item.getItemById(Integer.parseInt(id));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return item;
    }

    public final void addPropertyOverride(ResourceLocation key, IItemPropertyGetter getter) {
        this.properties.putObject(key, getter);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IItemPropertyGetter getPropertyGetter(ResourceLocation key) {
        return this.properties.getObject(key);
    }

    public boolean updateItemStackNBT(NBTTagCompound nbt) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomProperties() {
        return !this.properties.getKeys().isEmpty();
    }

    public Item() {
        this.addPropertyOverride(new ResourceLocation("lefthanded"), LEFTHANDED_GETTER);
        this.addPropertyOverride(new ResourceLocation("cooldown"), COOLDOWN_GETTER);
    }

    public Item setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
        return this;
    }

    public EnumActionResult onItemUse(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    public float getDestroySpeed(ItemStack stack, IBlockState state) {
        return 1.0f;
    }

    public ActionResult<ItemStack> onItemRightClick(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        return new ActionResult<ItemStack>(EnumActionResult.PASS, playerIn.getHeldItem(handIn));
    }

    public ItemStack onItemUseFinish(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        return stack;
    }

    @Deprecated
    public int getItemStackLimit() {
        return this.maxStackSize;
    }

    public int getMetadata(int damage) {
        return 0;
    }

    public boolean getHasSubtypes() {
        return this.hasSubtypes;
    }

    public Item setHasSubtypes(boolean hasSubtypes) {
        this.hasSubtypes = hasSubtypes;
        return this;
    }

    @Deprecated
    public int getMaxDamage() {
        return this.maxDamage;
    }

    public Item setMaxDamage(int maxDamageIn) {
        this.maxDamage = maxDamageIn;
        if (maxDamageIn > 0) {
            this.addPropertyOverride(new ResourceLocation("damaged"), DAMAGED_GETTER);
            this.addPropertyOverride(new ResourceLocation("damage"), DAMAGE_GETTER);
        }
        return this;
    }

    public boolean isDamageable() {
        return this.maxDamage > 0 && (!this.hasSubtypes || this.maxStackSize == 1);
    }

    public boolean hitEntity(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return false;
    }

    public boolean onBlockDestroyed(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return false;
    }

    public boolean canHarvestBlock(IBlockState blockIn) {
        return false;
    }

    public boolean itemInteractionForEntity(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        return false;
    }

    public Item setFull3D() {
        this.bFull3D = true;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isFull3D() {
        return this.bFull3D;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRotateAroundWhenRendering() {
        return false;
    }

    public Item setTranslationKey(String key) {
        this.translationKey = key;
        return this;
    }

    public String getUnlocalizedNameInefficiently(ItemStack stack) {
        return I18n.translateToLocal(this.getTranslationKey(stack));
    }

    public String getTranslationKey() {
        return "item." + this.translationKey;
    }

    public String getTranslationKey(ItemStack stack) {
        return "item." + this.translationKey;
    }

    public Item setContainerItem(Item containerItem) {
        this.containerItem = containerItem;
        return this;
    }

    public boolean getShareTag() {
        return true;
    }

    @Nullable
    public Item getContainerItem() {
        return this.containerItem;
    }

    @Deprecated
    public boolean hasContainerItem() {
        return this.containerItem != null;
    }

    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    public void onCreated(ItemStack stack, World worldIn, EntityPlayer playerIn) {
    }

    public boolean isMap() {
        return false;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.NONE;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 0;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return I18n.translateToLocal(this.getUnlocalizedNameInefficiently(stack) + ".name").trim();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack) {
        return stack.isItemEnchanted();
    }

    @Deprecated
    public EnumRarity getRarity(ItemStack stack) {
        return stack.isItemEnchanted() ? EnumRarity.RARE : EnumRarity.COMMON;
    }

    public boolean isEnchantable(ItemStack stack) {
        return this.getItemStackLimit(stack) == 1 && this.isDamageable();
    }

    protected RayTraceResult rayTrace(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        float f = playerIn.rotationPitch;
        float f1 = playerIn.rotationYaw;
        double d0 = playerIn.posX;
        double d1 = playerIn.posY + (double)playerIn.getEyeHeight();
        double d2 = playerIn.posZ;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.cos(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f3 = MathHelper.sin(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f4 = -MathHelper.cos(-f * ((float)Math.PI / 180));
        float f5 = MathHelper.sin(-f * ((float)Math.PI / 180));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = playerIn.getEntityAttribute(EntityPlayer.REACH_DISTANCE).getAttributeValue();
        Vec3d vec3d1 = vec3d.add((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return worldIn.rayTraceBlocks(vec3d, vec3d1, useLiquids, !useLiquids, false);
    }

    public int getItemEnchantability() {
        return 0;
    }

    public void getSubItems(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.isInCreativeTab(tab)) {
            items.add(new ItemStack(this));
        }
    }

    protected boolean isInCreativeTab(CreativeTabs targetTab) {
        for (CreativeTabs tab : this.getCreativeTabs()) {
            if (tab != targetTab) continue;
            return true;
        }
        CreativeTabs creativetabs = this.getCreativeTab();
        return creativetabs != null && (targetTab == CreativeTabs.SEARCH || targetTab == creativetabs);
    }

    @Nullable
    public CreativeTabs getCreativeTab() {
        return this.tabToDisplayOn;
    }

    public Item setCreativeTab(CreativeTabs tab) {
        this.tabToDisplayOn = tab;
        return this;
    }

    public boolean canItemEditBlocks() {
        return false;
    }

    public boolean getIsRepairable(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @Deprecated
    public Multimap<String, AttributeModifier> getItemAttributeModifiers(EntityEquipmentSlot equipmentSlot) {
        return HashMultimap.create();
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return this.getItemAttributeModifiers(slot);
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return true;
    }

    public String getHighlightTip(ItemStack item, String displayName) {
        return displayName;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    public boolean isRepairable() {
        return this.canRepair && this.isDamageable();
    }

    public Item setNoRepair() {
        this.canRepair = false;
        return this;
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 2.0f;
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        return stack.getTagCompound();
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        stack.setTagCompound(nbt);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return false;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        if (!this.hasContainerItem(itemStack)) {
            return ItemStack.EMPTY;
        }
        return new ItemStack(this.getContainerItem());
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.hasContainerItem();
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return 6000;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return false;
    }

    @Nullable
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return null;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        return false;
    }

    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{this.getCreativeTab()};
    }

    public float getSmeltingExperience(ItemStack item) {
        return -1.0f;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return EntityLiving.getSlotForItemStack(stack) == armorType;
    }

    @Nullable
    public EntityEquipmentSlot getEquipmentSlot(ItemStack stack) {
        return null;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public FontRenderer getFontRenderer(ItemStack stack) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return null;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHelmetOverlay(ItemStack stack, EntityPlayer player, ScaledResolution resolution, float partialTicks) {
    }

    public int getDamage(ItemStack stack) {
        return stack.itemDamage;
    }

    public int getMetadata(ItemStack stack) {
        return stack.itemDamage;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.isItemDamaged();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)stack.getItemDamage() / (double)stack.getMaxDamage();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.hsvToRGB(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f, 1.0f, 1.0f);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getMaxDamage();
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.itemDamage > 0;
    }

    public void setDamage(ItemStack stack, int damage) {
        stack.itemDamage = damage;
        if (stack.itemDamage < 0) {
            stack.itemDamage = 0;
        }
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return !(this instanceof ItemSword);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return this.canHarvestBlock(state);
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getItemStackLimit();
    }

    public void setHarvestLevel(String toolClass, int level) {
        if (level < 0) {
            this.toolClasses.remove(toolClass);
        } else {
            this.toolClasses.put(toolClass, level);
        }
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return this.toolClasses.keySet();
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        Integer ret = this.toolClasses.get(toolClass);
        return ret == null ? -1 : ret;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.getItemEnchantability();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.type.canEnchantItem(stack.getItem());
    }

    public boolean isBeaconPayment(ItemStack stack) {
        return this == Items.EMERALD || this == Items.DIAMOND || this == Items.GOLD_INGOT || this == Items.IRON_INGOT;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return newStack.getItem() != oldStack.getItem() || !ItemStack.areItemStackTagsEqual(newStack, oldStack) || !newStack.isItemStackDamageable() && newStack.getMetadata() != oldStack.getMetadata();
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return oldStack.equals(newStack);
    }

    @Nullable
    public String getCreatorModId(ItemStack itemStack) {
        return ForgeHooks.getDefaultCreatorModId(itemStack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return null;
    }

    public ImmutableMap<String, ITimeValue> getAnimationParameters(final ItemStack stack, final World world, final EntityLivingBase entity) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ResourceLocation location : this.properties.getKeys()) {
            final IItemPropertyGetter parameter = this.properties.getObject(location);
            builder.put((Object)location.toString(), (Object)new ITimeValue(){

                @Override
                public float apply(float input) {
                    return parameter.apply(stack, world, entity);
                }
            });
        }
        return builder.build();
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, EntityLivingBase entity, EntityLivingBase attacker) {
        return this instanceof ItemAxe;
    }

    public boolean isShield(ItemStack stack, @Nullable EntityLivingBase entity) {
        return stack.getItem() == Items.SHIELD;
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return -1;
    }

    public HorseArmorType getHorseArmorType(ItemStack stack) {
        return HorseArmorType.getByItem(stack.getItem());
    }

    public String getHorseArmorTexture(EntityLiving wearer, ItemStack stack) {
        return this.getHorseArmorType(stack).getTextureName();
    }

    public void onHorseArmorTick(World world, EntityLiving horse, ItemStack armor) {
    }

    @SideOnly(value=Side.CLIENT)
    public final TileEntityItemStackRenderer getTileEntityItemStackRenderer() {
        return this.teisr != null ? this.teisr : TileEntityItemStackRenderer.instance;
    }

    @SideOnly(value=Side.CLIENT)
    public void setTileEntityItemStackRenderer(@Nullable TileEntityItemStackRenderer teisr) {
        this.teisr = teisr;
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return this.getRarity(stack);
    }

    public static void registerItems() {
        Item.registerItemBlock(Blocks.AIR, new ItemAir(Blocks.AIR));
        Item.registerItemBlock(Blocks.STONE, new ItemMultiTexture(Blocks.STONE, Blocks.STONE, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return BlockStone.EnumType.byMetadata(p_apply_1_.getMetadata()).getTranslationKey();
            }
        }).setTranslationKey("stone"));
        Item.registerItemBlock(Blocks.GRASS, new ItemColored(Blocks.GRASS, false));
        Item.registerItemBlock(Blocks.DIRT, new ItemMultiTexture(Blocks.DIRT, Blocks.DIRT, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return BlockDirt.DirtType.byMetadata(p_apply_1_.getMetadata()).getTranslationKey();
            }
        }).setTranslationKey("dirt"));
        Item.registerItemBlock(Blocks.COBBLESTONE);
        Item.registerItemBlock(Blocks.PLANKS, new ItemMultiTexture(Blocks.PLANKS, Blocks.PLANKS, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return BlockPlanks.EnumType.byMetadata(p_apply_1_.getMetadata()).getTranslationKey();
            }
        }).setTranslationKey("wood"));
        Item.registerItemBlock(Blocks.SAPLING, new ItemMultiTexture(Blocks.SAPLING, Blocks.SAPLING, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return BlockPlanks.EnumType.byMetadata(p_apply_1_.getMetadata()).getTranslationKey();
            }
        }).setTranslationKey("sapling"));
        Item.registerItemBlock(Blocks.BEDROCK);
        Item.registerItemBlock(Blocks.SAND, new ItemMultiTexture((Block)Blocks.SAND, (Block)Blocks.SAND, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return BlockSand.EnumType.byMetadata(p_apply_1_.getMetadata()).getTranslationKey();
            }
        }).setTranslationKey("sand"));
        Item.registerItemBlock(Blocks.GRAVEL);
        Item.registerItemBlock(Blocks.GOLD_ORE);
        Item.registerItemBlock(Blocks.IRON_ORE);
        Item.registerItemBlock(Blocks.COAL_ORE);
        Item.registerItemBlock(Blocks.LOG, new ItemMultiTexture(Blocks.LOG, Blocks.LOG, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return BlockPlanks.EnumType.byMetadata(p_apply_1_.getMetadata()).getTranslationKey();
            }
        }).setTranslationKey("log"));
        Item.registerItemBlock(Blocks.LOG2, new ItemMultiTexture(Blocks.LOG2, Blocks.LOG2, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return BlockPlanks.EnumType.byMetadata(p_apply_1_.getMetadata() + 4).getTranslationKey();
            }
        }).setTranslationKey("log"));
        Item.registerItemBlock(Blocks.LEAVES, new ItemLeaves(Blocks.LEAVES).setTranslationKey("leaves"));
        Item.registerItemBlock(Blocks.LEAVES2, new ItemLeaves(Blocks.LEAVES2).setTranslationKey("leaves"));
        Item.registerItemBlock(Blocks.SPONGE, new ItemMultiTexture(Blocks.SPONGE, Blocks.SPONGE, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return (p_apply_1_.getMetadata() & 1) == 1 ? "wet" : "dry";
            }
        }).setTranslationKey("sponge"));
        Item.registerItemBlock(Blocks.GLASS);
        Item.registerItemBlock(Blocks.LAPIS_ORE);
        Item.registerItemBlock(Blocks.LAPIS_BLOCK);
        Item.registerItemBlock(Blocks.DISPENSER);
        Item.registerItemBlock(Blocks.SANDSTONE, new ItemMultiTexture(Blocks.SANDSTONE, Blocks.SANDSTONE, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return BlockSandStone.EnumType.byMetadata(p_apply_1_.getMetadata()).getTranslationKey();
            }
        }).setTranslationKey("sandStone"));
        Item.registerItemBlock(Blocks.NOTEBLOCK);
        Item.registerItemBlock(Blocks.GOLDEN_RAIL);
        Item.registerItemBlock(Blocks.DETECTOR_RAIL);
        Item.registerItemBlock(Blocks.STICKY_PISTON, new ItemPiston(Blocks.STICKY_PISTON));
        Item.registerItemBlock(Blocks.WEB);
        Item.registerItemBlock(Blocks.TALLGRASS, new ItemColored(Blocks.TALLGRASS, true).setSubtypeNames(new String[]{"shrub", "grass", "fern"}));
        Item.registerItemBlock(Blocks.DEADBUSH);
        Item.registerItemBlock(Blocks.PISTON, new ItemPiston(Blocks.PISTON));
        Item.registerItemBlock(Blocks.WOOL, new ItemCloth(Blocks.WOOL).setTranslationKey("cloth"));
        Item.registerItemBlock(Blocks.YELLOW_FLOWER, new ItemMultiTexture((Block)Blocks.YELLOW_FLOWER, (Block)Blocks.YELLOW_FLOWER, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return BlockFlower.EnumFlowerType.getType(BlockFlower.EnumFlowerColor.YELLOW, p_apply_1_.getMetadata()).getTranslationKey();
            }
        }).setTranslationKey("flower"));
        Item.registerItemBlock(Blocks.RED_FLOWER, new ItemMultiTexture((Block)Blocks.RED_FLOWER, (Block)Blocks.RED_FLOWER, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return BlockFlower.EnumFlowerType.getType(BlockFlower.EnumFlowerColor.RED, p_apply_1_.getMetadata()).getTranslationKey();
            }
        }).setTranslationKey("rose"));
        Item.registerItemBlock(Blocks.BROWN_MUSHROOM);
        Item.registerItemBlock(Blocks.RED_MUSHROOM);
        Item.registerItemBlock(Blocks.GOLD_BLOCK);
        Item.registerItemBlock(Blocks.IRON_BLOCK);
        Item.registerItemBlock(Blocks.STONE_SLAB, new ItemSlab(Blocks.STONE_SLAB, Blocks.STONE_SLAB, Blocks.DOUBLE_STONE_SLAB).setTranslationKey("stoneSlab"));
        Item.registerItemBlock(Blocks.BRICK_BLOCK);
        Item.registerItemBlock(Blocks.TNT);
        Item.registerItemBlock(Blocks.BOOKSHELF);
        Item.registerItemBlock(Blocks.MOSSY_COBBLESTONE);
        Item.registerItemBlock(Blocks.OBSIDIAN);
        Item.registerItemBlock(Blocks.TORCH);
        Item.registerItemBlock(Blocks.END_ROD);
        Item.registerItemBlock(Blocks.CHORUS_PLANT);
        Item.registerItemBlock(Blocks.CHORUS_FLOWER);
        Item.registerItemBlock(Blocks.PURPUR_BLOCK);
        Item.registerItemBlock(Blocks.PURPUR_PILLAR);
        Item.registerItemBlock(Blocks.PURPUR_STAIRS);
        Item.registerItemBlock(Blocks.PURPUR_SLAB, new ItemSlab(Blocks.PURPUR_SLAB, Blocks.PURPUR_SLAB, Blocks.PURPUR_DOUBLE_SLAB).setTranslationKey("purpurSlab"));
        Item.registerItemBlock(Blocks.MOB_SPAWNER);
        Item.registerItemBlock(Blocks.OAK_STAIRS);
        Item.registerItemBlock(Blocks.CHEST);
        Item.registerItemBlock(Blocks.DIAMOND_ORE);
        Item.registerItemBlock(Blocks.DIAMOND_BLOCK);
        Item.registerItemBlock(Blocks.CRAFTING_TABLE);
        Item.registerItemBlock(Blocks.FARMLAND);
        Item.registerItemBlock(Blocks.FURNACE);
        Item.registerItemBlock(Blocks.LADDER);
        Item.registerItemBlock(Blocks.RAIL);
        Item.registerItemBlock(Blocks.STONE_STAIRS);
        Item.registerItemBlock(Blocks.LEVER);
        Item.registerItemBlock(Blocks.STONE_PRESSURE_PLATE);
        Item.registerItemBlock(Blocks.WOODEN_PRESSURE_PLATE);
        Item.registerItemBlock(Blocks.REDSTONE_ORE);
        Item.registerItemBlock(Blocks.REDSTONE_TORCH);
        Item.registerItemBlock(Blocks.STONE_BUTTON);
        Item.registerItemBlock(Blocks.SNOW_LAYER, new ItemSnow(Blocks.SNOW_LAYER));
        Item.registerItemBlock(Blocks.ICE);
        Item.registerItemBlock(Blocks.SNOW);
        Item.registerItemBlock(Blocks.CACTUS);
        Item.registerItemBlock(Blocks.CLAY);
        Item.registerItemBlock(Blocks.JUKEBOX);
        Item.registerItemBlock(Blocks.OAK_FENCE);
        Item.registerItemBlock(Blocks.SPRUCE_FENCE);
        Item.registerItemBlock(Blocks.BIRCH_FENCE);
        Item.registerItemBlock(Blocks.JUNGLE_FENCE);
        Item.registerItemBlock(Blocks.DARK_OAK_FENCE);
        Item.registerItemBlock(Blocks.ACACIA_FENCE);
        Item.registerItemBlock(Blocks.PUMPKIN);
        Item.registerItemBlock(Blocks.NETHERRACK);
        Item.registerItemBlock(Blocks.SOUL_SAND);
        Item.registerItemBlock(Blocks.GLOWSTONE);
        Item.registerItemBlock(Blocks.LIT_PUMPKIN);
        Item.registerItemBlock(Blocks.TRAPDOOR);
        Item.registerItemBlock(Blocks.MONSTER_EGG, new ItemMultiTexture(Blocks.MONSTER_EGG, Blocks.MONSTER_EGG, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return BlockSilverfish.EnumType.byMetadata(p_apply_1_.getMetadata()).getTranslationKey();
            }
        }).setTranslationKey("monsterStoneEgg"));
        Item.registerItemBlock(Blocks.STONEBRICK, new ItemMultiTexture(Blocks.STONEBRICK, Blocks.STONEBRICK, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return BlockStoneBrick.EnumType.byMetadata(p_apply_1_.getMetadata()).getTranslationKey();
            }
        }).setTranslationKey("stonebricksmooth"));
        Item.registerItemBlock(Blocks.BROWN_MUSHROOM_BLOCK);
        Item.registerItemBlock(Blocks.RED_MUSHROOM_BLOCK);
        Item.registerItemBlock(Blocks.IRON_BARS);
        Item.registerItemBlock(Blocks.GLASS_PANE);
        Item.registerItemBlock(Blocks.MELON_BLOCK);
        Item.registerItemBlock(Blocks.VINE, new ItemColored(Blocks.VINE, false));
        Item.registerItemBlock(Blocks.OAK_FENCE_GATE);
        Item.registerItemBlock(Blocks.SPRUCE_FENCE_GATE);
        Item.registerItemBlock(Blocks.BIRCH_FENCE_GATE);
        Item.registerItemBlock(Blocks.JUNGLE_FENCE_GATE);
        Item.registerItemBlock(Blocks.DARK_OAK_FENCE_GATE);
        Item.registerItemBlock(Blocks.ACACIA_FENCE_GATE);
        Item.registerItemBlock(Blocks.BRICK_STAIRS);
        Item.registerItemBlock(Blocks.STONE_BRICK_STAIRS);
        Item.registerItemBlock(Blocks.MYCELIUM);
        Item.registerItemBlock(Blocks.WATERLILY, new ItemLilyPad(Blocks.WATERLILY));
        Item.registerItemBlock(Blocks.NETHER_BRICK);
        Item.registerItemBlock(Blocks.NETHER_BRICK_FENCE);
        Item.registerItemBlock(Blocks.NETHER_BRICK_STAIRS);
        Item.registerItemBlock(Blocks.ENCHANTING_TABLE);
        Item.registerItemBlock(Blocks.END_PORTAL_FRAME);
        Item.registerItemBlock(Blocks.END_STONE);
        Item.registerItemBlock(Blocks.END_BRICKS);
        Item.registerItemBlock(Blocks.DRAGON_EGG);
        Item.registerItemBlock(Blocks.REDSTONE_LAMP);
        Item.registerItemBlock(Blocks.WOODEN_SLAB, new ItemSlab(Blocks.WOODEN_SLAB, Blocks.WOODEN_SLAB, Blocks.DOUBLE_WOODEN_SLAB).setTranslationKey("woodSlab"));
        Item.registerItemBlock(Blocks.SANDSTONE_STAIRS);
        Item.registerItemBlock(Blocks.EMERALD_ORE);
        Item.registerItemBlock(Blocks.ENDER_CHEST);
        Item.registerItemBlock(Blocks.TRIPWIRE_HOOK);
        Item.registerItemBlock(Blocks.EMERALD_BLOCK);
        Item.registerItemBlock(Blocks.SPRUCE_STAIRS);
        Item.registerItemBlock(Blocks.BIRCH_STAIRS);
        Item.registerItemBlock(Blocks.JUNGLE_STAIRS);
        Item.registerItemBlock(Blocks.COMMAND_BLOCK);
        Item.registerItemBlock(Blocks.BEACON);
        Item.registerItemBlock(Blocks.COBBLESTONE_WALL, new ItemMultiTexture(Blocks.COBBLESTONE_WALL, Blocks.COBBLESTONE_WALL, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return BlockWall.EnumType.byMetadata(p_apply_1_.getMetadata()).getTranslationKey();
            }
        }).setTranslationKey("cobbleWall"));
        Item.registerItemBlock(Blocks.WOODEN_BUTTON);
        Item.registerItemBlock(Blocks.ANVIL, new ItemAnvilBlock(Blocks.ANVIL).setTranslationKey("anvil"));
        Item.registerItemBlock(Blocks.TRAPPED_CHEST);
        Item.registerItemBlock(Blocks.LIGHT_WEIGHTED_PRESSURE_PLATE);
        Item.registerItemBlock(Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE);
        Item.registerItemBlock(Blocks.DAYLIGHT_DETECTOR);
        Item.registerItemBlock(Blocks.REDSTONE_BLOCK);
        Item.registerItemBlock(Blocks.QUARTZ_ORE);
        Item.registerItemBlock(Blocks.HOPPER);
        Item.registerItemBlock(Blocks.QUARTZ_BLOCK, new ItemMultiTexture(Blocks.QUARTZ_BLOCK, Blocks.QUARTZ_BLOCK, new String[]{"default", "chiseled", "lines"}).setTranslationKey("quartzBlock"));
        Item.registerItemBlock(Blocks.QUARTZ_STAIRS);
        Item.registerItemBlock(Blocks.ACTIVATOR_RAIL);
        Item.registerItemBlock(Blocks.DROPPER);
        Item.registerItemBlock(Blocks.STAINED_HARDENED_CLAY, new ItemCloth(Blocks.STAINED_HARDENED_CLAY).setTranslationKey("clayHardenedStained"));
        Item.registerItemBlock(Blocks.BARRIER);
        Item.registerItemBlock(Blocks.IRON_TRAPDOOR);
        Item.registerItemBlock(Blocks.HAY_BLOCK);
        Item.registerItemBlock(Blocks.CARPET, new ItemCloth(Blocks.CARPET).setTranslationKey("woolCarpet"));
        Item.registerItemBlock(Blocks.HARDENED_CLAY);
        Item.registerItemBlock(Blocks.COAL_BLOCK);
        Item.registerItemBlock(Blocks.PACKED_ICE);
        Item.registerItemBlock(Blocks.ACACIA_STAIRS);
        Item.registerItemBlock(Blocks.DARK_OAK_STAIRS);
        Item.registerItemBlock(Blocks.SLIME_BLOCK);
        Item.registerItemBlock(Blocks.GRASS_PATH);
        Item.registerItemBlock(Blocks.DOUBLE_PLANT, new ItemMultiTexture((Block)Blocks.DOUBLE_PLANT, (Block)Blocks.DOUBLE_PLANT, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return BlockDoublePlant.EnumPlantType.byMetadata(p_apply_1_.getMetadata()).getTranslationKey();
            }
        }).setTranslationKey("doublePlant"));
        Item.registerItemBlock(Blocks.STAINED_GLASS, new ItemCloth(Blocks.STAINED_GLASS).setTranslationKey("stainedGlass"));
        Item.registerItemBlock(Blocks.STAINED_GLASS_PANE, new ItemCloth(Blocks.STAINED_GLASS_PANE).setTranslationKey("stainedGlassPane"));
        Item.registerItemBlock(Blocks.PRISMARINE, new ItemMultiTexture(Blocks.PRISMARINE, Blocks.PRISMARINE, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return BlockPrismarine.EnumType.byMetadata(p_apply_1_.getMetadata()).getTranslationKey();
            }
        }).setTranslationKey("prismarine"));
        Item.registerItemBlock(Blocks.SEA_LANTERN);
        Item.registerItemBlock(Blocks.RED_SANDSTONE, new ItemMultiTexture(Blocks.RED_SANDSTONE, Blocks.RED_SANDSTONE, new ItemMultiTexture.Mapper(){

            @Override
            public String apply(ItemStack p_apply_1_) {
                return BlockRedSandstone.EnumType.byMetadata(p_apply_1_.getMetadata()).getTranslationKey();
            }
        }).setTranslationKey("redSandStone"));
        Item.registerItemBlock(Blocks.RED_SANDSTONE_STAIRS);
        Item.registerItemBlock(Blocks.STONE_SLAB2, new ItemSlab(Blocks.STONE_SLAB2, Blocks.STONE_SLAB2, Blocks.DOUBLE_STONE_SLAB2).setTranslationKey("stoneSlab2"));
        Item.registerItemBlock(Blocks.REPEATING_COMMAND_BLOCK);
        Item.registerItemBlock(Blocks.CHAIN_COMMAND_BLOCK);
        Item.registerItemBlock(Blocks.MAGMA);
        Item.registerItemBlock(Blocks.NETHER_WART_BLOCK);
        Item.registerItemBlock(Blocks.RED_NETHER_BRICK);
        Item.registerItemBlock(Blocks.BONE_BLOCK);
        Item.registerItemBlock(Blocks.STRUCTURE_VOID);
        Item.registerItemBlock(Blocks.OBSERVER);
        Item.registerItemBlock(Blocks.WHITE_SHULKER_BOX, new ItemShulkerBox(Blocks.WHITE_SHULKER_BOX));
        Item.registerItemBlock(Blocks.ORANGE_SHULKER_BOX, new ItemShulkerBox(Blocks.ORANGE_SHULKER_BOX));
        Item.registerItemBlock(Blocks.MAGENTA_SHULKER_BOX, new ItemShulkerBox(Blocks.MAGENTA_SHULKER_BOX));
        Item.registerItemBlock(Blocks.LIGHT_BLUE_SHULKER_BOX, new ItemShulkerBox(Blocks.LIGHT_BLUE_SHULKER_BOX));
        Item.registerItemBlock(Blocks.YELLOW_SHULKER_BOX, new ItemShulkerBox(Blocks.YELLOW_SHULKER_BOX));
        Item.registerItemBlock(Blocks.LIME_SHULKER_BOX, new ItemShulkerBox(Blocks.LIME_SHULKER_BOX));
        Item.registerItemBlock(Blocks.PINK_SHULKER_BOX, new ItemShulkerBox(Blocks.PINK_SHULKER_BOX));
        Item.registerItemBlock(Blocks.GRAY_SHULKER_BOX, new ItemShulkerBox(Blocks.GRAY_SHULKER_BOX));
        Item.registerItemBlock(Blocks.SILVER_SHULKER_BOX, new ItemShulkerBox(Blocks.SILVER_SHULKER_BOX));
        Item.registerItemBlock(Blocks.CYAN_SHULKER_BOX, new ItemShulkerBox(Blocks.CYAN_SHULKER_BOX));
        Item.registerItemBlock(Blocks.PURPLE_SHULKER_BOX, new ItemShulkerBox(Blocks.PURPLE_SHULKER_BOX));
        Item.registerItemBlock(Blocks.BLUE_SHULKER_BOX, new ItemShulkerBox(Blocks.BLUE_SHULKER_BOX));
        Item.registerItemBlock(Blocks.BROWN_SHULKER_BOX, new ItemShulkerBox(Blocks.BROWN_SHULKER_BOX));
        Item.registerItemBlock(Blocks.GREEN_SHULKER_BOX, new ItemShulkerBox(Blocks.GREEN_SHULKER_BOX));
        Item.registerItemBlock(Blocks.RED_SHULKER_BOX, new ItemShulkerBox(Blocks.RED_SHULKER_BOX));
        Item.registerItemBlock(Blocks.BLACK_SHULKER_BOX, new ItemShulkerBox(Blocks.BLACK_SHULKER_BOX));
        Item.registerItemBlock(Blocks.WHITE_GLAZED_TERRACOTTA);
        Item.registerItemBlock(Blocks.ORANGE_GLAZED_TERRACOTTA);
        Item.registerItemBlock(Blocks.MAGENTA_GLAZED_TERRACOTTA);
        Item.registerItemBlock(Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA);
        Item.registerItemBlock(Blocks.YELLOW_GLAZED_TERRACOTTA);
        Item.registerItemBlock(Blocks.LIME_GLAZED_TERRACOTTA);
        Item.registerItemBlock(Blocks.PINK_GLAZED_TERRACOTTA);
        Item.registerItemBlock(Blocks.GRAY_GLAZED_TERRACOTTA);
        Item.registerItemBlock(Blocks.SILVER_GLAZED_TERRACOTTA);
        Item.registerItemBlock(Blocks.CYAN_GLAZED_TERRACOTTA);
        Item.registerItemBlock(Blocks.PURPLE_GLAZED_TERRACOTTA);
        Item.registerItemBlock(Blocks.BLUE_GLAZED_TERRACOTTA);
        Item.registerItemBlock(Blocks.BROWN_GLAZED_TERRACOTTA);
        Item.registerItemBlock(Blocks.GREEN_GLAZED_TERRACOTTA);
        Item.registerItemBlock(Blocks.RED_GLAZED_TERRACOTTA);
        Item.registerItemBlock(Blocks.BLACK_GLAZED_TERRACOTTA);
        Item.registerItemBlock(Blocks.CONCRETE, new ItemCloth(Blocks.CONCRETE).setTranslationKey("concrete"));
        Item.registerItemBlock(Blocks.CONCRETE_POWDER, new ItemCloth(Blocks.CONCRETE_POWDER).setTranslationKey("concrete_powder"));
        Item.registerItemBlock(Blocks.STRUCTURE_BLOCK);
        Item.registerItem(256, "iron_shovel", new ItemSpade(ToolMaterial.IRON).setTranslationKey("shovelIron"));
        Item.registerItem(257, "iron_pickaxe", new ItemPickaxe(ToolMaterial.IRON).setTranslationKey("pickaxeIron"));
        Item.registerItem(258, "iron_axe", new ItemAxe(ToolMaterial.IRON).setTranslationKey("hatchetIron"));
        Item.registerItem(259, "flint_and_steel", new ItemFlintAndSteel().setTranslationKey("flintAndSteel"));
        Item.registerItem(260, "apple", new ItemFood(4, 0.3f, false).setTranslationKey("apple"));
        Item.registerItem(261, "bow", new ItemBow().setTranslationKey("bow"));
        Item.registerItem(262, "arrow", new ItemArrow().setTranslationKey("arrow"));
        Item.registerItem(263, "coal", new ItemCoal().setTranslationKey("coal"));
        Item.registerItem(264, "diamond", new Item().setTranslationKey("diamond").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(265, "iron_ingot", new Item().setTranslationKey("ingotIron").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(266, "gold_ingot", new Item().setTranslationKey("ingotGold").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(267, "iron_sword", new ItemSword(ToolMaterial.IRON).setTranslationKey("swordIron"));
        Item.registerItem(268, "wooden_sword", new ItemSword(ToolMaterial.WOOD).setTranslationKey("swordWood"));
        Item.registerItem(269, "wooden_shovel", new ItemSpade(ToolMaterial.WOOD).setTranslationKey("shovelWood"));
        Item.registerItem(270, "wooden_pickaxe", new ItemPickaxe(ToolMaterial.WOOD).setTranslationKey("pickaxeWood"));
        Item.registerItem(271, "wooden_axe", new ItemAxe(ToolMaterial.WOOD).setTranslationKey("hatchetWood"));
        Item.registerItem(272, "stone_sword", new ItemSword(ToolMaterial.STONE).setTranslationKey("swordStone"));
        Item.registerItem(273, "stone_shovel", new ItemSpade(ToolMaterial.STONE).setTranslationKey("shovelStone"));
        Item.registerItem(274, "stone_pickaxe", new ItemPickaxe(ToolMaterial.STONE).setTranslationKey("pickaxeStone"));
        Item.registerItem(275, "stone_axe", new ItemAxe(ToolMaterial.STONE).setTranslationKey("hatchetStone"));
        Item.registerItem(276, "diamond_sword", new ItemSword(ToolMaterial.DIAMOND).setTranslationKey("swordDiamond"));
        Item.registerItem(277, "diamond_shovel", new ItemSpade(ToolMaterial.DIAMOND).setTranslationKey("shovelDiamond"));
        Item.registerItem(278, "diamond_pickaxe", new ItemPickaxe(ToolMaterial.DIAMOND).setTranslationKey("pickaxeDiamond"));
        Item.registerItem(279, "diamond_axe", new ItemAxe(ToolMaterial.DIAMOND).setTranslationKey("hatchetDiamond"));
        Item.registerItem(280, "stick", new Item().setFull3D().setTranslationKey("stick").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(281, "bowl", new Item().setTranslationKey("bowl").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(282, "mushroom_stew", new ItemSoup(6).setTranslationKey("mushroomStew"));
        Item.registerItem(283, "golden_sword", new ItemSword(ToolMaterial.GOLD).setTranslationKey("swordGold"));
        Item.registerItem(284, "golden_shovel", new ItemSpade(ToolMaterial.GOLD).setTranslationKey("shovelGold"));
        Item.registerItem(285, "golden_pickaxe", new ItemPickaxe(ToolMaterial.GOLD).setTranslationKey("pickaxeGold"));
        Item.registerItem(286, "golden_axe", new ItemAxe(ToolMaterial.GOLD).setTranslationKey("hatchetGold"));
        Item.registerItem(287, "string", new ItemBlockSpecial(Blocks.TRIPWIRE).setTranslationKey("string").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(288, "feather", new Item().setTranslationKey("feather").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(289, "gunpowder", new Item().setTranslationKey("sulphur").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(290, "wooden_hoe", new ItemHoe(ToolMaterial.WOOD).setTranslationKey("hoeWood"));
        Item.registerItem(291, "stone_hoe", new ItemHoe(ToolMaterial.STONE).setTranslationKey("hoeStone"));
        Item.registerItem(292, "iron_hoe", new ItemHoe(ToolMaterial.IRON).setTranslationKey("hoeIron"));
        Item.registerItem(293, "diamond_hoe", new ItemHoe(ToolMaterial.DIAMOND).setTranslationKey("hoeDiamond"));
        Item.registerItem(294, "golden_hoe", new ItemHoe(ToolMaterial.GOLD).setTranslationKey("hoeGold"));
        Item.registerItem(295, "wheat_seeds", new ItemSeeds(Blocks.WHEAT, Blocks.FARMLAND).setTranslationKey("seeds"));
        Item.registerItem(296, "wheat", new Item().setTranslationKey("wheat").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(297, "bread", new ItemFood(5, 0.6f, false).setTranslationKey("bread"));
        Item.registerItem(298, "leather_helmet", new ItemArmor(ItemArmor.ArmorMaterial.LEATHER, 0, EntityEquipmentSlot.HEAD).setTranslationKey("helmetCloth"));
        Item.registerItem(299, "leather_chestplate", new ItemArmor(ItemArmor.ArmorMaterial.LEATHER, 0, EntityEquipmentSlot.CHEST).setTranslationKey("chestplateCloth"));
        Item.registerItem(300, "leather_leggings", new ItemArmor(ItemArmor.ArmorMaterial.LEATHER, 0, EntityEquipmentSlot.LEGS).setTranslationKey("leggingsCloth"));
        Item.registerItem(301, "leather_boots", new ItemArmor(ItemArmor.ArmorMaterial.LEATHER, 0, EntityEquipmentSlot.FEET).setTranslationKey("bootsCloth"));
        Item.registerItem(302, "chainmail_helmet", new ItemArmor(ItemArmor.ArmorMaterial.CHAIN, 1, EntityEquipmentSlot.HEAD).setTranslationKey("helmetChain"));
        Item.registerItem(303, "chainmail_chestplate", new ItemArmor(ItemArmor.ArmorMaterial.CHAIN, 1, EntityEquipmentSlot.CHEST).setTranslationKey("chestplateChain"));
        Item.registerItem(304, "chainmail_leggings", new ItemArmor(ItemArmor.ArmorMaterial.CHAIN, 1, EntityEquipmentSlot.LEGS).setTranslationKey("leggingsChain"));
        Item.registerItem(305, "chainmail_boots", new ItemArmor(ItemArmor.ArmorMaterial.CHAIN, 1, EntityEquipmentSlot.FEET).setTranslationKey("bootsChain"));
        Item.registerItem(306, "iron_helmet", new ItemArmor(ItemArmor.ArmorMaterial.IRON, 2, EntityEquipmentSlot.HEAD).setTranslationKey("helmetIron"));
        Item.registerItem(307, "iron_chestplate", new ItemArmor(ItemArmor.ArmorMaterial.IRON, 2, EntityEquipmentSlot.CHEST).setTranslationKey("chestplateIron"));
        Item.registerItem(308, "iron_leggings", new ItemArmor(ItemArmor.ArmorMaterial.IRON, 2, EntityEquipmentSlot.LEGS).setTranslationKey("leggingsIron"));
        Item.registerItem(309, "iron_boots", new ItemArmor(ItemArmor.ArmorMaterial.IRON, 2, EntityEquipmentSlot.FEET).setTranslationKey("bootsIron"));
        Item.registerItem(310, "diamond_helmet", new ItemArmor(ItemArmor.ArmorMaterial.DIAMOND, 3, EntityEquipmentSlot.HEAD).setTranslationKey("helmetDiamond"));
        Item.registerItem(311, "diamond_chestplate", new ItemArmor(ItemArmor.ArmorMaterial.DIAMOND, 3, EntityEquipmentSlot.CHEST).setTranslationKey("chestplateDiamond"));
        Item.registerItem(312, "diamond_leggings", new ItemArmor(ItemArmor.ArmorMaterial.DIAMOND, 3, EntityEquipmentSlot.LEGS).setTranslationKey("leggingsDiamond"));
        Item.registerItem(313, "diamond_boots", new ItemArmor(ItemArmor.ArmorMaterial.DIAMOND, 3, EntityEquipmentSlot.FEET).setTranslationKey("bootsDiamond"));
        Item.registerItem(314, "golden_helmet", new ItemArmor(ItemArmor.ArmorMaterial.GOLD, 4, EntityEquipmentSlot.HEAD).setTranslationKey("helmetGold"));
        Item.registerItem(315, "golden_chestplate", new ItemArmor(ItemArmor.ArmorMaterial.GOLD, 4, EntityEquipmentSlot.CHEST).setTranslationKey("chestplateGold"));
        Item.registerItem(316, "golden_leggings", new ItemArmor(ItemArmor.ArmorMaterial.GOLD, 4, EntityEquipmentSlot.LEGS).setTranslationKey("leggingsGold"));
        Item.registerItem(317, "golden_boots", new ItemArmor(ItemArmor.ArmorMaterial.GOLD, 4, EntityEquipmentSlot.FEET).setTranslationKey("bootsGold"));
        Item.registerItem(318, "flint", new Item().setTranslationKey("flint").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(319, "porkchop", new ItemFood(3, 0.3f, true).setTranslationKey("porkchopRaw"));
        Item.registerItem(320, "cooked_porkchop", new ItemFood(8, 0.8f, true).setTranslationKey("porkchopCooked"));
        Item.registerItem(321, "painting", new ItemHangingEntity(EntityPainting.class).setTranslationKey("painting"));
        Item.registerItem(322, "golden_apple", new ItemAppleGold(4, 1.2f, false).setAlwaysEdible().setTranslationKey("appleGold"));
        Item.registerItem(323, "sign", new ItemSign().setTranslationKey("sign"));
        Item.registerItem(324, "wooden_door", new ItemDoor(Blocks.OAK_DOOR).setTranslationKey("doorOak"));
        Item item = new ItemBucket(Blocks.AIR).setTranslationKey("bucket").setMaxStackSize(16);
        Item.registerItem(325, "bucket", item);
        Item.registerItem(326, "water_bucket", new ItemBucket(Blocks.FLOWING_WATER).setTranslationKey("bucketWater").setContainerItem(item));
        Item.registerItem(327, "lava_bucket", new ItemBucket(Blocks.FLOWING_LAVA).setTranslationKey("bucketLava").setContainerItem(item));
        Item.registerItem(328, "minecart", new ItemMinecart(EntityMinecart.Type.RIDEABLE).setTranslationKey("minecart"));
        Item.registerItem(329, "saddle", new ItemSaddle().setTranslationKey("saddle"));
        Item.registerItem(330, "iron_door", new ItemDoor(Blocks.IRON_DOOR).setTranslationKey("doorIron"));
        Item.registerItem(331, "redstone", new ItemRedstone().setTranslationKey("redstone"));
        Item.registerItem(332, "snowball", new ItemSnowball().setTranslationKey("snowball"));
        Item.registerItem(333, "boat", (Item)new ItemBoat(EntityBoat.Type.OAK));
        Item.registerItem(334, "leather", new Item().setTranslationKey("leather").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(335, "milk_bucket", new ItemBucketMilk().setTranslationKey("milk").setContainerItem(item));
        Item.registerItem(336, "brick", new Item().setTranslationKey("brick").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(337, "clay_ball", new Item().setTranslationKey("clay").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(338, "reeds", new ItemBlockSpecial(Blocks.REEDS).setTranslationKey("reeds").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(339, "paper", new Item().setTranslationKey("paper").setCreativeTab(CreativeTabs.MISC));
        Item.registerItem(340, "book", new ItemBook().setTranslationKey("book").setCreativeTab(CreativeTabs.MISC));
        Item.registerItem(341, "slime_ball", new Item().setTranslationKey("slimeball").setCreativeTab(CreativeTabs.MISC));
        Item.registerItem(342, "chest_minecart", new ItemMinecart(EntityMinecart.Type.CHEST).setTranslationKey("minecartChest"));
        Item.registerItem(343, "furnace_minecart", new ItemMinecart(EntityMinecart.Type.FURNACE).setTranslationKey("minecartFurnace"));
        Item.registerItem(344, "egg", new ItemEgg().setTranslationKey("egg"));
        Item.registerItem(345, "compass", new ItemCompass().setTranslationKey("compass").setCreativeTab(CreativeTabs.TOOLS));
        Item.registerItem(346, "fishing_rod", new ItemFishingRod().setTranslationKey("fishingRod"));
        Item.registerItem(347, "clock", new ItemClock().setTranslationKey("clock").setCreativeTab(CreativeTabs.TOOLS));
        Item.registerItem(348, "glowstone_dust", new Item().setTranslationKey("yellowDust").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(349, "fish", new ItemFishFood(false).setTranslationKey("fish").setHasSubtypes(true));
        Item.registerItem(350, "cooked_fish", new ItemFishFood(true).setTranslationKey("fish").setHasSubtypes(true));
        Item.registerItem(351, "dye", new ItemDye().setTranslationKey("dyePowder"));
        Item.registerItem(352, "bone", new Item().setTranslationKey("bone").setFull3D().setCreativeTab(CreativeTabs.MISC));
        Item.registerItem(353, "sugar", new Item().setTranslationKey("sugar").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(354, "cake", new ItemBlockSpecial(Blocks.CAKE).setMaxStackSize(1).setTranslationKey("cake").setCreativeTab(CreativeTabs.FOOD));
        Item.registerItem(355, "bed", new ItemBed().setMaxStackSize(1).setTranslationKey("bed"));
        Item.registerItem(356, "repeater", new ItemBlockSpecial(Blocks.UNPOWERED_REPEATER).setTranslationKey("diode").setCreativeTab(CreativeTabs.REDSTONE));
        Item.registerItem(357, "cookie", new ItemFood(2, 0.1f, false).setTranslationKey("cookie"));
        Item.registerItem(358, "filled_map", new ItemMap().setTranslationKey("map"));
        Item.registerItem(359, "shears", new ItemShears().setTranslationKey("shears"));
        Item.registerItem(360, "melon", new ItemFood(2, 0.3f, false).setTranslationKey("melon"));
        Item.registerItem(361, "pumpkin_seeds", new ItemSeeds(Blocks.PUMPKIN_STEM, Blocks.FARMLAND).setTranslationKey("seeds_pumpkin"));
        Item.registerItem(362, "melon_seeds", new ItemSeeds(Blocks.MELON_STEM, Blocks.FARMLAND).setTranslationKey("seeds_melon"));
        Item.registerItem(363, "beef", new ItemFood(3, 0.3f, true).setTranslationKey("beefRaw"));
        Item.registerItem(364, "cooked_beef", new ItemFood(8, 0.8f, true).setTranslationKey("beefCooked"));
        Item.registerItem(365, "chicken", new ItemFood(2, 0.3f, true).setPotionEffect(new PotionEffect(MobEffects.HUNGER, 600, 0), 0.3f).setTranslationKey("chickenRaw"));
        Item.registerItem(366, "cooked_chicken", new ItemFood(6, 0.6f, true).setTranslationKey("chickenCooked"));
        Item.registerItem(367, "rotten_flesh", new ItemFood(4, 0.1f, true).setPotionEffect(new PotionEffect(MobEffects.HUNGER, 600, 0), 0.8f).setTranslationKey("rottenFlesh"));
        Item.registerItem(368, "ender_pearl", new ItemEnderPearl().setTranslationKey("enderPearl"));
        Item.registerItem(369, "blaze_rod", new Item().setTranslationKey("blazeRod").setCreativeTab(CreativeTabs.MATERIALS).setFull3D());
        Item.registerItem(370, "ghast_tear", new Item().setTranslationKey("ghastTear").setCreativeTab(CreativeTabs.BREWING));
        Item.registerItem(371, "gold_nugget", new Item().setTranslationKey("goldNugget").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(372, "nether_wart", new ItemSeeds(Blocks.NETHER_WART, Blocks.SOUL_SAND).setTranslationKey("netherStalkSeeds"));
        Item.registerItem(373, "potion", new ItemPotion().setTranslationKey("potion"));
        Item item1 = new ItemGlassBottle().setTranslationKey("glassBottle");
        Item.registerItem(374, "glass_bottle", item1);
        Item.registerItem(375, "spider_eye", new ItemFood(2, 0.8f, false).setPotionEffect(new PotionEffect(MobEffects.POISON, 100, 0), 1.0f).setTranslationKey("spiderEye"));
        Item.registerItem(376, "fermented_spider_eye", new Item().setTranslationKey("fermentedSpiderEye").setCreativeTab(CreativeTabs.BREWING));
        Item.registerItem(377, "blaze_powder", new Item().setTranslationKey("blazePowder").setCreativeTab(CreativeTabs.BREWING));
        Item.registerItem(378, "magma_cream", new Item().setTranslationKey("magmaCream").setCreativeTab(CreativeTabs.BREWING));
        Item.registerItem(379, "brewing_stand", new ItemBlockSpecial(Blocks.BREWING_STAND).setTranslationKey("brewingStand").setCreativeTab(CreativeTabs.BREWING));
        Item.registerItem(380, "cauldron", new ItemBlockSpecial(Blocks.CAULDRON).setTranslationKey("cauldron").setCreativeTab(CreativeTabs.BREWING));
        Item.registerItem(381, "ender_eye", new ItemEnderEye().setTranslationKey("eyeOfEnder"));
        Item.registerItem(382, "speckled_melon", new Item().setTranslationKey("speckledMelon").setCreativeTab(CreativeTabs.BREWING));
        Item.registerItem(383, "spawn_egg", new ItemMonsterPlacer().setTranslationKey("monsterPlacer"));
        Item.registerItem(384, "experience_bottle", new ItemExpBottle().setTranslationKey("expBottle"));
        Item.registerItem(385, "fire_charge", new ItemFireball().setTranslationKey("fireball"));
        Item.registerItem(386, "writable_book", new ItemWritableBook().setTranslationKey("writingBook").setCreativeTab(CreativeTabs.MISC));
        Item.registerItem(387, "written_book", new ItemWrittenBook().setTranslationKey("writtenBook").setMaxStackSize(16));
        Item.registerItem(388, "emerald", new Item().setTranslationKey("emerald").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(389, "item_frame", new ItemHangingEntity(EntityItemFrame.class).setTranslationKey("frame"));
        Item.registerItem(390, "flower_pot", new ItemBlockSpecial(Blocks.FLOWER_POT).setTranslationKey("flowerPot").setCreativeTab(CreativeTabs.DECORATIONS));
        Item.registerItem(391, "carrot", new ItemSeedFood(3, 0.6f, Blocks.CARROTS, Blocks.FARMLAND).setTranslationKey("carrots"));
        Item.registerItem(392, "potato", new ItemSeedFood(1, 0.3f, Blocks.POTATOES, Blocks.FARMLAND).setTranslationKey("potato"));
        Item.registerItem(393, "baked_potato", new ItemFood(5, 0.6f, false).setTranslationKey("potatoBaked"));
        Item.registerItem(394, "poisonous_potato", new ItemFood(2, 0.3f, false).setPotionEffect(new PotionEffect(MobEffects.POISON, 100, 0), 0.6f).setTranslationKey("potatoPoisonous"));
        Item.registerItem(395, "map", new ItemEmptyMap().setTranslationKey("emptyMap"));
        Item.registerItem(396, "golden_carrot", new ItemFood(6, 1.2f, false).setTranslationKey("carrotGolden").setCreativeTab(CreativeTabs.BREWING));
        Item.registerItem(397, "skull", new ItemSkull().setTranslationKey("skull"));
        Item.registerItem(398, "carrot_on_a_stick", new ItemCarrotOnAStick().setTranslationKey("carrotOnAStick"));
        Item.registerItem(399, "nether_star", new ItemSimpleFoiled().setTranslationKey("netherStar").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(400, "pumpkin_pie", new ItemFood(8, 0.3f, false).setTranslationKey("pumpkinPie").setCreativeTab(CreativeTabs.FOOD));
        Item.registerItem(401, "fireworks", new ItemFirework().setTranslationKey("fireworks"));
        Item.registerItem(402, "firework_charge", new ItemFireworkCharge().setTranslationKey("fireworksCharge").setCreativeTab(CreativeTabs.MISC));
        Item.registerItem(403, "enchanted_book", new ItemEnchantedBook().setMaxStackSize(1).setTranslationKey("enchantedBook"));
        Item.registerItem(404, "comparator", new ItemBlockSpecial(Blocks.UNPOWERED_COMPARATOR).setTranslationKey("comparator").setCreativeTab(CreativeTabs.REDSTONE));
        Item.registerItem(405, "netherbrick", new Item().setTranslationKey("netherbrick").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(406, "quartz", new Item().setTranslationKey("netherquartz").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(407, "tnt_minecart", new ItemMinecart(EntityMinecart.Type.TNT).setTranslationKey("minecartTnt"));
        Item.registerItem(408, "hopper_minecart", new ItemMinecart(EntityMinecart.Type.HOPPER).setTranslationKey("minecartHopper"));
        Item.registerItem(409, "prismarine_shard", new Item().setTranslationKey("prismarineShard").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(410, "prismarine_crystals", new Item().setTranslationKey("prismarineCrystals").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(411, "rabbit", new ItemFood(3, 0.3f, true).setTranslationKey("rabbitRaw"));
        Item.registerItem(412, "cooked_rabbit", new ItemFood(5, 0.6f, true).setTranslationKey("rabbitCooked"));
        Item.registerItem(413, "rabbit_stew", new ItemSoup(10).setTranslationKey("rabbitStew"));
        Item.registerItem(414, "rabbit_foot", new Item().setTranslationKey("rabbitFoot").setCreativeTab(CreativeTabs.BREWING));
        Item.registerItem(415, "rabbit_hide", new Item().setTranslationKey("rabbitHide").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(416, "armor_stand", new ItemArmorStand().setTranslationKey("armorStand").setMaxStackSize(16));
        Item.registerItem(417, "iron_horse_armor", new Item().setTranslationKey("horsearmormetal").setMaxStackSize(1).setCreativeTab(CreativeTabs.MISC));
        Item.registerItem(418, "golden_horse_armor", new Item().setTranslationKey("horsearmorgold").setMaxStackSize(1).setCreativeTab(CreativeTabs.MISC));
        Item.registerItem(419, "diamond_horse_armor", new Item().setTranslationKey("horsearmordiamond").setMaxStackSize(1).setCreativeTab(CreativeTabs.MISC));
        Item.registerItem(420, "lead", new ItemLead().setTranslationKey("leash"));
        Item.registerItem(421, "name_tag", new ItemNameTag().setTranslationKey("nameTag"));
        Item.registerItem(422, "command_block_minecart", new ItemMinecart(EntityMinecart.Type.COMMAND_BLOCK).setTranslationKey("minecartCommandBlock").setCreativeTab(null));
        Item.registerItem(423, "mutton", new ItemFood(2, 0.3f, true).setTranslationKey("muttonRaw"));
        Item.registerItem(424, "cooked_mutton", new ItemFood(6, 0.8f, true).setTranslationKey("muttonCooked"));
        Item.registerItem(425, "banner", new ItemBanner().setTranslationKey("banner"));
        Item.registerItem(426, "end_crystal", (Item)new ItemEndCrystal());
        Item.registerItem(427, "spruce_door", new ItemDoor(Blocks.SPRUCE_DOOR).setTranslationKey("doorSpruce"));
        Item.registerItem(428, "birch_door", new ItemDoor(Blocks.BIRCH_DOOR).setTranslationKey("doorBirch"));
        Item.registerItem(429, "jungle_door", new ItemDoor(Blocks.JUNGLE_DOOR).setTranslationKey("doorJungle"));
        Item.registerItem(430, "acacia_door", new ItemDoor(Blocks.ACACIA_DOOR).setTranslationKey("doorAcacia"));
        Item.registerItem(431, "dark_oak_door", new ItemDoor(Blocks.DARK_OAK_DOOR).setTranslationKey("doorDarkOak"));
        Item.registerItem(432, "chorus_fruit", new ItemChorusFruit(4, 0.3f).setAlwaysEdible().setTranslationKey("chorusFruit").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(433, "chorus_fruit_popped", new Item().setTranslationKey("chorusFruitPopped").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(434, "beetroot", new ItemFood(1, 0.6f, false).setTranslationKey("beetroot"));
        Item.registerItem(435, "beetroot_seeds", new ItemSeeds(Blocks.BEETROOTS, Blocks.FARMLAND).setTranslationKey("beetroot_seeds"));
        Item.registerItem(436, "beetroot_soup", new ItemSoup(6).setTranslationKey("beetroot_soup"));
        Item.registerItem(437, "dragon_breath", new Item().setCreativeTab(CreativeTabs.BREWING).setTranslationKey("dragon_breath").setContainerItem(item1));
        Item.registerItem(438, "splash_potion", new ItemSplashPotion().setTranslationKey("splash_potion"));
        Item.registerItem(439, "spectral_arrow", new ItemSpectralArrow().setTranslationKey("spectral_arrow"));
        Item.registerItem(440, "tipped_arrow", new ItemTippedArrow().setTranslationKey("tipped_arrow"));
        Item.registerItem(441, "lingering_potion", new ItemLingeringPotion().setTranslationKey("lingering_potion"));
        Item.registerItem(442, "shield", new ItemShield().setTranslationKey("shield"));
        Item.registerItem(443, "elytra", new ItemElytra().setTranslationKey("elytra"));
        Item.registerItem(444, "spruce_boat", (Item)new ItemBoat(EntityBoat.Type.SPRUCE));
        Item.registerItem(445, "birch_boat", (Item)new ItemBoat(EntityBoat.Type.BIRCH));
        Item.registerItem(446, "jungle_boat", (Item)new ItemBoat(EntityBoat.Type.JUNGLE));
        Item.registerItem(447, "acacia_boat", (Item)new ItemBoat(EntityBoat.Type.ACACIA));
        Item.registerItem(448, "dark_oak_boat", (Item)new ItemBoat(EntityBoat.Type.DARK_OAK));
        Item.registerItem(449, "totem_of_undying", new Item().setTranslationKey("totem").setMaxStackSize(1).setCreativeTab(CreativeTabs.COMBAT));
        Item.registerItem(450, "shulker_shell", new Item().setTranslationKey("shulkerShell").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(452, "iron_nugget", new Item().setTranslationKey("ironNugget").setCreativeTab(CreativeTabs.MATERIALS));
        Item.registerItem(453, "knowledge_book", new ItemKnowledgeBook().setTranslationKey("knowledgeBook"));
        Item.registerItem(2256, "record_13", new ItemRecord("13", SoundEvents.RECORD_13).setTranslationKey("record"));
        Item.registerItem(2257, "record_cat", new ItemRecord("cat", SoundEvents.RECORD_CAT).setTranslationKey("record"));
        Item.registerItem(2258, "record_blocks", new ItemRecord("blocks", SoundEvents.RECORD_BLOCKS).setTranslationKey("record"));
        Item.registerItem(2259, "record_chirp", new ItemRecord("chirp", SoundEvents.RECORD_CHIRP).setTranslationKey("record"));
        Item.registerItem(2260, "record_far", new ItemRecord("far", SoundEvents.RECORD_FAR).setTranslationKey("record"));
        Item.registerItem(2261, "record_mall", new ItemRecord("mall", SoundEvents.RECORD_MALL).setTranslationKey("record"));
        Item.registerItem(2262, "record_mellohi", new ItemRecord("mellohi", SoundEvents.RECORD_MELLOHI).setTranslationKey("record"));
        Item.registerItem(2263, "record_stal", new ItemRecord("stal", SoundEvents.RECORD_STAL).setTranslationKey("record"));
        Item.registerItem(2264, "record_strad", new ItemRecord("strad", SoundEvents.RECORD_STRAD).setTranslationKey("record"));
        Item.registerItem(2265, "record_ward", new ItemRecord("ward", SoundEvents.RECORD_WARD).setTranslationKey("record"));
        Item.registerItem(2266, "record_11", new ItemRecord("11", SoundEvents.RECORD_11).setTranslationKey("record"));
        Item.registerItem(2267, "record_wait", new ItemRecord("wait", SoundEvents.RECORD_WAIT).setTranslationKey("record"));
    }

    private static void registerItemBlock(Block blockIn) {
        Item.registerItemBlock(blockIn, new ItemBlock(blockIn));
    }

    protected static void registerItemBlock(Block blockIn, Item itemIn) {
        Item.registerItem(Block.getIdFromBlock(blockIn), Block.REGISTRY.getNameForObject(blockIn), itemIn);
        BLOCK_TO_ITEM.put(blockIn, itemIn);
    }

    private static void registerItem(int id, String textualID, Item itemIn) {
        Item.registerItem(id, new ResourceLocation(textualID), itemIn);
    }

    private static void registerItem(int id, ResourceLocation textualID, Item itemIn) {
        REGISTRY.register(id, textualID, itemIn);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getDefaultInstance() {
        return new ItemStack(this);
    }

    public static enum ToolMaterial {
        WOOD(0, 59, 2.0f, 0.0f, 15),
        STONE(1, 131, 4.0f, 1.0f, 5),
        IRON(2, 250, 6.0f, 2.0f, 14),
        DIAMOND(3, 1561, 8.0f, 3.0f, 10),
        GOLD(0, 32, 12.0f, 0.0f, 22);

        private final int harvestLevel;
        private final int maxUses;
        private final float efficiency;
        private final float attackDamage;
        private final int enchantability;
        private ItemStack repairMaterial = ItemStack.EMPTY;

        private ToolMaterial(int harvestLevel, int maxUses, float efficiency, float damageVsEntity, int enchantability) {
            this.harvestLevel = harvestLevel;
            this.maxUses = maxUses;
            this.efficiency = efficiency;
            this.attackDamage = damageVsEntity;
            this.enchantability = enchantability;
        }

        public int getMaxUses() {
            return this.maxUses;
        }

        public float getEfficiency() {
            return this.efficiency;
        }

        public float getAttackDamage() {
            return this.attackDamage;
        }

        public int getHarvestLevel() {
            return this.harvestLevel;
        }

        public int getEnchantability() {
            return this.enchantability;
        }

        @Deprecated
        public Item getRepairItem() {
            if (this == WOOD) {
                return Item.getItemFromBlock(Blocks.PLANKS);
            }
            if (this == STONE) {
                return Item.getItemFromBlock(Blocks.COBBLESTONE);
            }
            if (this == GOLD) {
                return Items.GOLD_INGOT;
            }
            if (this == IRON) {
                return Items.IRON_INGOT;
            }
            return this == DIAMOND ? Items.DIAMOND : null;
        }

        public ToolMaterial setRepairItem(ItemStack stack) {
            if (!this.repairMaterial.isEmpty()) {
                throw new RuntimeException("Repair material has already been set");
            }
            if (this == WOOD || this == STONE || this == GOLD || this == IRON || this == DIAMOND) {
                throw new RuntimeException("Can not change vanilla tool repair materials");
            }
            this.repairMaterial = stack;
            return this;
        }

        public ItemStack getRepairItemStack() {
            if (!this.repairMaterial.isEmpty()) {
                return this.repairMaterial;
            }
            Item ret = this.getRepairItem();
            if (ret != null) {
                this.repairMaterial = new ItemStack(ret, 1, Short.MAX_VALUE);
            }
            return this.repairMaterial;
        }
    }
}

