/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBanner
extends ItemBlock {
    public ItemBanner() {
        super(Blocks.STANDING_BANNER);
        this.maxStackSize = 16;
        this.setCreativeTab(CreativeTabs.DECORATIONS);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate = worldIn.getBlockState(pos);
        boolean flag = iblockstate.getBlock().isReplaceable(worldIn, pos);
        if (!(facing == EnumFacing.DOWN || !iblockstate.getMaterial().isSolid() && !flag || flag && facing != EnumFacing.UP)) {
            ItemStack itemstack;
            if (!player.canPlayerEdit(pos = pos.offset(facing), facing, itemstack = player.getHeldItem(hand)) || !Blocks.STANDING_BANNER.canPlaceBlockAt(worldIn, pos)) {
                return EnumActionResult.FAIL;
            }
            if (worldIn.isRemote) {
                return EnumActionResult.SUCCESS;
            }
            BlockPos blockPos = pos = flag ? pos.down() : pos;
            if (facing == EnumFacing.UP) {
                int i = MathHelper.floor((double)((player.rotationYaw + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF;
                worldIn.setBlockState(pos, Blocks.STANDING_BANNER.getDefaultState().withProperty(BlockStandingSign.ROTATION, i), 3);
            } else {
                worldIn.setBlockState(pos, Blocks.WALL_BANNER.getDefaultState().withProperty(BlockWallSign.FACING, facing), 3);
            }
            TileEntity tileentity = worldIn.getTileEntity(pos);
            if (tileentity instanceof TileEntityBanner) {
                ((TileEntityBanner)tileentity).setItemValues(itemstack, false);
            }
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.PLACED_BLOCK.trigger((EntityPlayerMP)player, pos, itemstack);
            }
            itemstack.shrink(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public String getItemStackDisplayName(ItemStack stack) {
        Object s = "item.banner.";
        EnumDyeColor enumdyecolor = ItemBanner.getBaseColor(stack);
        s = (String)s + enumdyecolor.getTranslationKey() + ".name";
        return I18n.translateToLocal((String)s);
    }

    @SideOnly(value=Side.CLIENT)
    public static void appendHoverTextFromTileEntityTag(ItemStack stack, List<String> p_185054_1_) {
        NBTTagCompound nbttagcompound = stack.getSubCompound("BlockEntityTag");
        if (nbttagcompound != null && nbttagcompound.hasKey("Patterns")) {
            NBTTagList nbttaglist = nbttagcompound.getTagList("Patterns", 10);
            for (int i = 0; i < nbttaglist.tagCount() && i < 6; ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
                EnumDyeColor enumdyecolor = EnumDyeColor.byDyeDamage(nbttagcompound1.getInteger("Color"));
                BannerPattern bannerpattern = BannerPattern.byHash(nbttagcompound1.getString("Pattern"));
                if (bannerpattern == null) continue;
                p_185054_1_.add(I18n.translateToLocal("item.banner." + bannerpattern.getFileName() + "." + enumdyecolor.getTranslationKey()));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ItemBanner.appendHoverTextFromTileEntityTag(stack, tooltip);
    }

    @Override
    public void getSubItems(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.isInCreativeTab(tab)) {
            for (EnumDyeColor enumdyecolor : EnumDyeColor.values()) {
                items.add(ItemBanner.makeBanner(enumdyecolor, null));
            }
        }
    }

    public static ItemStack makeBanner(EnumDyeColor color, @Nullable NBTTagList patterns) {
        ItemStack itemstack = new ItemStack(Items.BANNER, 1, color.getDyeDamage());
        if (patterns != null && !patterns.isEmpty()) {
            itemstack.getOrCreateSubCompound("BlockEntityTag").setTag("Patterns", patterns.copy());
        }
        return itemstack;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return CreativeTabs.DECORATIONS;
    }

    public static EnumDyeColor getBaseColor(ItemStack stack) {
        return EnumDyeColor.byDyeDamage(stack.getMetadata() & 0xF);
    }
}

