/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemMonsterPlacer
extends Item {
    public ItemMonsterPlacer() {
        this.setCreativeTab(CreativeTabs.MISC);
    }

    @Override
    public String getItemStackDisplayName(ItemStack stack) {
        Object s = I18n.translateToLocal(this.getTranslationKey() + ".name").trim();
        String s1 = EntityList.getTranslationName(ItemMonsterPlacer.getNamedIdFrom(stack));
        if (s1 != null) {
            s = (String)s + " " + I18n.translateToLocal("entity." + s1 + ".name");
        }
        return s;
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileentity;
        ItemStack itemstack = player.getHeldItem(hand);
        if (worldIn.isRemote) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.canPlayerEdit(pos.offset(facing), facing, itemstack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.getBlockState(pos);
        Block block = iblockstate.getBlock();
        if (block == Blocks.MOB_SPAWNER && (tileentity = worldIn.getTileEntity(pos)) instanceof TileEntityMobSpawner) {
            MobSpawnerBaseLogic mobspawnerbaselogic = ((TileEntityMobSpawner)tileentity).getSpawnerBaseLogic();
            mobspawnerbaselogic.setEntityId(ItemMonsterPlacer.getNamedIdFrom(itemstack));
            tileentity.markDirty();
            worldIn.notifyBlockUpdate(pos, iblockstate, iblockstate, 3);
            if (!player.capabilities.isCreativeMode) {
                itemstack.shrink(1);
            }
            return EnumActionResult.SUCCESS;
        }
        BlockPos blockpos = pos.offset(facing);
        double d0 = this.getYOffset(worldIn, blockpos);
        Entity entity = ItemMonsterPlacer.spawnCreature(worldIn, ItemMonsterPlacer.getNamedIdFrom(itemstack), (double)blockpos.getX() + 0.5, (double)blockpos.getY() + d0, (double)blockpos.getZ() + 0.5);
        if (entity != null) {
            if (entity instanceof EntityLivingBase && itemstack.hasDisplayName()) {
                entity.setCustomNameTag(itemstack.getDisplayName());
            }
            ItemMonsterPlacer.applyItemEntityDataToEntity(worldIn, player, itemstack, entity);
            if (!player.capabilities.isCreativeMode) {
                itemstack.shrink(1);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    protected double getYOffset(World p_190909_1_, BlockPos p_190909_2_) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(p_190909_2_).expand(0.0, -1.0, 0.0);
        List<AxisAlignedBB> list = p_190909_1_.getCollisionBoxes(null, axisalignedbb);
        if (list.isEmpty()) {
            return 0.0;
        }
        double d0 = axisalignedbb.minY;
        for (AxisAlignedBB axisalignedbb1 : list) {
            d0 = Math.max(axisalignedbb1.maxY, d0);
        }
        return d0 - (double)p_190909_2_.getY();
    }

    public static void applyItemEntityDataToEntity(World entityWorld, @Nullable EntityPlayer player, ItemStack stack, @Nullable Entity targetEntity) {
        NBTTagCompound nbttagcompound;
        MinecraftServer minecraftserver = entityWorld.getMinecraftServer();
        if (minecraftserver != null && targetEntity != null && (nbttagcompound = stack.getTagCompound()) != null && nbttagcompound.hasKey("EntityTag", 10)) {
            if (!(entityWorld.isRemote || !targetEntity.ignoreItemEntityData() || player != null && minecraftserver.getPlayerList().canSendCommands(player.getGameProfile()))) {
                return;
            }
            NBTTagCompound nbttagcompound1 = targetEntity.writeToNBT(new NBTTagCompound());
            UUID uuid = targetEntity.getUniqueID();
            nbttagcompound1.merge(nbttagcompound.getCompoundTag("EntityTag"));
            targetEntity.setUniqueId(uuid);
            targetEntity.readFromNBT(nbttagcompound1);
        }
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.getHeldItem(handIn);
        if (worldIn.isRemote) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, itemstack);
        }
        RayTraceResult raytraceresult = this.rayTrace(worldIn, playerIn, true);
        if (raytraceresult != null && raytraceresult.typeOfHit == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.getBlockPos();
            if (!(worldIn.getBlockState(blockpos).getBlock() instanceof BlockLiquid)) {
                return new ActionResult<ItemStack>(EnumActionResult.PASS, itemstack);
            }
            if (worldIn.isBlockModifiable(playerIn, blockpos) && playerIn.canPlayerEdit(blockpos, raytraceresult.sideHit, itemstack)) {
                Entity entity = ItemMonsterPlacer.spawnCreature(worldIn, ItemMonsterPlacer.getNamedIdFrom(itemstack), (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5);
                if (entity == null) {
                    return new ActionResult<ItemStack>(EnumActionResult.PASS, itemstack);
                }
                if (entity instanceof EntityLivingBase && itemstack.hasDisplayName()) {
                    entity.setCustomNameTag(itemstack.getDisplayName());
                }
                ItemMonsterPlacer.applyItemEntityDataToEntity(worldIn, playerIn, itemstack, entity);
                if (!playerIn.capabilities.isCreativeMode) {
                    itemstack.shrink(1);
                }
                playerIn.addStat(StatList.getObjectUseStats(this));
                return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, itemstack);
            }
            return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
        }
        return new ActionResult<ItemStack>(EnumActionResult.PASS, itemstack);
    }

    @Nullable
    public static Entity spawnCreature(World worldIn, @Nullable ResourceLocation entityID, double x, double y, double z) {
        if (entityID != null && EntityList.ENTITY_EGGS.containsKey(entityID)) {
            Entity entity = null;
            for (int i = 0; i < 1; ++i) {
                entity = EntityList.createEntityByIDFromName(entityID, worldIn);
                if (!(entity instanceof EntityLiving)) continue;
                EntityLiving entityliving = (EntityLiving)entity;
                entity.setLocationAndAngles(x, y, z, MathHelper.wrapDegrees(worldIn.rand.nextFloat() * 360.0f), 0.0f);
                entityliving.rotationYawHead = entityliving.rotationYaw;
                entityliving.renderYawOffset = entityliving.rotationYaw;
                if (ForgeEventFactory.doSpecialSpawn(entityliving, worldIn, (float)x, (float)y, (float)z, null)) {
                    return null;
                }
                entityliving.onInitialSpawn(worldIn.getDifficultyForLocation(new BlockPos(entityliving)), null);
                worldIn.spawnEntity(entity);
                entityliving.playLivingSound();
            }
            return entity;
        }
        return null;
    }

    @Override
    public void getSubItems(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.isInCreativeTab(tab)) {
            for (EntityList.EntityEggInfo entitylist$entityegginfo : EntityList.ENTITY_EGGS.values()) {
                ItemStack itemstack = new ItemStack((Item)this, 1);
                ItemMonsterPlacer.applyEntityIdToItemStack(itemstack, entitylist$entityegginfo.spawnedID);
                items.add(itemstack);
            }
        }
    }

    public static void applyEntityIdToItemStack(ItemStack stack, ResourceLocation entityId) {
        NBTTagCompound nbttagcompound = stack.hasTagCompound() ? stack.getTagCompound() : new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.setString("id", entityId.toString());
        nbttagcompound.setTag("EntityTag", nbttagcompound1);
        stack.setTagCompound(nbttagcompound);
    }

    @Nullable
    public static ResourceLocation getNamedIdFrom(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.getTagCompound();
        if (nbttagcompound == null) {
            return null;
        }
        if (!nbttagcompound.hasKey("EntityTag", 10)) {
            return null;
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.getCompoundTag("EntityTag");
        if (!nbttagcompound1.hasKey("id", 8)) {
            return null;
        }
        String s = nbttagcompound1.getString("id");
        ResourceLocation resourcelocation = new ResourceLocation(s);
        if (!s.contains(":")) {
            nbttagcompound1.setString("id", resourcelocation.toString());
        }
        return resourcelocation;
    }
}

