/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class ItemSkull
extends Item {
    private static final String[] SKULL_TYPES = new String[]{"skeleton", "wither", "zombie", "char", "creeper", "dragon"};

    public ItemSkull() {
        this.setCreativeTab(CreativeTabs.DECORATIONS);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack;
        IBlockState iblockstate;
        Block block;
        boolean flag;
        if (facing == EnumFacing.DOWN) {
            return EnumActionResult.FAIL;
        }
        if (worldIn.getBlockState(pos).getBlock().isReplaceable(worldIn, pos)) {
            facing = EnumFacing.UP;
            pos = pos.down();
        }
        if (!(flag = (block = (iblockstate = worldIn.getBlockState(pos)).getBlock()).isReplaceable(worldIn, pos))) {
            if (!worldIn.getBlockState(pos).getMaterial().isSolid() && !worldIn.isSideSolid(pos, facing, true)) {
                return EnumActionResult.FAIL;
            }
            pos = pos.offset(facing);
        }
        if (player.canPlayerEdit(pos, facing, itemstack = player.getHeldItem(hand)) && Blocks.SKULL.canPlaceBlockAt(worldIn, pos)) {
            TileEntity tileentity;
            if (worldIn.isRemote) {
                return EnumActionResult.SUCCESS;
            }
            worldIn.setBlockState(pos, Blocks.SKULL.getDefaultState().withProperty(BlockSkull.FACING, facing), 11);
            int i = 0;
            if (facing == EnumFacing.UP) {
                i = MathHelper.floor((double)(player.rotationYaw * 16.0f / 360.0f) + 0.5) & 0xF;
            }
            if ((tileentity = worldIn.getTileEntity(pos)) instanceof TileEntitySkull) {
                TileEntitySkull tileentityskull = (TileEntitySkull)tileentity;
                if (itemstack.getMetadata() == 3) {
                    GameProfile gameprofile = null;
                    if (itemstack.hasTagCompound()) {
                        NBTTagCompound nbttagcompound = itemstack.getTagCompound();
                        if (nbttagcompound.hasKey("SkullOwner", 10)) {
                            gameprofile = NBTUtil.readGameProfileFromNBT(nbttagcompound.getCompoundTag("SkullOwner"));
                        } else if (nbttagcompound.hasKey("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)nbttagcompound.getString("SkullOwner"))) {
                            gameprofile = new GameProfile((UUID)null, nbttagcompound.getString("SkullOwner"));
                        }
                    }
                    tileentityskull.setPlayerProfile(gameprofile);
                } else {
                    tileentityskull.setType(itemstack.getMetadata());
                }
                tileentityskull.setSkullRotation(i);
                Blocks.SKULL.checkWitherSpawn(worldIn, pos, tileentityskull);
            }
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.PLACED_BLOCK.trigger((EntityPlayerMP)player, pos, itemstack);
            }
            itemstack.shrink(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public void getSubItems(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.isInCreativeTab(tab)) {
            for (int i = 0; i < SKULL_TYPES.length; ++i) {
                items.add(new ItemStack(this, 1, i));
            }
        }
    }

    @Override
    public int getMetadata(int damage) {
        return damage;
    }

    @Override
    public String getTranslationKey(ItemStack stack) {
        int i = stack.getMetadata();
        if (i < 0 || i >= SKULL_TYPES.length) {
            i = 0;
        }
        return super.getTranslationKey() + "." + SKULL_TYPES[i];
    }

    @Override
    public String getItemStackDisplayName(ItemStack stack) {
        if (stack.getMetadata() == 3 && stack.hasTagCompound()) {
            NBTTagCompound nbttagcompound;
            if (stack.getTagCompound().hasKey("SkullOwner", 8)) {
                return I18n.translateToLocalFormatted("item.skull.player.name", stack.getTagCompound().getString("SkullOwner"));
            }
            if (stack.getTagCompound().hasKey("SkullOwner", 10) && (nbttagcompound = stack.getTagCompound().getCompoundTag("SkullOwner")).hasKey("Name", 8)) {
                return I18n.translateToLocalFormatted("item.skull.player.name", nbttagcompound.getString("Name"));
            }
        }
        return super.getItemStackDisplayName(stack);
    }

    @Override
    public boolean updateItemStackNBT(NBTTagCompound nbt) {
        super.updateItemStackNBT(nbt);
        if (nbt.hasKey("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)nbt.getString("SkullOwner"))) {
            GameProfile gameprofile = new GameProfile((UUID)null, nbt.getString("SkullOwner"));
            gameprofile = TileEntitySkull.updateGameProfile(gameprofile);
            nbt.setTag("SkullOwner", NBTUtil.writeGameProfile(new NBTTagCompound(), gameprofile));
            return true;
        }
        return false;
    }
}

