/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.BlockEntityTag;
import net.minecraft.util.datafix.walkers.EntityTag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IRegistryDelegate;

public final class ItemStack
implements ICapabilitySerializable<NBTTagCompound> {
    public static final ItemStack EMPTY = new ItemStack((Item)null);
    public static final DecimalFormat DECIMALFORMAT = new DecimalFormat("#.##");
    private int stackSize;
    private int animationsToGo;
    private final Item item;
    private NBTTagCompound stackTagCompound;
    private boolean isEmpty;
    int itemDamage;
    private EntityItemFrame itemFrame;
    private Block canDestroyCacheBlock;
    private boolean canDestroyCacheResult;
    private Block canPlaceOnCacheBlock;
    private boolean canPlaceOnCacheResult;
    private IRegistryDelegate<Item> delegate;
    private CapabilityDispatcher capabilities;
    private NBTTagCompound capNBT;

    public ItemStack(Block blockIn) {
        this(blockIn, 1);
    }

    public ItemStack(Block blockIn, int amount) {
        this(blockIn, amount, 0);
    }

    public ItemStack(Block blockIn, int amount, int meta) {
        this(Item.getItemFromBlock(blockIn), amount, meta);
    }

    public ItemStack(Item itemIn) {
        this(itemIn, 1);
    }

    public ItemStack(Item itemIn, int amount) {
        this(itemIn, amount, 0);
    }

    public ItemStack(Item itemIn, int amount, int meta) {
        this(itemIn, amount, meta, null);
    }

    public ItemStack(Item itemIn, int amount, int meta, @Nullable NBTTagCompound capNBT) {
        this.capNBT = capNBT;
        this.item = itemIn;
        this.itemDamage = meta;
        this.stackSize = amount;
        if (this.itemDamage < 0) {
            this.itemDamage = 0;
        }
        this.updateEmptyState();
        this.forgeInit();
    }

    private void updateEmptyState() {
        this.isEmpty = this.isEmpty();
    }

    public ItemStack(NBTTagCompound compound) {
        this.capNBT = compound.hasKey("ForgeCaps") ? compound.getCompoundTag("ForgeCaps") : null;
        this.item = compound.hasKey("id", 8) ? Item.getByNameOrId(compound.getString("id")) : Items.AIR;
        this.stackSize = compound.getByte("Count");
        this.itemDamage = Math.max(0, compound.getShort("Damage"));
        if (compound.hasKey("tag", 10)) {
            this.stackTagCompound = compound.getCompoundTag("tag");
            if (this.item != null) {
                this.item.updateItemStackNBT(compound);
            }
        }
        this.updateEmptyState();
        this.forgeInit();
    }

    private ItemStack(Item item, Object unused) {
        this.item = item;
    }

    public boolean isEmpty() {
        if (this == EMPTY) {
            return true;
        }
        if (this.getItemRaw() != null && this.getItemRaw() != Items.AIR) {
            if (this.stackSize <= 0) {
                return true;
            }
            return this.itemDamage < Short.MIN_VALUE || this.itemDamage > 65535;
        }
        return true;
    }

    public static void registerFixes(DataFixer fixer) {
        fixer.registerWalker(FixTypes.ITEM_INSTANCE, new BlockEntityTag());
        fixer.registerWalker(FixTypes.ITEM_INSTANCE, new EntityTag());
    }

    public ItemStack splitStack(int amount) {
        int i = Math.min(amount, this.stackSize);
        ItemStack itemstack = this.copy();
        itemstack.setCount(i);
        this.shrink(i);
        return itemstack;
    }

    public Item getItem() {
        return this.isEmpty || this.delegate == null ? Items.AIR : this.delegate.get();
    }

    public EnumActionResult onItemUse(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.isRemote) {
            return ForgeHooks.onPlaceItemIntoWorld(this, playerIn, worldIn, pos, side, hitX, hitY, hitZ, hand);
        }
        EnumActionResult enumactionresult = this.getItem().onItemUse(playerIn, worldIn, pos, hand, side, hitX, hitY, hitZ);
        if (enumactionresult == EnumActionResult.SUCCESS) {
            playerIn.addStat(StatList.getObjectUseStats(this.item));
        }
        return enumactionresult;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        EnumActionResult enumactionresult = this.getItem().onItemUseFirst(playerIn, worldIn, pos, side, hitX, hitY, hitZ, hand);
        if (enumactionresult == EnumActionResult.SUCCESS) {
            playerIn.addStat(StatList.getObjectUseStats(this.item));
        }
        return enumactionresult;
    }

    public float getDestroySpeed(IBlockState blockIn) {
        return this.getItem().getDestroySpeed(this, blockIn);
    }

    public ActionResult<ItemStack> useItemRightClick(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        return this.getItem().onItemRightClick(worldIn, playerIn, hand);
    }

    public ItemStack onItemUseFinish(World worldIn, EntityLivingBase entityLiving) {
        return this.getItem().onItemUseFinish(this, worldIn, entityLiving);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound cnbt;
        ResourceLocation resourcelocation = Item.REGISTRY.getNameForObject(this.item);
        nbt.setString("id", resourcelocation == null ? "minecraft:air" : resourcelocation.toString());
        nbt.setByte("Count", (byte)this.stackSize);
        nbt.setShort("Damage", (short)this.itemDamage);
        if (this.stackTagCompound != null) {
            nbt.setTag("tag", this.stackTagCompound);
        }
        if (this.capabilities != null && !(cnbt = this.capabilities.serializeNBT()).isEmpty()) {
            nbt.setTag("ForgeCaps", cnbt);
        }
        return nbt;
    }

    public int getMaxStackSize() {
        return this.getItem().getItemStackLimit(this);
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isItemStackDamageable() || !this.isItemDamaged());
    }

    public boolean isItemStackDamageable() {
        if (this.isEmpty) {
            return false;
        }
        if (this.item.getMaxDamage(this) <= 0) {
            return false;
        }
        return !this.hasTagCompound() || !this.getTagCompound().getBoolean("Unbreakable");
    }

    public boolean getHasSubtypes() {
        return this.getItem().getHasSubtypes();
    }

    public boolean isItemDamaged() {
        return this.isItemStackDamageable() && this.getItem().isDamaged(this);
    }

    public int getItemDamage() {
        return this.getItem().getDamage(this);
    }

    public int getMetadata() {
        return this.getItem().getMetadata(this);
    }

    public void setItemDamage(int meta) {
        this.getItem().setDamage(this, meta);
    }

    public int getMaxDamage() {
        return this.getItem().getMaxDamage(this);
    }

    public boolean attemptDamageItem(int amount, Random rand, @Nullable EntityPlayerMP damager) {
        if (!this.isItemStackDamageable()) {
            return false;
        }
        if (amount > 0) {
            int i = EnchantmentHelper.getEnchantmentLevel(Enchantments.UNBREAKING, this);
            int j = 0;
            for (int k = 0; i > 0 && k < amount; ++k) {
                if (!EnchantmentDurability.negateDamage(this, i, rand)) continue;
                ++j;
            }
            if ((amount -= j) <= 0) {
                return false;
            }
        }
        if (damager != null && amount != 0) {
            CriteriaTriggers.ITEM_DURABILITY_CHANGED.trigger(damager, this, this.itemDamage + amount);
        }
        this.setItemDamage(this.getItemDamage() + amount);
        return this.getItemDamage() > this.getMaxDamage();
    }

    public void damageItem(int amount, EntityLivingBase entityIn) {
        if ((!(entityIn instanceof EntityPlayer) || !((EntityPlayer)entityIn).capabilities.isCreativeMode) && this.isItemStackDamageable() && this.attemptDamageItem(amount, entityIn.getRNG(), entityIn instanceof EntityPlayerMP ? (EntityPlayerMP)entityIn : null)) {
            entityIn.renderBrokenItemStack(this);
            this.shrink(1);
            if (entityIn instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                entityplayer.addStat(StatList.getObjectBreakStats(this.item));
            }
            this.itemDamage = 0;
        }
    }

    public void hitEntity(EntityLivingBase entityIn, EntityPlayer playerIn) {
        boolean flag = this.item.hitEntity(this, entityIn, playerIn);
        if (flag) {
            playerIn.addStat(StatList.getObjectUseStats(this.item));
        }
    }

    public void onBlockDestroyed(World worldIn, IBlockState blockIn, BlockPos pos, EntityPlayer playerIn) {
        boolean flag = this.getItem().onBlockDestroyed(this, worldIn, blockIn, pos, playerIn);
        if (flag) {
            playerIn.addStat(StatList.getObjectUseStats(this.item));
        }
    }

    public boolean canHarvestBlock(IBlockState blockIn) {
        return this.getItem().canHarvestBlock(blockIn, this);
    }

    public boolean interactWithEntity(EntityPlayer playerIn, EntityLivingBase entityIn, EnumHand hand) {
        return this.getItem().itemInteractionForEntity(this, playerIn, entityIn, hand);
    }

    public ItemStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack copy = new ItemStack(this.item, null);
        copy.stackSize = this.stackSize;
        copy.itemDamage = this.itemDamage;
        copy.animationsToGo = this.animationsToGo;
        if (this.stackTagCompound != null) {
            copy.stackTagCompound = this.stackTagCompound.copy();
        }
        if (this.capabilities != null) {
            copy.capNBT = this.capabilities.serializeNBT();
        }
        copy.delegate = this.delegate;
        ICapabilityProvider provider = copy.item.initCapabilities(copy, copy.capNBT);
        copy.capabilities = ForgeEventFactory.gatherCapabilities(copy, provider);
        if (copy.capNBT != null && copy.capabilities != null) {
            copy.capabilities.deserializeNBT(copy.capNBT);
        }
        return copy;
    }

    public static boolean areItemStackTagsEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA.isEmpty() && stackB.isEmpty()) {
            return true;
        }
        if (!stackA.isEmpty() && !stackB.isEmpty()) {
            if (stackA.stackTagCompound == null && stackB.stackTagCompound != null) {
                return false;
            }
            return (stackA.stackTagCompound == null || stackA.stackTagCompound.equals(stackB.stackTagCompound)) && stackA.areCapsCompatible(stackB);
        }
        return false;
    }

    public static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA.isEmpty() && stackB.isEmpty()) {
            return true;
        }
        return !stackA.isEmpty() && !stackB.isEmpty() ? stackA.isItemStackEqual(stackB) : false;
    }

    private boolean isItemStackEqual(ItemStack other) {
        if (this.stackSize != other.stackSize) {
            return false;
        }
        if (this.getItem() != other.getItem()) {
            return false;
        }
        if (this.itemDamage != other.itemDamage) {
            return false;
        }
        if (this.stackTagCompound == null && other.stackTagCompound != null) {
            return false;
        }
        return (this.stackTagCompound == null || this.stackTagCompound.equals(other.stackTagCompound)) && this.areCapsCompatible(other);
    }

    public static boolean areItemsEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA == stackB) {
            return true;
        }
        return !stackA.isEmpty() && !stackB.isEmpty() ? stackA.isItemEqual(stackB) : false;
    }

    public static boolean areItemsEqualIgnoreDurability(ItemStack stackA, ItemStack stackB) {
        if (stackA == stackB) {
            return true;
        }
        return !stackA.isEmpty() && !stackB.isEmpty() ? stackA.isItemEqualIgnoreDurability(stackB) : false;
    }

    public boolean isItemEqual(ItemStack other) {
        return !other.isEmpty() && this.item == other.item && this.itemDamage == other.itemDamage;
    }

    public boolean isItemEqualIgnoreDurability(ItemStack stack) {
        if (!this.isItemStackDamageable()) {
            return this.isItemEqual(stack);
        }
        return !stack.isEmpty() && this.item == stack.item;
    }

    public String getTranslationKey() {
        return this.getItem().getTranslationKey(this);
    }

    public String toString() {
        return this.stackSize + "x" + this.getItem().getTranslationKey() + "@" + this.itemDamage;
    }

    public void updateAnimation(World worldIn, Entity entityIn, int inventorySlot, boolean isCurrentItem) {
        if (this.animationsToGo > 0) {
            --this.animationsToGo;
        }
        if (this.item != null) {
            this.item.onUpdate(this, worldIn, entityIn, inventorySlot, isCurrentItem);
        }
    }

    public void onCrafting(World worldIn, EntityPlayer playerIn, int amount) {
        playerIn.addStat(StatList.getCraftStats(this.item), amount);
        this.getItem().onCreated(this, worldIn, playerIn);
    }

    public int getMaxItemUseDuration() {
        return this.getItem().getMaxItemUseDuration(this);
    }

    public EnumAction getItemUseAction() {
        return this.getItem().getItemUseAction(this);
    }

    public void onPlayerStoppedUsing(World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        this.getItem().onPlayerStoppedUsing(this, worldIn, entityLiving, timeLeft);
    }

    public boolean hasTagCompound() {
        return !this.isEmpty && this.stackTagCompound != null;
    }

    @Nullable
    public NBTTagCompound getTagCompound() {
        return this.stackTagCompound;
    }

    public NBTTagCompound getOrCreateSubCompound(String key) {
        if (this.stackTagCompound != null && this.stackTagCompound.hasKey(key, 10)) {
            return this.stackTagCompound.getCompoundTag(key);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.setTagInfo(key, nbttagcompound);
        return nbttagcompound;
    }

    @Nullable
    public NBTTagCompound getSubCompound(String key) {
        return this.stackTagCompound != null && this.stackTagCompound.hasKey(key, 10) ? this.stackTagCompound.getCompoundTag(key) : null;
    }

    public void removeSubCompound(String key) {
        if (this.stackTagCompound != null && this.stackTagCompound.hasKey(key, 10)) {
            this.stackTagCompound.removeTag(key);
        }
    }

    public NBTTagList getEnchantmentTagList() {
        return this.stackTagCompound != null ? this.stackTagCompound.getTagList("ench", 10) : new NBTTagList();
    }

    public void setTagCompound(@Nullable NBTTagCompound nbt) {
        this.stackTagCompound = nbt;
    }

    public String getDisplayName() {
        NBTTagCompound nbttagcompound = this.getSubCompound("display");
        if (nbttagcompound != null) {
            if (nbttagcompound.hasKey("Name", 8)) {
                return nbttagcompound.getString("Name");
            }
            if (nbttagcompound.hasKey("LocName", 8)) {
                return I18n.translateToLocal(nbttagcompound.getString("LocName"));
            }
        }
        return this.getItem().getItemStackDisplayName(this);
    }

    public ItemStack setTranslatableName(String p_190924_1_) {
        this.getOrCreateSubCompound("display").setString("LocName", p_190924_1_);
        return this;
    }

    public ItemStack setStackDisplayName(String displayName) {
        this.getOrCreateSubCompound("display").setString("Name", displayName);
        return this;
    }

    public void clearCustomName() {
        NBTTagCompound nbttagcompound = this.getSubCompound("display");
        if (nbttagcompound != null) {
            nbttagcompound.removeTag("Name");
            if (nbttagcompound.isEmpty()) {
                this.removeSubCompound("display");
            }
        }
        if (this.stackTagCompound != null && this.stackTagCompound.isEmpty()) {
            this.stackTagCompound = null;
        }
    }

    public boolean hasDisplayName() {
        NBTTagCompound nbttagcompound = this.getSubCompound("display");
        return nbttagcompound != null && nbttagcompound.hasKey("Name", 8);
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getTooltip(@Nullable EntityPlayer playerIn, ITooltipFlag advanced) {
        NBTTagList nbttaglist2;
        NBTTagList nbttaglist1;
        ArrayList list = Lists.newArrayList();
        Object s = this.getDisplayName();
        if (this.hasDisplayName()) {
            s = String.valueOf((Object)TextFormatting.ITALIC) + (String)s;
        }
        s = (String)s + String.valueOf((Object)TextFormatting.RESET);
        if (advanced.isAdvanced()) {
            String s1 = "";
            if (!((String)s).isEmpty()) {
                s = (String)s + " (";
                s1 = ")";
            }
            int i = Item.getIdFromItem(this.item);
            s = this.getHasSubtypes() ? (String)s + String.format("#%04d/%d%s", i, this.itemDamage, s1) : (String)s + String.format("#%04d%s", i, s1);
        } else if (!this.hasDisplayName() && this.item == Items.FILLED_MAP) {
            s = (String)s + " #" + this.itemDamage;
        }
        list.add(s);
        int i1 = 0;
        if (this.hasTagCompound() && this.stackTagCompound.hasKey("HideFlags", 99)) {
            i1 = this.stackTagCompound.getInteger("HideFlags");
        }
        if ((i1 & 0x20) == 0) {
            this.getItem().addInformation(this, playerIn == null ? null : playerIn.world, list, advanced);
        }
        if (this.hasTagCompound()) {
            if ((i1 & 1) == 0) {
                NBTTagList nbttaglist = this.getEnchantmentTagList();
                for (int j = 0; j < nbttaglist.tagCount(); ++j) {
                    NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(j);
                    short k = nbttagcompound.getShort("id");
                    short l = nbttagcompound.getShort("lvl");
                    Enchantment enchantment = Enchantment.getEnchantmentByID(k);
                    if (enchantment == null) continue;
                    list.add(enchantment.getTranslatedName(l));
                }
            }
            if (this.stackTagCompound.hasKey("display", 10)) {
                NBTTagList nbttaglist3;
                NBTTagCompound nbttagcompound1 = this.stackTagCompound.getCompoundTag("display");
                if (nbttagcompound1.hasKey("color", 3)) {
                    if (advanced.isAdvanced()) {
                        list.add(I18n.translateToLocalFormatted("item.color", String.format("#%06X", nbttagcompound1.getInteger("color"))));
                    } else {
                        list.add(String.valueOf((Object)TextFormatting.ITALIC) + I18n.translateToLocal("item.dyed"));
                    }
                }
                if (nbttagcompound1.getTagId("Lore") == 9 && !(nbttaglist3 = nbttagcompound1.getTagList("Lore", 8)).isEmpty()) {
                    for (int l1 = 0; l1 < nbttaglist3.tagCount(); ++l1) {
                        list.add(String.valueOf((Object)TextFormatting.DARK_PURPLE) + String.valueOf((Object)TextFormatting.ITALIC) + nbttaglist3.getStringTagAt(l1));
                    }
                }
            }
        }
        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            Multimap<String, AttributeModifier> multimap = this.getAttributeModifiers(entityequipmentslot);
            if (multimap.isEmpty() || (i1 & 2) != 0) continue;
            list.add("");
            list.add(I18n.translateToLocal("item.modifiers." + entityequipmentslot.getName()));
            for (Map.Entry entry : multimap.entries()) {
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                double d0 = attributemodifier.getAmount();
                boolean flag = false;
                if (playerIn != null) {
                    if (attributemodifier.getID() == Item.ATTACK_DAMAGE_MODIFIER) {
                        d0 += playerIn.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getBaseValue();
                        d0 += (double)EnchantmentHelper.getModifierForCreature(this, EnumCreatureAttribute.UNDEFINED);
                        flag = true;
                    } else if (attributemodifier.getID() == Item.ATTACK_SPEED_MODIFIER) {
                        d0 += playerIn.getEntityAttribute(SharedMonsterAttributes.ATTACK_SPEED).getBaseValue();
                        flag = true;
                    }
                }
                double d1 = attributemodifier.getOperation() != 1 && attributemodifier.getOperation() != 2 ? d0 : d0 * 100.0;
                if (flag) {
                    list.add(" " + I18n.translateToLocalFormatted("attribute.modifier.equals." + attributemodifier.getOperation(), DECIMALFORMAT.format(d1), I18n.translateToLocal("attribute.name." + (String)entry.getKey())));
                    continue;
                }
                if (d0 > 0.0) {
                    list.add(String.valueOf((Object)TextFormatting.BLUE) + " " + I18n.translateToLocalFormatted("attribute.modifier.plus." + attributemodifier.getOperation(), DECIMALFORMAT.format(d1), I18n.translateToLocal("attribute.name." + (String)entry.getKey())));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                list.add(String.valueOf((Object)TextFormatting.RED) + " " + I18n.translateToLocalFormatted("attribute.modifier.take." + attributemodifier.getOperation(), DECIMALFORMAT.format(d1 *= -1.0), I18n.translateToLocal("attribute.name." + (String)entry.getKey())));
                list.add(" " + I18n.translateToLocalFormatted("attribute.modifier.equals." + attributemodifier.getOperation(), DECIMALFORMAT.format(d1), I18n.translateToLocal("attribute.name." + (String)entry.getKey())));
            }
        }
        if (this.hasTagCompound() && this.getTagCompound().getBoolean("Unbreakable") && (i1 & 4) == 0) {
            list.add(String.valueOf((Object)TextFormatting.BLUE) + I18n.translateToLocal("item.unbreakable"));
        }
        if (this.hasTagCompound() && this.stackTagCompound.hasKey("CanDestroy", 9) && (i1 & 8) == 0 && !(nbttaglist1 = this.stackTagCompound.getTagList("CanDestroy", 8)).isEmpty()) {
            list.add("");
            list.add(String.valueOf((Object)TextFormatting.GRAY) + I18n.translateToLocal("item.canBreak"));
            for (int j1 = 0; j1 < nbttaglist1.tagCount(); ++j1) {
                Block block = Block.getBlockFromName(nbttaglist1.getStringTagAt(j1));
                if (block != null) {
                    list.add(String.valueOf((Object)TextFormatting.DARK_GRAY) + block.getLocalizedName());
                    continue;
                }
                list.add(String.valueOf((Object)TextFormatting.DARK_GRAY) + "missingno");
            }
        }
        if (this.hasTagCompound() && this.stackTagCompound.hasKey("CanPlaceOn", 9) && (i1 & 0x10) == 0 && !(nbttaglist2 = this.stackTagCompound.getTagList("CanPlaceOn", 8)).isEmpty()) {
            list.add("");
            list.add(String.valueOf((Object)TextFormatting.GRAY) + I18n.translateToLocal("item.canPlace"));
            for (int k1 = 0; k1 < nbttaglist2.tagCount(); ++k1) {
                Block block1 = Block.getBlockFromName(nbttaglist2.getStringTagAt(k1));
                if (block1 != null) {
                    list.add(String.valueOf((Object)TextFormatting.DARK_GRAY) + block1.getLocalizedName());
                    continue;
                }
                list.add(String.valueOf((Object)TextFormatting.DARK_GRAY) + "missingno");
            }
        }
        if (advanced.isAdvanced()) {
            if (this.isItemDamaged()) {
                list.add(I18n.translateToLocalFormatted("item.durability", this.getMaxDamage() - this.getItemDamage(), this.getMaxDamage()));
            }
            list.add(String.valueOf((Object)TextFormatting.DARK_GRAY) + Item.REGISTRY.getNameForObject(this.item).toString());
            if (this.hasTagCompound()) {
                list.add(String.valueOf((Object)TextFormatting.DARK_GRAY) + I18n.translateToLocalFormatted("item.nbt_tags", this.getTagCompound().getKeySet().size()));
            }
        }
        ForgeEventFactory.onItemTooltip(this, playerIn, list, advanced);
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect() {
        return this.getItem().hasEffect(this);
    }

    @Deprecated
    public EnumRarity getRarity() {
        return this.getItem().getRarity(this);
    }

    public boolean isItemEnchantable() {
        if (!this.getItem().isEnchantable(this)) {
            return false;
        }
        return !this.isItemEnchanted();
    }

    public void addEnchantment(Enchantment ench, int level) {
        if (this.stackTagCompound == null) {
            this.setTagCompound(new NBTTagCompound());
        }
        if (!this.stackTagCompound.hasKey("ench", 9)) {
            this.stackTagCompound.setTag("ench", new NBTTagList());
        }
        NBTTagList nbttaglist = this.stackTagCompound.getTagList("ench", 10);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.setShort("id", (short)Enchantment.getEnchantmentID(ench));
        nbttagcompound.setShort("lvl", (byte)level);
        nbttaglist.appendTag(nbttagcompound);
    }

    public boolean isItemEnchanted() {
        if (this.stackTagCompound != null && this.stackTagCompound.hasKey("ench", 9)) {
            return !this.stackTagCompound.getTagList("ench", 10).isEmpty();
        }
        return false;
    }

    public void setTagInfo(String key, NBTBase value) {
        if (this.stackTagCompound == null) {
            this.setTagCompound(new NBTTagCompound());
        }
        this.stackTagCompound.setTag(key, value);
    }

    public boolean canEditBlocks() {
        return this.getItem().canItemEditBlocks();
    }

    public boolean isOnItemFrame() {
        return this.itemFrame != null;
    }

    public void setItemFrame(EntityItemFrame frame) {
        this.itemFrame = frame;
    }

    @Nullable
    public EntityItemFrame getItemFrame() {
        return this.isEmpty ? null : this.itemFrame;
    }

    public int getRepairCost() {
        return this.hasTagCompound() && this.stackTagCompound.hasKey("RepairCost", 3) ? this.stackTagCompound.getInteger("RepairCost") : 0;
    }

    public void setRepairCost(int cost) {
        if (!this.hasTagCompound()) {
            this.stackTagCompound = new NBTTagCompound();
        }
        this.stackTagCompound.setInteger("RepairCost", cost);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot) {
        HashMultimap multimap;
        if (this.hasTagCompound() && this.stackTagCompound.hasKey("AttributeModifiers", 9)) {
            multimap = HashMultimap.create();
            NBTTagList nbttaglist = this.stackTagCompound.getTagList("AttributeModifiers", 10);
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(i);
                AttributeModifier attributemodifier = SharedMonsterAttributes.readAttributeModifierFromNBT(nbttagcompound);
                if (attributemodifier == null || nbttagcompound.hasKey("Slot", 8) && !nbttagcompound.getString("Slot").equals(equipmentSlot.getName()) || attributemodifier.getID().getLeastSignificantBits() == 0L || attributemodifier.getID().getMostSignificantBits() == 0L) continue;
                multimap.put((Object)nbttagcompound.getString("AttributeName"), (Object)attributemodifier);
            }
        } else {
            multimap = this.getItem().getAttributeModifiers(equipmentSlot, this);
        }
        return multimap;
    }

    public void addAttributeModifier(String attributeName, AttributeModifier modifier, @Nullable EntityEquipmentSlot equipmentSlot) {
        if (this.stackTagCompound == null) {
            this.stackTagCompound = new NBTTagCompound();
        }
        if (!this.stackTagCompound.hasKey("AttributeModifiers", 9)) {
            this.stackTagCompound.setTag("AttributeModifiers", new NBTTagList());
        }
        NBTTagList nbttaglist = this.stackTagCompound.getTagList("AttributeModifiers", 10);
        NBTTagCompound nbttagcompound = SharedMonsterAttributes.writeAttributeModifierToNBT(modifier);
        nbttagcompound.setString("AttributeName", attributeName);
        if (equipmentSlot != null) {
            nbttagcompound.setString("Slot", equipmentSlot.getName());
        }
        nbttaglist.appendTag(nbttagcompound);
    }

    public ITextComponent getTextComponent() {
        TextComponentString textcomponentstring = new TextComponentString(this.getDisplayName());
        if (this.hasDisplayName()) {
            textcomponentstring.getStyle().setItalic(true);
        }
        ITextComponent itextcomponent = new TextComponentString("[").appendSibling(textcomponentstring).appendText("]");
        if (!this.isEmpty) {
            NBTTagCompound nbttagcompound = this.writeToNBT(new NBTTagCompound());
            itextcomponent.getStyle().setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, new TextComponentString(nbttagcompound.toString())));
            itextcomponent.getStyle().setColor(this.getItem().getForgeRarity(this).getColor());
        }
        return itextcomponent;
    }

    public boolean canDestroy(Block blockIn) {
        if (blockIn == this.canDestroyCacheBlock) {
            return this.canDestroyCacheResult;
        }
        this.canDestroyCacheBlock = blockIn;
        if (this.hasTagCompound() && this.stackTagCompound.hasKey("CanDestroy", 9)) {
            NBTTagList nbttaglist = this.stackTagCompound.getTagList("CanDestroy", 8);
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                Block block = Block.getBlockFromName(nbttaglist.getStringTagAt(i));
                if (block != blockIn) continue;
                this.canDestroyCacheResult = true;
                return true;
            }
        }
        this.canDestroyCacheResult = false;
        return false;
    }

    public boolean canPlaceOn(Block blockIn) {
        if (blockIn == this.canPlaceOnCacheBlock) {
            return this.canPlaceOnCacheResult;
        }
        this.canPlaceOnCacheBlock = blockIn;
        if (this.hasTagCompound() && this.stackTagCompound.hasKey("CanPlaceOn", 9)) {
            NBTTagList nbttaglist = this.stackTagCompound.getTagList("CanPlaceOn", 8);
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                Block block = Block.getBlockFromName(nbttaglist.getStringTagAt(i));
                if (block != blockIn) continue;
                this.canPlaceOnCacheResult = true;
                return true;
            }
        }
        this.canPlaceOnCacheResult = false;
        return false;
    }

    public int getAnimationsToGo() {
        return this.animationsToGo;
    }

    public void setAnimationsToGo(int animations) {
        this.animationsToGo = animations;
    }

    public int getCount() {
        return this.isEmpty ? 0 : this.stackSize;
    }

    public void setCount(int size) {
        this.stackSize = size;
        this.updateEmptyState();
    }

    public void grow(int quantity) {
        this.setCount(this.stackSize + quantity);
    }

    public void shrink(int quantity) {
        this.grow(-quantity);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.isEmpty || this.capabilities == null ? false : this.capabilities.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return this.isEmpty || this.capabilities == null ? null : (T)this.capabilities.getCapability(capability, facing);
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        ItemStack itemStack = new ItemStack(nbt);
        this.stackTagCompound = itemStack.stackTagCompound;
        this.capNBT = itemStack.capNBT;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        this.writeToNBT(ret);
        return ret;
    }

    public boolean areCapsCompatible(ItemStack other) {
        if (this.capabilities == null) {
            if (other.capabilities == null) {
                return true;
            }
            return other.capabilities.areCompatible(null);
        }
        return this.capabilities.areCompatible(other.capabilities);
    }

    private void forgeInit() {
        Item item = this.getItemRaw();
        if (item != null) {
            this.delegate = item.delegate;
            ICapabilityProvider provider = item.initCapabilities(this, this.capNBT);
            this.capabilities = ForgeEventFactory.gatherCapabilities(this, provider);
            if (this.capNBT != null && this.capabilities != null) {
                this.capabilities.deserializeNBT(this.capNBT);
            }
        }
    }

    @Nullable
    private Item getItemRaw() {
        return this.item;
    }

    public static boolean areItemStacksEqualUsingNBTShareTag(ItemStack stackA, ItemStack stackB) {
        if (stackA.isEmpty()) {
            return stackB.isEmpty();
        }
        return !stackB.isEmpty() && stackA.isItemStackEqualUsingNBTShareTag(stackB);
    }

    private boolean isItemStackEqualUsingNBTShareTag(ItemStack other) {
        return this.stackSize == other.stackSize && this.getItem() == other.getItem() && this.itemDamage == other.itemDamage && ItemStack.areItemStackShareTagsEqual(this, other);
    }

    public static boolean areItemStackShareTagsEqual(ItemStack stackA, ItemStack stackB) {
        NBTTagCompound shareTagA = stackA.getItem().getNBTShareTag(stackA);
        NBTTagCompound shareTagB = stackB.getItem().getNBTShareTag(stackB);
        if (shareTagA == null) {
            return shareTagB == null;
        }
        return shareTagB != null && shareTagA.equals(shareTagB);
    }

    public boolean doesSneakBypassUse(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return this.isEmpty() || this.getItem().doesSneakBypassUse(this, world, pos, player);
    }
}

