/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBookCloning;
import net.minecraft.item.crafting.RecipeFireworks;
import net.minecraft.item.crafting.RecipeRepairItem;
import net.minecraft.item.crafting.RecipeTippedArrow;
import net.minecraft.item.crafting.RecipesArmorDyes;
import net.minecraft.item.crafting.RecipesBanners;
import net.minecraft.item.crafting.RecipesMapCloning;
import net.minecraft.item.crafting.RecipesMapExtending;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.item.crafting.ShieldRecipes;
import net.minecraft.item.crafting.ShulkerBoxRecipes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.World;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static int nextAvailableId;
    public static final RegistryNamespaced<ResourceLocation, IRecipe> REGISTRY;

    public static boolean init() {
        try {
            CraftingManager.register("armordye", (IRecipe)new RecipesArmorDyes());
            CraftingManager.register("bookcloning", (IRecipe)new RecipeBookCloning());
            CraftingManager.register("mapcloning", (IRecipe)new RecipesMapCloning());
            CraftingManager.register("mapextending", (IRecipe)new RecipesMapExtending());
            CraftingManager.register("fireworks", (IRecipe)new RecipeFireworks());
            CraftingManager.register("repairitem", (IRecipe)new RecipeRepairItem());
            CraftingManager.register("tippedarrow", (IRecipe)new RecipeTippedArrow());
            CraftingManager.register("bannerduplicate", (IRecipe)new RecipesBanners.RecipeDuplicatePattern());
            CraftingManager.register("banneraddpattern", (IRecipe)new RecipesBanners.RecipeAddPattern());
            CraftingManager.register("shielddecoration", (IRecipe)new ShieldRecipes.Decoration());
            CraftingManager.register("shulkerboxcoloring", (IRecipe)new ShulkerBoxRecipes.ShulkerBoxColoring());
            return CraftingManager.parseJsonRecipes();
        }
        catch (Throwable var1) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean parseJsonRecipes() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 20[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IRecipe parseRecipeJson(JsonObject json) {
        String s = JsonUtils.getString(json, "type");
        if ("crafting_shaped".equals(s)) {
            return ShapedRecipes.deserialize(json);
        }
        if ("crafting_shapeless".equals(s)) {
            return ShapelessRecipes.deserialize(json);
        }
        throw new JsonSyntaxException("Invalid or unsupported recipe type '" + s + "'");
    }

    private static void register(String name, IRecipe recipe) {
        CraftingManager.register(new ResourceLocation(name), recipe);
    }

    private static void register(ResourceLocation name, IRecipe recipe) {
        if (REGISTRY.containsKey(name)) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + String.valueOf(name));
        }
        REGISTRY.register(nextAvailableId++, name, recipe);
    }

    public static ItemStack findMatchingResult(InventoryCrafting craftMatrix, World worldIn) {
        for (IRecipe irecipe : REGISTRY) {
            if (!irecipe.matches(craftMatrix, worldIn)) continue;
            return irecipe.getCraftingResult(craftMatrix);
        }
        return ItemStack.EMPTY;
    }

    @Nullable
    public static IRecipe findMatchingRecipe(InventoryCrafting craftMatrix, World worldIn) {
        for (IRecipe irecipe : REGISTRY) {
            if (!irecipe.matches(craftMatrix, worldIn)) continue;
            return irecipe;
        }
        return null;
    }

    public static NonNullList<ItemStack> getRemainingItems(InventoryCrafting craftMatrix, World worldIn) {
        for (IRecipe irecipe : REGISTRY) {
            if (!irecipe.matches(craftMatrix, worldIn)) continue;
            return irecipe.getRemainingItems(craftMatrix);
        }
        NonNullList<ItemStack> nonnulllist = NonNullList.withSize(craftMatrix.getSizeInventory(), ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, craftMatrix.getStackInSlot(i));
        }
        return nonnulllist;
    }

    @Nullable
    public static IRecipe getRecipe(ResourceLocation name) {
        return REGISTRY.getObject(name);
    }

    @Deprecated
    public static int getIDForRecipe(IRecipe recipe) {
        return REGISTRY.getIDForObject(recipe);
    }

    @Deprecated
    @Nullable
    public static IRecipe getRecipeById(int id) {
        return REGISTRY.getObjectById(id);
    }

    static {
        REGISTRY = GameData.getWrapper(IRecipe.class);
    }
}

