/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.DyeUtils;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipesBanners {

    public static class RecipeDuplicatePattern
    extends IForgeRegistryEntry.Impl<IRecipe>
    implements IRecipe {
        @Override
        public boolean matches(InventoryCrafting inv, World worldIn) {
            ItemStack itemstack = ItemStack.EMPTY;
            ItemStack itemstack1 = ItemStack.EMPTY;
            for (int i = 0; i < inv.getSizeInventory(); ++i) {
                boolean flag;
                ItemStack itemstack2 = inv.getStackInSlot(i);
                if (itemstack2.isEmpty()) continue;
                if (itemstack2.getItem() != Items.BANNER) {
                    return false;
                }
                if (!itemstack.isEmpty() && !itemstack1.isEmpty()) {
                    return false;
                }
                EnumDyeColor enumdyecolor = ItemBanner.getBaseColor(itemstack2);
                boolean bl = flag = TileEntityBanner.getPatterns(itemstack2) > 0;
                if (!itemstack.isEmpty()) {
                    if (flag) {
                        return false;
                    }
                    if (enumdyecolor != ItemBanner.getBaseColor(itemstack)) {
                        return false;
                    }
                    itemstack1 = itemstack2;
                    continue;
                }
                if (!itemstack1.isEmpty()) {
                    if (!flag) {
                        return false;
                    }
                    if (enumdyecolor != ItemBanner.getBaseColor(itemstack1)) {
                        return false;
                    }
                    itemstack = itemstack2;
                    continue;
                }
                if (flag) {
                    itemstack = itemstack2;
                    continue;
                }
                itemstack1 = itemstack2;
            }
            return !itemstack.isEmpty() && !itemstack1.isEmpty();
        }

        @Override
        public ItemStack getCraftingResult(InventoryCrafting inv) {
            for (int i = 0; i < inv.getSizeInventory(); ++i) {
                ItemStack itemstack = inv.getStackInSlot(i);
                if (itemstack.isEmpty() || TileEntityBanner.getPatterns(itemstack) <= 0) continue;
                ItemStack itemstack1 = itemstack.copy();
                itemstack1.setCount(1);
                return itemstack1;
            }
            return ItemStack.EMPTY;
        }

        @Override
        public ItemStack getRecipeOutput() {
            return ItemStack.EMPTY;
        }

        @Override
        public NonNullList<ItemStack> getRemainingItems(InventoryCrafting inv) {
            NonNullList<ItemStack> nonnulllist = NonNullList.withSize(inv.getSizeInventory(), ItemStack.EMPTY);
            for (int i = 0; i < nonnulllist.size(); ++i) {
                ItemStack itemstack = inv.getStackInSlot(i);
                if (itemstack.isEmpty()) continue;
                if (itemstack.getItem().hasContainerItem(itemstack)) {
                    nonnulllist.set(i, ForgeHooks.getContainerItem(itemstack));
                    continue;
                }
                if (!itemstack.hasTagCompound() || TileEntityBanner.getPatterns(itemstack) <= 0) continue;
                ItemStack itemstack1 = itemstack.copy();
                itemstack1.setCount(1);
                nonnulllist.set(i, itemstack1);
            }
            return nonnulllist;
        }

        @Override
        public boolean isDynamic() {
            return true;
        }

        @Override
        public boolean canFit(int width, int height) {
            return width * height >= 2;
        }
    }

    public static class RecipeAddPattern
    extends IForgeRegistryEntry.Impl<IRecipe>
    implements IRecipe {
        @Override
        public boolean matches(InventoryCrafting inv, World worldIn) {
            boolean flag = false;
            for (int i = 0; i < inv.getSizeInventory(); ++i) {
                ItemStack itemstack = inv.getStackInSlot(i);
                if (itemstack.getItem() != Items.BANNER) continue;
                if (flag) {
                    return false;
                }
                if (TileEntityBanner.getPatterns(itemstack) >= 6) {
                    return false;
                }
                flag = true;
            }
            if (!flag) {
                return false;
            }
            return this.matchPatterns(inv) != null;
        }

        @Override
        public ItemStack getCraftingResult(InventoryCrafting inv) {
            BannerPattern bannerpattern;
            ItemStack itemstack = ItemStack.EMPTY;
            for (int i = 0; i < inv.getSizeInventory(); ++i) {
                ItemStack itemstack1 = inv.getStackInSlot(i);
                if (itemstack1.isEmpty() || itemstack1.getItem() != Items.BANNER) continue;
                itemstack = itemstack1.copy();
                itemstack.setCount(1);
                break;
            }
            if ((bannerpattern = this.matchPatterns(inv)) != null) {
                NBTTagList nbttaglist;
                NBTTagCompound nbttagcompound1;
                int k = 0;
                for (int j = 0; j < inv.getSizeInventory(); ++j) {
                    ItemStack itemstack2 = inv.getStackInSlot(j);
                    int color = DyeUtils.rawDyeDamageFromStack(itemstack2);
                    if (color == -1) continue;
                    k = color;
                    break;
                }
                if ((nbttagcompound1 = itemstack.getOrCreateSubCompound("BlockEntityTag")).hasKey("Patterns", 9)) {
                    nbttaglist = nbttagcompound1.getTagList("Patterns", 10);
                } else {
                    nbttaglist = new NBTTagList();
                    nbttagcompound1.setTag("Patterns", nbttaglist);
                }
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.setString("Pattern", bannerpattern.getHashname());
                nbttagcompound.setInteger("Color", k);
                nbttaglist.appendTag(nbttagcompound);
            }
            return itemstack;
        }

        @Override
        public ItemStack getRecipeOutput() {
            return ItemStack.EMPTY;
        }

        @Override
        public NonNullList<ItemStack> getRemainingItems(InventoryCrafting inv) {
            NonNullList<ItemStack> nonnulllist = NonNullList.withSize(inv.getSizeInventory(), ItemStack.EMPTY);
            for (int i = 0; i < nonnulllist.size(); ++i) {
                ItemStack itemstack = inv.getStackInSlot(i);
                nonnulllist.set(i, ForgeHooks.getContainerItem(itemstack));
            }
            return nonnulllist;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        private BannerPattern matchPatterns(InventoryCrafting p_190933_1_) {
            BannerPattern[] bannerPatternArray = BannerPattern.values();
            int n = bannerPatternArray.length;
            int n2 = 0;
            while (true) {
                block12: {
                    boolean flag;
                    BannerPattern bannerpattern;
                    block17: {
                        int j;
                        block16: {
                            boolean flag2;
                            boolean flag1;
                            block14: {
                                block15: {
                                    block13: {
                                        if (n2 >= n) {
                                            return null;
                                        }
                                        bannerpattern = bannerPatternArray[n2];
                                        if (!bannerpattern.hasPattern()) break block12;
                                        flag = true;
                                        if (!bannerpattern.hasPatternItem()) break block13;
                                        flag1 = false;
                                        flag2 = false;
                                        break block14;
                                    }
                                    if (p_190933_1_.getSizeInventory() != bannerpattern.getPatterns().length * bannerpattern.getPatterns()[0].length()) break block15;
                                    j = -1;
                                    break block16;
                                }
                                flag = false;
                                break block17;
                            }
                            for (int i = 0; i < p_190933_1_.getSizeInventory() && flag; ++i) {
                                ItemStack itemstack = p_190933_1_.getStackInSlot(i);
                                if (itemstack.isEmpty() || itemstack.getItem() == Items.BANNER) continue;
                                if (DyeUtils.isDye(itemstack)) {
                                    if (flag2) {
                                        flag = false;
                                        break;
                                    }
                                    flag2 = true;
                                    continue;
                                }
                                if (flag1 || !itemstack.isItemEqual(bannerpattern.getPatternItem())) {
                                    flag = false;
                                    break;
                                }
                                flag1 = true;
                            }
                            if (flag1 && flag2) break block17;
                            flag = false;
                            break block17;
                        }
                        for (int k = 0; k < p_190933_1_.getSizeInventory() && flag; ++k) {
                            int l = k / 3;
                            int i1 = k % 3;
                            ItemStack itemstack1 = p_190933_1_.getStackInSlot(k);
                            if (!itemstack1.isEmpty() && itemstack1.getItem() != Items.BANNER) {
                                if (!DyeUtils.isDye(itemstack1)) {
                                    flag = false;
                                    break;
                                }
                                if (j != -1 && j != itemstack1.getMetadata()) {
                                    flag = false;
                                    break;
                                }
                                if (bannerpattern.getPatterns()[l].charAt(i1) == ' ') {
                                    flag = false;
                                    break;
                                }
                                j = itemstack1.getMetadata();
                                continue;
                            }
                            if (bannerpattern.getPatterns()[l].charAt(i1) == ' ') continue;
                            flag = false;
                            break;
                        }
                    }
                    if (flag) {
                        return bannerpattern;
                    }
                }
                ++n2;
            }
        }

        @Override
        public boolean isDynamic() {
            return true;
        }

        @Override
        public boolean canFit(int width, int height) {
            return width >= 3 && height >= 3;
        }
    }
}

