/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ShapelessRecipes
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final ItemStack recipeOutput;
    public final NonNullList<Ingredient> recipeItems;
    private final String group;
    private final boolean isSimple;

    public ShapelessRecipes(String group, ItemStack output, NonNullList<Ingredient> ingredients) {
        this.group = group;
        this.recipeOutput = output;
        this.recipeItems = ingredients;
        boolean simple = true;
        for (Ingredient i : ingredients) {
            simple &= i.isSimple();
        }
        this.isSimple = simple;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting inv) {
        NonNullList<ItemStack> nonnulllist = NonNullList.withSize(inv.getSizeInventory(), ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.getStackInSlot(i);
            nonnulllist.set(i, ForgeHooks.getContainerItem(itemstack));
        }
        return nonnulllist;
    }

    @Override
    public boolean matches(InventoryCrafting inv, World worldIn) {
        int ingredientCount = 0;
        RecipeItemHelper recipeItemHelper = new RecipeItemHelper();
        ArrayList inputs = Lists.newArrayList();
        for (int i = 0; i < inv.getHeight(); ++i) {
            for (int j = 0; j < inv.getWidth(); ++j) {
                ItemStack itemstack = inv.getStackInRowAndColumn(j, i);
                if (itemstack.isEmpty()) continue;
                ++ingredientCount;
                if (this.isSimple) {
                    recipeItemHelper.accountStack(itemstack, 1);
                    continue;
                }
                inputs.add(itemstack);
            }
        }
        if (ingredientCount != this.recipeItems.size()) {
            return false;
        }
        if (this.isSimple) {
            return recipeItemHelper.canCraft(this, null);
        }
        return RecipeMatcher.findMatches(inputs, this.recipeItems) != null;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inv) {
        return this.recipeOutput.copy();
    }

    public static ShapelessRecipes deserialize(JsonObject json) {
        String s = JsonUtils.getString(json, "group", "");
        NonNullList<Ingredient> nonnulllist = ShapelessRecipes.deserializeIngredients(JsonUtils.getJsonArray(json, "ingredients"));
        if (nonnulllist.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (nonnulllist.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe");
        }
        ItemStack itemstack = ShapedRecipes.deserializeItem(JsonUtils.getJsonObject(json, "result"), true);
        return new ShapelessRecipes(s, itemstack, nonnulllist);
    }

    private static NonNullList<Ingredient> deserializeIngredients(JsonArray array) {
        NonNullList<Ingredient> nonnulllist = NonNullList.create();
        for (int i = 0; i < array.size(); ++i) {
            Ingredient ingredient = ShapedRecipes.deserializeIngredient(array.get(i));
            if (ingredient == Ingredient.EMPTY) continue;
            nonnulllist.add(ingredient);
        }
        return nonnulllist;
    }

    @Override
    public boolean canFit(int width, int height) {
        return width * height >= this.recipeItems.size();
    }
}

