/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.DyeUtils;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ShulkerBoxRecipes {

    public static class ShulkerBoxColoring
    extends IForgeRegistryEntry.Impl<IRecipe>
    implements IRecipe {
        @Override
        public boolean matches(InventoryCrafting inv, World worldIn) {
            int i = 0;
            int j = 0;
            for (int k = 0; k < inv.getSizeInventory(); ++k) {
                ItemStack itemstack = inv.getStackInSlot(k);
                if (itemstack.isEmpty()) continue;
                if (Block.getBlockFromItem(itemstack.getItem()) instanceof BlockShulkerBox) {
                    ++i;
                } else {
                    if (!DyeUtils.isDye(itemstack)) {
                        return false;
                    }
                    ++j;
                }
                if (j <= 1 && i <= 1) continue;
                return false;
            }
            return i == 1 && j == 1;
        }

        @Override
        public ItemStack getCraftingResult(InventoryCrafting inv) {
            ItemStack itemstack = ItemStack.EMPTY;
            ItemStack itemstack1 = ItemStack.EMPTY;
            for (int i = 0; i < inv.getSizeInventory(); ++i) {
                ItemStack itemstack2 = inv.getStackInSlot(i);
                if (itemstack2.isEmpty()) continue;
                if (Block.getBlockFromItem(itemstack2.getItem()) instanceof BlockShulkerBox) {
                    itemstack = itemstack2;
                    continue;
                }
                if (!DyeUtils.isDye(itemstack2)) continue;
                itemstack1 = itemstack2;
            }
            ItemStack itemstack3 = BlockShulkerBox.getColoredItemStack(DyeUtils.colorFromStack(itemstack1).get());
            if (itemstack.hasTagCompound()) {
                itemstack3.setTagCompound(itemstack.getTagCompound().copy());
            }
            return itemstack3;
        }

        @Override
        public ItemStack getRecipeOutput() {
            return ItemStack.EMPTY;
        }

        @Override
        public NonNullList<ItemStack> getRemainingItems(InventoryCrafting inv) {
            NonNullList<ItemStack> nonnulllist = NonNullList.withSize(inv.getSizeInventory(), ItemStack.EMPTY);
            for (int i = 0; i < nonnulllist.size(); ++i) {
                ItemStack itemstack = inv.getStackInSlot(i);
                if (!itemstack.getItem().hasContainerItem()) continue;
                nonnulllist.set(i, new ItemStack(itemstack.getItem().getContainerItem()));
            }
            return nonnulllist;
        }

        @Override
        public boolean isDynamic() {
            return true;
        }

        @Override
        public boolean canFit(int width, int height) {
            return width * height >= 2;
        }
    }
}

