/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

public class NBTSizeTracker {
    public static final NBTSizeTracker INFINITE = new NBTSizeTracker(0L){

        @Override
        public void read(long bits) {
        }
    };
    private final long max;
    private long read;

    public NBTSizeTracker(long max) {
        this.max = max;
    }

    public void read(long bits) {
        this.read += bits / 8L;
        if (this.read > this.max) {
            throw new RuntimeException("Tried to read NBT tag that was too big; tried to allocate: " + this.read + "bytes where max allowed: " + this.max);
        }
    }

    public static void readUTF(NBTSizeTracker tracker, String data) {
        tracker.read(16L);
        if (data == null) {
            return;
        }
        int len = data.length();
        int utflen = 0;
        for (int i = 0; i < len; ++i) {
            char c = data.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        tracker.read(8 * utflen);
    }
}

