/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.login.server;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.login.INetHandlerLoginClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketLoginSuccess
implements Packet<INetHandlerLoginClient> {
    private GameProfile profile;

    public SPacketLoginSuccess() {
    }

    public SPacketLoginSuccess(GameProfile profileIn) {
        this.profile = profileIn;
    }

    @Override
    public void readPacketData(PacketBuffer buf) throws IOException {
        String s = buf.readString(36);
        String s1 = buf.readString(16);
        UUID uuid = s.length() > 0 ? UUID.fromString(s) : null;
        this.profile = new GameProfile(uuid, s1);
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        UUID uuid = this.profile.getId();
        buf.writeString(uuid == null ? "" : uuid.toString());
        buf.writeString(this.profile.getName());
    }

    @Override
    public void processPacket(INetHandlerLoginClient handler) {
        handler.handleLoginSuccess(this);
    }

    @SideOnly(value=Side.CLIENT)
    public GameProfile getProfile() {
        return this.profile;
    }
}

