/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketChunkData
implements Packet<INetHandlerPlayClient> {
    private int chunkX;
    private int chunkZ;
    private int availableSections;
    private byte[] buffer;
    private List<NBTTagCompound> tileEntityTags;
    private boolean fullChunk;

    public SPacketChunkData() {
    }

    public SPacketChunkData(Chunk chunkIn, int changedSectionFilter) {
        this.chunkX = chunkIn.x;
        this.chunkZ = chunkIn.z;
        this.fullChunk = changedSectionFilter == 65535;
        boolean flag = chunkIn.getWorld().provider.hasSkyLight();
        this.buffer = new byte[this.calculateChunkSize(chunkIn, flag, changedSectionFilter)];
        this.availableSections = this.extractChunkData(new PacketBuffer(this.getWriteBuffer()), chunkIn, flag, changedSectionFilter);
        this.tileEntityTags = Lists.newArrayList();
        for (Map.Entry<BlockPos, TileEntity> entry : chunkIn.getTileEntityMap().entrySet()) {
            BlockPos blockpos = entry.getKey();
            TileEntity tileentity = entry.getValue();
            int i = blockpos.getY() >> 4;
            if (!this.isFullChunk() && (changedSectionFilter & 1 << i) == 0) continue;
            NBTTagCompound nbttagcompound = tileentity.getUpdateTag();
            this.tileEntityTags.add(nbttagcompound);
        }
    }

    @Override
    public void readPacketData(PacketBuffer buf) throws IOException {
        this.chunkX = buf.readInt();
        this.chunkZ = buf.readInt();
        this.fullChunk = buf.readBoolean();
        this.availableSections = buf.readVarInt();
        int i = buf.readVarInt();
        if (i > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.buffer = new byte[i];
        buf.readBytes(this.buffer);
        int j = buf.readVarInt();
        this.tileEntityTags = Lists.newArrayList();
        for (int k = 0; k < j; ++k) {
            this.tileEntityTags.add(buf.readCompoundTag());
        }
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        buf.writeInt(this.chunkX);
        buf.writeInt(this.chunkZ);
        buf.writeBoolean(this.fullChunk);
        buf.writeVarInt(this.availableSections);
        buf.writeVarInt(this.buffer.length);
        buf.writeBytes(this.buffer);
        buf.writeVarInt(this.tileEntityTags.size());
        for (NBTTagCompound nbttagcompound : this.tileEntityTags) {
            buf.writeCompoundTag(nbttagcompound);
        }
    }

    @Override
    public void processPacket(INetHandlerPlayClient handler) {
        handler.handleChunkData(this);
    }

    @SideOnly(value=Side.CLIENT)
    public PacketBuffer getReadBuffer() {
        return new PacketBuffer(Unpooled.wrappedBuffer((byte[])this.buffer));
    }

    private ByteBuf getWriteBuffer() {
        ByteBuf bytebuf = Unpooled.wrappedBuffer((byte[])this.buffer);
        bytebuf.writerIndex(0);
        return bytebuf;
    }

    public int extractChunkData(PacketBuffer buf, Chunk chunkIn, boolean writeSkylight, int changedSectionFilter) {
        int i = 0;
        ExtendedBlockStorage[] aextendedblockstorage = chunkIn.getBlockStorageArray();
        int k = aextendedblockstorage.length;
        for (int j = 0; j < k; ++j) {
            ExtendedBlockStorage extendedblockstorage = aextendedblockstorage[j];
            if (extendedblockstorage == Chunk.NULL_BLOCK_STORAGE || this.isFullChunk() && extendedblockstorage.isEmpty() || (changedSectionFilter & 1 << j) == 0) continue;
            i |= 1 << j;
            extendedblockstorage.getData().write(buf);
            buf.writeBytes(extendedblockstorage.getBlockLight().getData());
            if (!writeSkylight) continue;
            buf.writeBytes(extendedblockstorage.getSkyLight().getData());
        }
        if (this.isFullChunk()) {
            buf.writeBytes(chunkIn.getBiomeArray());
        }
        return i;
    }

    protected int calculateChunkSize(Chunk chunkIn, boolean p_189556_2_, int p_189556_3_) {
        int i = 0;
        ExtendedBlockStorage[] aextendedblockstorage = chunkIn.getBlockStorageArray();
        int k = aextendedblockstorage.length;
        for (int j = 0; j < k; ++j) {
            ExtendedBlockStorage extendedblockstorage = aextendedblockstorage[j];
            if (extendedblockstorage == Chunk.NULL_BLOCK_STORAGE || this.isFullChunk() && extendedblockstorage.isEmpty() || (p_189556_3_ & 1 << j) == 0) continue;
            i += extendedblockstorage.getData().getSerializedSize();
            i += extendedblockstorage.getBlockLight().getData().length;
            if (!p_189556_2_) continue;
            i += extendedblockstorage.getSkyLight().getData().length;
        }
        if (this.isFullChunk()) {
            i += chunkIn.getBiomeArray().length;
        }
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public int getChunkX() {
        return this.chunkX;
    }

    @SideOnly(value=Side.CLIENT)
    public int getChunkZ() {
        return this.chunkZ;
    }

    @SideOnly(value=Side.CLIENT)
    public int getExtractedSize() {
        return this.availableSections;
    }

    public boolean isFullChunk() {
        return this.fullChunk;
    }

    @SideOnly(value=Side.CLIENT)
    public List<NBTTagCompound> getTileEntityTags() {
        return this.tileEntityTags;
    }
}

