/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketEntityTeleport
implements Packet<INetHandlerPlayClient> {
    private int entityId;
    private double posX;
    private double posY;
    private double posZ;
    private byte yaw;
    private byte pitch;
    private boolean onGround;

    public SPacketEntityTeleport() {
    }

    public SPacketEntityTeleport(Entity entityIn) {
        this.entityId = entityIn.getEntityId();
        this.posX = entityIn.posX;
        this.posY = entityIn.posY;
        this.posZ = entityIn.posZ;
        this.yaw = (byte)(entityIn.rotationYaw * 256.0f / 360.0f);
        this.pitch = (byte)(entityIn.rotationPitch * 256.0f / 360.0f);
        this.onGround = entityIn.onGround;
    }

    @Override
    public void readPacketData(PacketBuffer buf) throws IOException {
        this.entityId = buf.readVarInt();
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.yaw = buf.readByte();
        this.pitch = buf.readByte();
        this.onGround = buf.readBoolean();
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        buf.writeVarInt(this.entityId);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeByte(this.yaw);
        buf.writeByte(this.pitch);
        buf.writeBoolean(this.onGround);
    }

    @Override
    public void processPacket(INetHandlerPlayClient handler) {
        handler.handleEntityTeleport(this);
    }

    @SideOnly(value=Side.CLIENT)
    public int getEntityId() {
        return this.entityId;
    }

    @SideOnly(value=Side.CLIENT)
    public double getX() {
        return this.posX;
    }

    @SideOnly(value=Side.CLIENT)
    public double getY() {
        return this.posY;
    }

    @SideOnly(value=Side.CLIENT)
    public double getZ() {
        return this.posZ;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getYaw() {
        return this.yaw;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getPitch() {
        return this.pitch;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getOnGround() {
        return this.onGround;
    }
}

