/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketEntityVelocity
implements Packet<INetHandlerPlayClient> {
    private int entityID;
    private int motionX;
    private int motionY;
    private int motionZ;

    public SPacketEntityVelocity() {
    }

    public SPacketEntityVelocity(Entity entityIn) {
        this(entityIn.getEntityId(), entityIn.motionX, entityIn.motionY, entityIn.motionZ);
    }

    public SPacketEntityVelocity(int entityIdIn, double motionXIn, double motionYIn, double motionZIn) {
        this.entityID = entityIdIn;
        double d0 = 3.9;
        if (motionXIn < -3.9) {
            motionXIn = -3.9;
        }
        if (motionYIn < -3.9) {
            motionYIn = -3.9;
        }
        if (motionZIn < -3.9) {
            motionZIn = -3.9;
        }
        if (motionXIn > 3.9) {
            motionXIn = 3.9;
        }
        if (motionYIn > 3.9) {
            motionYIn = 3.9;
        }
        if (motionZIn > 3.9) {
            motionZIn = 3.9;
        }
        this.motionX = (int)(motionXIn * 8000.0);
        this.motionY = (int)(motionYIn * 8000.0);
        this.motionZ = (int)(motionZIn * 8000.0);
    }

    @Override
    public void readPacketData(PacketBuffer buf) throws IOException {
        this.entityID = buf.readVarInt();
        this.motionX = buf.readShort();
        this.motionY = buf.readShort();
        this.motionZ = buf.readShort();
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        buf.writeVarInt(this.entityID);
        buf.writeShort(this.motionX);
        buf.writeShort(this.motionY);
        buf.writeShort(this.motionZ);
    }

    @Override
    public void processPacket(INetHandlerPlayClient handler) {
        handler.handleEntityVelocity(this);
    }

    @SideOnly(value=Side.CLIENT)
    public int getEntityID() {
        return this.entityID;
    }

    @SideOnly(value=Side.CLIENT)
    public int getMotionX() {
        return this.motionX;
    }

    @SideOnly(value=Side.CLIENT)
    public int getMotionY() {
        return this.motionY;
    }

    @SideOnly(value=Side.CLIENT)
    public int getMotionZ() {
        return this.motionZ;
    }
}

