/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketRecipeBook
implements Packet<INetHandlerPlayClient> {
    private State state;
    private List<IRecipe> recipes;
    private List<IRecipe> displayedRecipes;
    private boolean guiOpen;
    private boolean filteringCraftable;

    public SPacketRecipeBook() {
    }

    public SPacketRecipeBook(State stateIn, List<IRecipe> recipesIn, List<IRecipe> displayedRecipesIn, boolean isGuiOpen, boolean p_i47597_5_) {
        this.state = stateIn;
        this.recipes = recipesIn;
        this.displayedRecipes = displayedRecipesIn;
        this.guiOpen = isGuiOpen;
        this.filteringCraftable = p_i47597_5_;
    }

    @Override
    public void processPacket(INetHandlerPlayClient handler) {
        handler.handleRecipeBook(this);
    }

    @Override
    public void readPacketData(PacketBuffer buf) throws IOException {
        this.state = buf.readEnumValue(State.class);
        this.guiOpen = buf.readBoolean();
        this.filteringCraftable = buf.readBoolean();
        int i = buf.readVarInt();
        this.recipes = Lists.newArrayList();
        for (int j = 0; j < i; ++j) {
            this.recipes.add(CraftingManager.getRecipeById(buf.readVarInt()));
        }
        if (this.state == State.INIT) {
            i = buf.readVarInt();
            this.displayedRecipes = Lists.newArrayList();
            for (int k = 0; k < i; ++k) {
                this.displayedRecipes.add(CraftingManager.getRecipeById(buf.readVarInt()));
            }
        }
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        buf.writeEnumValue(this.state);
        buf.writeBoolean(this.guiOpen);
        buf.writeBoolean(this.filteringCraftable);
        buf.writeVarInt(this.recipes.size());
        for (IRecipe irecipe : this.recipes) {
            buf.writeVarInt(CraftingManager.getIDForRecipe(irecipe));
        }
        if (this.state == State.INIT) {
            buf.writeVarInt(this.displayedRecipes.size());
            for (IRecipe irecipe1 : this.displayedRecipes) {
                buf.writeVarInt(CraftingManager.getIDForRecipe(irecipe1));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<IRecipe> getRecipes() {
        return this.recipes;
    }

    @SideOnly(value=Side.CLIENT)
    public List<IRecipe> getDisplayedRecipes() {
        return this.displayedRecipes;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isGuiOpen() {
        return this.guiOpen;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isFilteringCraftable() {
        return this.filteringCraftable;
    }

    @SideOnly(value=Side.CLIENT)
    public State getState() {
        return this.state;
    }

    public static enum State {
        INIT,
        ADD,
        REMOVE;

    }
}

