/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.rcon;

import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RConConsoleSource
implements ICommandSender {
    private final StringBuffer buffer = new StringBuffer();
    private final MinecraftServer server;

    public RConConsoleSource(MinecraftServer serverIn) {
        this.server = serverIn;
    }

    @SideOnly(value=Side.SERVER)
    public void resetLog() {
        this.buffer.setLength(0);
    }

    @SideOnly(value=Side.SERVER)
    public String getLogContents() {
        return this.buffer.toString();
    }

    @Override
    public String getName() {
        return "Rcon";
    }

    @Override
    public void sendMessage(ITextComponent component) {
        this.buffer.append(component.getUnformattedText());
    }

    @Override
    public boolean canUseCommand(int permLevel, String commandName) {
        return true;
    }

    @Override
    public World getEntityWorld() {
        return this.server.getEntityWorld();
    }

    @Override
    public boolean sendCommandFeedback() {
        return true;
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }
}

