/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PotionEffect
implements Comparable<PotionEffect> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Potion potion;
    private int duration;
    private int amplifier;
    private boolean isSplashPotion;
    private boolean isAmbient;
    @SideOnly(value=Side.CLIENT)
    private boolean isPotionDurationMax;
    private boolean showParticles;
    private List<ItemStack> curativeItems;

    public PotionEffect(Potion potionIn) {
        this(potionIn, 0, 0);
    }

    public PotionEffect(Potion potionIn, int durationIn) {
        this(potionIn, durationIn, 0);
    }

    public PotionEffect(Potion potionIn, int durationIn, int amplifierIn) {
        this(potionIn, durationIn, amplifierIn, false, true);
    }

    public PotionEffect(Potion potionIn, int durationIn, int amplifierIn, boolean ambientIn, boolean showParticlesIn) {
        this.potion = potionIn;
        this.duration = durationIn;
        this.amplifier = amplifierIn;
        this.isAmbient = ambientIn;
        this.showParticles = showParticlesIn;
    }

    public PotionEffect(PotionEffect other) {
        this.potion = other.potion;
        this.duration = other.duration;
        this.amplifier = other.amplifier;
        this.isAmbient = other.isAmbient;
        this.showParticles = other.showParticles;
        this.curativeItems = other.curativeItems == null ? null : new ArrayList<ItemStack>(other.curativeItems);
    }

    public void combine(PotionEffect other) {
        if (this.potion != other.potion) {
            LOGGER.warn("This method should only be called for matching effects!");
        }
        if (other.amplifier > this.amplifier) {
            this.amplifier = other.amplifier;
            this.duration = other.duration;
        } else if (other.amplifier == this.amplifier && this.duration < other.duration) {
            this.duration = other.duration;
        } else if (!other.isAmbient && this.isAmbient) {
            this.isAmbient = other.isAmbient;
        }
        this.showParticles = other.showParticles;
    }

    public Potion getPotion() {
        return this.getPotionRaw() == null ? null : (Potion)this.getPotionRaw().delegate.get();
    }

    private Potion getPotionRaw() {
        return this.potion;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public boolean getIsAmbient() {
        return this.isAmbient;
    }

    public boolean doesShowParticles() {
        return this.showParticles;
    }

    public boolean onUpdate(EntityLivingBase entityIn) {
        if (this.duration > 0) {
            if (this.potion.isReady(this.duration, this.amplifier)) {
                this.performEffect(entityIn);
            }
            this.deincrementDuration();
        }
        return this.duration > 0;
    }

    private int deincrementDuration() {
        return --this.duration;
    }

    public void performEffect(EntityLivingBase entityIn) {
        if (this.duration > 0) {
            this.potion.performEffect(entityIn, this.amplifier);
        }
    }

    public String getEffectName() {
        return this.potion.getName();
    }

    public String toString() {
        String s = this.amplifier > 0 ? this.getEffectName() + " x " + (this.amplifier + 1) + ", Duration: " + this.duration : this.getEffectName() + ", Duration: " + this.duration;
        if (this.isSplashPotion) {
            s = s + ", Splash: true";
        }
        if (!this.showParticles) {
            s = s + ", Particles: false";
        }
        return s;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof PotionEffect)) {
            return false;
        }
        PotionEffect potioneffect = (PotionEffect)p_equals_1_;
        return this.duration == potioneffect.duration && this.amplifier == potioneffect.amplifier && this.isSplashPotion == potioneffect.isSplashPotion && this.isAmbient == potioneffect.isAmbient && this.potion.equals(potioneffect.potion);
    }

    public int hashCode() {
        int i = this.potion.hashCode();
        i = 31 * i + this.duration;
        i = 31 * i + this.amplifier;
        i = 31 * i + (this.isSplashPotion ? 1 : 0);
        i = 31 * i + (this.isAmbient ? 1 : 0);
        return i;
    }

    public NBTTagCompound writeCustomPotionEffectToNBT(NBTTagCompound nbt) {
        nbt.setByte("Id", (byte)Potion.getIdFromPotion(this.getPotion()));
        nbt.setByte("Amplifier", (byte)this.getAmplifier());
        nbt.setInteger("Duration", this.getDuration());
        nbt.setBoolean("Ambient", this.getIsAmbient());
        nbt.setBoolean("ShowParticles", this.doesShowParticles());
        this.writeCurativeItems(nbt);
        return nbt;
    }

    public static PotionEffect readCustomPotionEffectFromNBT(NBTTagCompound nbt) {
        int i = nbt.getByte("Id") & 0xFF;
        Potion potion = Potion.getPotionById(i);
        if (potion == null) {
            return null;
        }
        byte j = nbt.getByte("Amplifier");
        int k = nbt.getInteger("Duration");
        boolean flag = nbt.getBoolean("Ambient");
        boolean flag1 = true;
        if (nbt.hasKey("ShowParticles", 1)) {
            flag1 = nbt.getBoolean("ShowParticles");
        }
        return PotionEffect.readCurativeItems(new PotionEffect(potion, k, j < 0 ? (byte)0 : j, flag, flag1), nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public void setPotionDurationMax(boolean maxDuration) {
        this.isPotionDurationMax = maxDuration;
    }

    @Override
    public int compareTo(PotionEffect p_compareTo_1_) {
        int i = 32147;
        return !(this.getDuration() > 32147 && p_compareTo_1_.getDuration() > 32147 || this.getIsAmbient() && p_compareTo_1_.getIsAmbient()) ? ComparisonChain.start().compare(Boolean.valueOf(this.getIsAmbient()), Boolean.valueOf(p_compareTo_1_.getIsAmbient())).compare(this.getDuration(), p_compareTo_1_.getDuration()).compare(this.getPotion().getGuiSortColor(this), p_compareTo_1_.getPotion().getGuiSortColor(p_compareTo_1_)).result() : ComparisonChain.start().compare(Boolean.valueOf(this.getIsAmbient()), Boolean.valueOf(p_compareTo_1_.getIsAmbient())).compare(this.getPotion().getGuiSortColor(this), p_compareTo_1_.getPotion().getGuiSortColor(p_compareTo_1_)).result();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getIsPotionDurationMax() {
        return this.isPotionDurationMax;
    }

    public List<ItemStack> getCurativeItems() {
        if (this.curativeItems == null) {
            this.curativeItems = this.getPotion().getCurativeItems();
        }
        return this.curativeItems;
    }

    public boolean isCurativeItem(ItemStack stack) {
        for (ItemStack curativeItem : this.getCurativeItems()) {
            if (!curativeItem.isItemEqual(stack)) continue;
            return true;
        }
        return false;
    }

    public void setCurativeItems(List<ItemStack> curativeItems) {
        this.curativeItems = curativeItems;
    }

    public void addCurativeItem(ItemStack stack) {
        if (!this.isCurativeItem(stack)) {
            this.getCurativeItems().add(stack);
        }
    }

    private void writeCurativeItems(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : this.getCurativeItems()) {
            list.appendTag(stack.writeToNBT(new NBTTagCompound()));
        }
        nbt.setTag("CurativeItems", list);
    }

    private static PotionEffect readCurativeItems(PotionEffect effect, NBTTagCompound nbt) {
        if (nbt.hasKey("CurativeItems", 9)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            NBTTagList list = nbt.getTagList("CurativeItems", 10);
            for (int i = 0; i < list.tagCount(); ++i) {
                items.add(new ItemStack(list.getCompoundTagAt(i)));
            }
            effect.setCurativeItems(items);
        }
        return effect;
    }
}

