/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;

public class PotionHelper {
    private static final List<MixPredicate<PotionType>> POTION_TYPE_CONVERSIONS = Lists.newArrayList();
    private static final List<MixPredicate<Item>> POTION_ITEM_CONVERSIONS = Lists.newArrayList();
    private static final List<Ingredient> POTION_ITEMS = Lists.newArrayList();
    private static final Predicate<ItemStack> IS_POTION_ITEM = new Predicate<ItemStack>(){

        public boolean apply(ItemStack p_apply_1_) {
            for (Ingredient ingredient : POTION_ITEMS) {
                if (!ingredient.apply(p_apply_1_)) continue;
                return true;
            }
            return false;
        }
    };

    public static boolean isReagent(ItemStack stack) {
        return PotionHelper.isItemConversionReagent(stack) || PotionHelper.isTypeConversionReagent(stack);
    }

    protected static boolean isItemConversionReagent(ItemStack stack) {
        int j = POTION_ITEM_CONVERSIONS.size();
        for (int i = 0; i < j; ++i) {
            if (!PotionHelper.POTION_ITEM_CONVERSIONS.get((int)i).reagent.apply(stack)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isTypeConversionReagent(ItemStack stack) {
        int j = POTION_TYPE_CONVERSIONS.size();
        for (int i = 0; i < j; ++i) {
            if (!PotionHelper.POTION_TYPE_CONVERSIONS.get((int)i).reagent.apply(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConversions(ItemStack input, ItemStack reagent) {
        if (!IS_POTION_ITEM.apply((Object)input)) {
            return false;
        }
        return PotionHelper.hasItemConversions(input, reagent) || PotionHelper.hasTypeConversions(input, reagent);
    }

    protected static boolean hasItemConversions(ItemStack input, ItemStack reagent) {
        Item item = input.getItem();
        int j = POTION_ITEM_CONVERSIONS.size();
        for (int i = 0; i < j; ++i) {
            MixPredicate<Item> mixpredicate = POTION_ITEM_CONVERSIONS.get(i);
            if (mixpredicate.input.get() != item || !mixpredicate.reagent.apply(reagent)) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasTypeConversions(ItemStack input, ItemStack reagent) {
        PotionType potiontype = PotionUtils.getPotionFromItem(input);
        int j = POTION_TYPE_CONVERSIONS.size();
        for (int i = 0; i < j; ++i) {
            MixPredicate<PotionType> mixpredicate = POTION_TYPE_CONVERSIONS.get(i);
            if (mixpredicate.input.get() != potiontype || !mixpredicate.reagent.apply(reagent)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack doReaction(ItemStack reagent, ItemStack potionIn) {
        if (!potionIn.isEmpty()) {
            int i;
            PotionType potiontype = PotionUtils.getPotionFromItem(potionIn);
            Item item = potionIn.getItem();
            int j = POTION_ITEM_CONVERSIONS.size();
            for (i = 0; i < j; ++i) {
                MixPredicate<Item> mixpredicate = POTION_ITEM_CONVERSIONS.get(i);
                if (mixpredicate.input.get() != item || !mixpredicate.reagent.apply(reagent)) continue;
                return PotionUtils.addPotionToItemStack(new ItemStack((Item)mixpredicate.output.get()), potiontype);
            }
            int k = POTION_TYPE_CONVERSIONS.size();
            for (i = 0; i < k; ++i) {
                MixPredicate<PotionType> mixpredicate1 = POTION_TYPE_CONVERSIONS.get(i);
                if (mixpredicate1.input.get() != potiontype || !mixpredicate1.reagent.apply(reagent)) continue;
                return PotionUtils.addPotionToItemStack(new ItemStack(item), (PotionType)mixpredicate1.output.get());
            }
        }
        return potionIn;
    }

    public static void init() {
        PotionHelper.addContainer(Items.POTIONITEM);
        PotionHelper.addContainer(Items.SPLASH_POTION);
        PotionHelper.addContainer(Items.LINGERING_POTION);
        PotionHelper.addContainerRecipe(Items.POTIONITEM, Items.GUNPOWDER, Items.SPLASH_POTION);
        PotionHelper.addContainerRecipe(Items.SPLASH_POTION, Items.DRAGON_BREATH, Items.LINGERING_POTION);
        PotionHelper.addMix(PotionTypes.WATER, Items.SPECKLED_MELON, PotionTypes.MUNDANE);
        PotionHelper.addMix(PotionTypes.WATER, Items.GHAST_TEAR, PotionTypes.MUNDANE);
        PotionHelper.addMix(PotionTypes.WATER, Items.RABBIT_FOOT, PotionTypes.MUNDANE);
        PotionHelper.addMix(PotionTypes.WATER, Items.BLAZE_POWDER, PotionTypes.MUNDANE);
        PotionHelper.addMix(PotionTypes.WATER, Items.SPIDER_EYE, PotionTypes.MUNDANE);
        PotionHelper.addMix(PotionTypes.WATER, Items.SUGAR, PotionTypes.MUNDANE);
        PotionHelper.addMix(PotionTypes.WATER, Items.MAGMA_CREAM, PotionTypes.MUNDANE);
        PotionHelper.addMix(PotionTypes.WATER, Items.GLOWSTONE_DUST, PotionTypes.THICK);
        PotionHelper.addMix(PotionTypes.WATER, Items.REDSTONE, PotionTypes.MUNDANE);
        PotionHelper.addMix(PotionTypes.WATER, Items.NETHER_WART, PotionTypes.AWKWARD);
        PotionHelper.addMix(PotionTypes.AWKWARD, Items.GOLDEN_CARROT, PotionTypes.NIGHT_VISION);
        PotionHelper.addMix(PotionTypes.NIGHT_VISION, Items.REDSTONE, PotionTypes.LONG_NIGHT_VISION);
        PotionHelper.addMix(PotionTypes.NIGHT_VISION, Items.FERMENTED_SPIDER_EYE, PotionTypes.INVISIBILITY);
        PotionHelper.addMix(PotionTypes.LONG_NIGHT_VISION, Items.FERMENTED_SPIDER_EYE, PotionTypes.LONG_INVISIBILITY);
        PotionHelper.addMix(PotionTypes.INVISIBILITY, Items.REDSTONE, PotionTypes.LONG_INVISIBILITY);
        PotionHelper.addMix(PotionTypes.AWKWARD, Items.MAGMA_CREAM, PotionTypes.FIRE_RESISTANCE);
        PotionHelper.addMix(PotionTypes.FIRE_RESISTANCE, Items.REDSTONE, PotionTypes.LONG_FIRE_RESISTANCE);
        PotionHelper.addMix(PotionTypes.AWKWARD, Items.RABBIT_FOOT, PotionTypes.LEAPING);
        PotionHelper.addMix(PotionTypes.LEAPING, Items.REDSTONE, PotionTypes.LONG_LEAPING);
        PotionHelper.addMix(PotionTypes.LEAPING, Items.GLOWSTONE_DUST, PotionTypes.STRONG_LEAPING);
        PotionHelper.addMix(PotionTypes.LEAPING, Items.FERMENTED_SPIDER_EYE, PotionTypes.SLOWNESS);
        PotionHelper.addMix(PotionTypes.LONG_LEAPING, Items.FERMENTED_SPIDER_EYE, PotionTypes.LONG_SLOWNESS);
        PotionHelper.addMix(PotionTypes.SLOWNESS, Items.REDSTONE, PotionTypes.LONG_SLOWNESS);
        PotionHelper.addMix(PotionTypes.SWIFTNESS, Items.FERMENTED_SPIDER_EYE, PotionTypes.SLOWNESS);
        PotionHelper.addMix(PotionTypes.LONG_SWIFTNESS, Items.FERMENTED_SPIDER_EYE, PotionTypes.LONG_SLOWNESS);
        PotionHelper.addMix(PotionTypes.AWKWARD, Items.SUGAR, PotionTypes.SWIFTNESS);
        PotionHelper.addMix(PotionTypes.SWIFTNESS, Items.REDSTONE, PotionTypes.LONG_SWIFTNESS);
        PotionHelper.addMix(PotionTypes.SWIFTNESS, Items.GLOWSTONE_DUST, PotionTypes.STRONG_SWIFTNESS);
        PotionHelper.addMix(PotionTypes.AWKWARD, Ingredient.fromStacks(new ItemStack(Items.FISH, 1, ItemFishFood.FishType.PUFFERFISH.getMetadata())), PotionTypes.WATER_BREATHING);
        PotionHelper.addMix(PotionTypes.WATER_BREATHING, Items.REDSTONE, PotionTypes.LONG_WATER_BREATHING);
        PotionHelper.addMix(PotionTypes.AWKWARD, Items.SPECKLED_MELON, PotionTypes.HEALING);
        PotionHelper.addMix(PotionTypes.HEALING, Items.GLOWSTONE_DUST, PotionTypes.STRONG_HEALING);
        PotionHelper.addMix(PotionTypes.HEALING, Items.FERMENTED_SPIDER_EYE, PotionTypes.HARMING);
        PotionHelper.addMix(PotionTypes.STRONG_HEALING, Items.FERMENTED_SPIDER_EYE, PotionTypes.STRONG_HARMING);
        PotionHelper.addMix(PotionTypes.HARMING, Items.GLOWSTONE_DUST, PotionTypes.STRONG_HARMING);
        PotionHelper.addMix(PotionTypes.POISON, Items.FERMENTED_SPIDER_EYE, PotionTypes.HARMING);
        PotionHelper.addMix(PotionTypes.LONG_POISON, Items.FERMENTED_SPIDER_EYE, PotionTypes.HARMING);
        PotionHelper.addMix(PotionTypes.STRONG_POISON, Items.FERMENTED_SPIDER_EYE, PotionTypes.STRONG_HARMING);
        PotionHelper.addMix(PotionTypes.AWKWARD, Items.SPIDER_EYE, PotionTypes.POISON);
        PotionHelper.addMix(PotionTypes.POISON, Items.REDSTONE, PotionTypes.LONG_POISON);
        PotionHelper.addMix(PotionTypes.POISON, Items.GLOWSTONE_DUST, PotionTypes.STRONG_POISON);
        PotionHelper.addMix(PotionTypes.AWKWARD, Items.GHAST_TEAR, PotionTypes.REGENERATION);
        PotionHelper.addMix(PotionTypes.REGENERATION, Items.REDSTONE, PotionTypes.LONG_REGENERATION);
        PotionHelper.addMix(PotionTypes.REGENERATION, Items.GLOWSTONE_DUST, PotionTypes.STRONG_REGENERATION);
        PotionHelper.addMix(PotionTypes.AWKWARD, Items.BLAZE_POWDER, PotionTypes.STRENGTH);
        PotionHelper.addMix(PotionTypes.STRENGTH, Items.REDSTONE, PotionTypes.LONG_STRENGTH);
        PotionHelper.addMix(PotionTypes.STRENGTH, Items.GLOWSTONE_DUST, PotionTypes.STRONG_STRENGTH);
        PotionHelper.addMix(PotionTypes.WATER, Items.FERMENTED_SPIDER_EYE, PotionTypes.WEAKNESS);
        PotionHelper.addMix(PotionTypes.WEAKNESS, Items.REDSTONE, PotionTypes.LONG_WEAKNESS);
    }

    public static void addContainerRecipe(ItemPotion p_193355_0_, Item p_193355_1_, ItemPotion p_193355_2_) {
        POTION_ITEM_CONVERSIONS.add(new MixPredicate<ItemPotion>(p_193355_0_, Ingredient.fromItems(p_193355_1_), p_193355_2_));
    }

    public static void addContainer(ItemPotion p_193354_0_) {
        POTION_ITEMS.add(Ingredient.fromItems(p_193354_0_));
    }

    public static void addMix(PotionType p_193357_0_, Item p_193357_1_, PotionType p_193357_2_) {
        PotionHelper.addMix(p_193357_0_, Ingredient.fromItems(p_193357_1_), p_193357_2_);
    }

    public static void addMix(PotionType p_193356_0_, Ingredient p_193356_1_, PotionType p_193356_2_) {
        POTION_TYPE_CONVERSIONS.add(new MixPredicate<PotionType>(p_193356_0_, p_193356_1_, p_193356_2_));
    }

    static class MixPredicate<T extends IForgeRegistryEntry.Impl<T>> {
        final IRegistryDelegate<T> input;
        final Ingredient reagent;
        final IRegistryDelegate<T> output;

        public MixPredicate(T p_i47570_1_, Ingredient p_i47570_2_, T p_i47570_3_) {
            this.input = ((IForgeRegistryEntry.Impl)p_i47570_1_).delegate;
            this.reagent = p_i47570_2_;
            this.output = ((IForgeRegistryEntry.Impl)p_i47570_3_).delegate;
        }
    }
}

