/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import java.util.BitSet;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.ForgeRegistry;

public class RecipeBook {
    protected final BitSet recipes = new BitSet();
    protected final BitSet newRecipes = new BitSet();
    protected boolean isGuiOpen;
    protected boolean isFilteringCraftable;

    public void copyFrom(RecipeBook that) {
        this.recipes.clear();
        this.newRecipes.clear();
        this.recipes.or(that.recipes);
        this.newRecipes.or(that.newRecipes);
    }

    public void unlock(IRecipe recipe) {
        if (!recipe.isDynamic()) {
            this.recipes.set(RecipeBook.getRecipeId(recipe));
        }
    }

    public boolean isUnlocked(@Nullable IRecipe recipe) {
        return this.recipes.get(RecipeBook.getRecipeId(recipe));
    }

    public void lock(IRecipe recipe) {
        int i = RecipeBook.getRecipeId(recipe);
        this.recipes.clear(i);
        this.newRecipes.clear(i);
    }

    @Deprecated
    protected static int getRecipeId(@Nullable IRecipe recipe) {
        int ret = CraftingManager.REGISTRY.getIDForObject(recipe);
        if (ret == -1 && (ret = ((ForgeRegistry)ForgeRegistries.RECIPES).getID(recipe.getRegistryName())) == -1) {
            throw new IllegalArgumentException(String.format("Attempted to get the ID for a unknown recipe: %s Name: %s", recipe, recipe.getRegistryName()));
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isNew(IRecipe recipe) {
        return this.newRecipes.get(RecipeBook.getRecipeId(recipe));
    }

    public void markSeen(IRecipe recipe) {
        this.newRecipes.clear(RecipeBook.getRecipeId(recipe));
    }

    public void markNew(IRecipe recipe) {
        this.newRecipes.set(RecipeBook.getRecipeId(recipe));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isGuiOpen() {
        return this.isGuiOpen;
    }

    public void setGuiOpen(boolean open) {
        this.isGuiOpen = open;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isFilteringCraftable() {
        return this.isFilteringCraftable;
    }

    public void setFilteringCraftable(boolean shouldFilter) {
        this.isFilteringCraftable = shouldFilter;
    }
}

