/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.EnumFacing;

public enum Rotation {
    NONE("rotate_0"),
    CLOCKWISE_90("rotate_90"),
    CLOCKWISE_180("rotate_180"),
    COUNTERCLOCKWISE_90("rotate_270");

    private final String name;
    private static final String[] rotationNames;

    private Rotation(String nameIn) {
        this.name = nameIn;
    }

    public Rotation add(Rotation rotation) {
        switch (rotation.ordinal()) {
            case 2: {
                switch (this.ordinal()) {
                    case 0: {
                        return CLOCKWISE_180;
                    }
                    case 1: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case 2: {
                        return NONE;
                    }
                    case 3: {
                        return CLOCKWISE_90;
                    }
                }
            }
            case 3: {
                switch (this.ordinal()) {
                    case 0: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case 1: {
                        return NONE;
                    }
                    case 2: {
                        return CLOCKWISE_90;
                    }
                    case 3: {
                        return CLOCKWISE_180;
                    }
                }
            }
            case 1: {
                switch (this.ordinal()) {
                    case 0: {
                        return CLOCKWISE_90;
                    }
                    case 1: {
                        return CLOCKWISE_180;
                    }
                    case 2: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case 3: {
                        return NONE;
                    }
                }
            }
        }
        return this;
    }

    public EnumFacing rotate(EnumFacing facing) {
        if (facing.getAxis() == EnumFacing.Axis.Y) {
            return facing;
        }
        switch (this.ordinal()) {
            case 1: {
                return facing.rotateY();
            }
            case 2: {
                return facing.getOpposite();
            }
            case 3: {
                return facing.rotateYCCW();
            }
        }
        return facing;
    }

    public int rotate(int p_185833_1_, int p_185833_2_) {
        switch (this.ordinal()) {
            case 1: {
                return (p_185833_1_ + p_185833_2_ / 4) % p_185833_2_;
            }
            case 2: {
                return (p_185833_1_ + p_185833_2_ / 2) % p_185833_2_;
            }
            case 3: {
                return (p_185833_1_ + p_185833_2_ * 3 / 4) % p_185833_2_;
            }
        }
        return p_185833_1_;
    }

    static {
        rotationNames = new String[Rotation.values().length];
        int i = 0;
        for (Rotation rotation : Rotation.values()) {
            Rotation.rotationNames[i++] = rotation.name;
        }
    }
}

