/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChunkCache
implements IBlockAccess {
    protected int chunkX;
    protected int chunkZ;
    protected Chunk[][] chunkArray;
    protected boolean empty;
    protected World world;

    public ChunkCache(World worldIn, BlockPos posFromIn, BlockPos posToIn, int subIn) {
        this.world = worldIn;
        this.chunkX = posFromIn.getX() - subIn >> 4;
        this.chunkZ = posFromIn.getZ() - subIn >> 4;
        int i = posToIn.getX() + subIn >> 4;
        int j = posToIn.getZ() + subIn >> 4;
        this.chunkArray = new Chunk[i - this.chunkX + 1][j - this.chunkZ + 1];
        this.empty = true;
        for (int k = this.chunkX; k <= i; ++k) {
            for (int l = this.chunkZ; l <= j; ++l) {
                this.chunkArray[k - this.chunkX][l - this.chunkZ] = worldIn.getChunk(k, l);
            }
        }
        for (int i1 = posFromIn.getX() >> 4; i1 <= posToIn.getX() >> 4; ++i1) {
            for (int j1 = posFromIn.getZ() >> 4; j1 <= posToIn.getZ() >> 4; ++j1) {
                Chunk chunk = this.chunkArray[i1 - this.chunkX][j1 - this.chunkZ];
                if (chunk == null || chunk.isEmptyBetween(posFromIn.getY(), posToIn.getY())) continue;
                this.empty = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(BlockPos pos) {
        return this.getTileEntity(pos, Chunk.EnumCreateEntityType.CHECK);
    }

    @Nullable
    public TileEntity getTileEntity(BlockPos pos, Chunk.EnumCreateEntityType createType) {
        int j;
        int i = (pos.getX() >> 4) - this.chunkX;
        if (!this.withinBounds(i, j = (pos.getZ() >> 4) - this.chunkZ)) {
            return null;
        }
        return this.chunkArray[i][j].getTileEntity(pos, createType);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getCombinedLight(BlockPos pos, int lightValue) {
        int i = this.getLightForExt(EnumSkyBlock.SKY, pos);
        int j = this.getLightForExt(EnumSkyBlock.BLOCK, pos);
        if (j < lightValue) {
            j = lightValue;
        }
        return i << 20 | j << 4;
    }

    @Override
    public IBlockState getBlockState(BlockPos pos) {
        if (pos.getY() >= 0 && pos.getY() < 256) {
            Chunk chunk;
            int i = (pos.getX() >> 4) - this.chunkX;
            int j = (pos.getZ() >> 4) - this.chunkZ;
            if (i >= 0 && i < this.chunkArray.length && j >= 0 && j < this.chunkArray[i].length && (chunk = this.chunkArray[i][j]) != null) {
                return chunk.getBlockState(pos);
            }
        }
        return Blocks.AIR.getDefaultState();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Biome getBiome(BlockPos pos) {
        int j;
        int i = (pos.getX() >> 4) - this.chunkX;
        if (!this.withinBounds(i, j = (pos.getZ() >> 4) - this.chunkZ)) {
            return Biomes.PLAINS;
        }
        return this.chunkArray[i][j].getBiome(pos, this.world.getBiomeProvider());
    }

    @SideOnly(value=Side.CLIENT)
    private int getLightForExt(EnumSkyBlock type, BlockPos pos) {
        if (type == EnumSkyBlock.SKY && !this.world.provider.hasSkyLight()) {
            return 0;
        }
        if (pos.getY() >= 0 && pos.getY() < 256) {
            int j;
            if (this.getBlockState(pos).useNeighborBrightness()) {
                int l = 0;
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    int k = this.getLightFor(type, pos.offset(enumfacing));
                    if (k > l) {
                        l = k;
                    }
                    if (l < 15) continue;
                    return l;
                }
                return l;
            }
            int i = (pos.getX() >> 4) - this.chunkX;
            if (!this.withinBounds(i, j = (pos.getZ() >> 4) - this.chunkZ)) {
                return type.defaultLightValue;
            }
            return this.chunkArray[i][j].getLightFor(type, pos);
        }
        return type.defaultLightValue;
    }

    @Override
    public boolean isAirBlock(BlockPos pos) {
        IBlockState state = this.getBlockState(pos);
        return state.getBlock().isAir(state, this, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int getLightFor(EnumSkyBlock type, BlockPos pos) {
        if (pos.getY() >= 0 && pos.getY() < 256) {
            int j;
            int i = (pos.getX() >> 4) - this.chunkX;
            if (!this.withinBounds(i, j = (pos.getZ() >> 4) - this.chunkZ)) {
                return type.defaultLightValue;
            }
            return this.chunkArray[i][j].getLightFor(type, pos);
        }
        return type.defaultLightValue;
    }

    @Override
    public int getStrongPower(BlockPos pos, EnumFacing direction) {
        return this.getBlockState(pos).getStrongPower(this, pos, direction);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public WorldType getWorldType() {
        return this.world.getWorldType();
    }

    @Override
    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        int x = (pos.getX() >> 4) - this.chunkX;
        int z = (pos.getZ() >> 4) - this.chunkZ;
        if (pos.getY() < 0 || pos.getY() >= 256) {
            return _default;
        }
        if (!this.withinBounds(x, z)) {
            return _default;
        }
        IBlockState state = this.getBlockState(pos);
        return state.getBlock().isSideSolid(state, this, pos, side);
    }

    private boolean withinBounds(int x, int z) {
        return x >= 0 && x < this.chunkArray.length && z >= 0 && z < this.chunkArray[x].length && this.chunkArray[x][z] != null;
    }
}

