/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import javax.annotation.Nullable;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WorldProvider {
    public static final float[] MOON_PHASE_FACTORS = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f, 0.25f, 0.5f, 0.75f};
    protected World world;
    private WorldType terrainType;
    private String generatorSettings;
    protected BiomeProvider biomeProvider;
    protected boolean doesWaterVaporize;
    protected boolean nether;
    protected boolean hasSkyLight;
    protected final float[] lightBrightnessTable = new float[16];
    private final float[] colorsSunriseSunset = new float[4];
    private IRenderHandler skyRenderer = null;
    private IRenderHandler cloudRenderer = null;
    private IRenderHandler weatherRenderer = null;
    private int dimensionId;

    public final void setWorld(World worldIn) {
        this.world = worldIn;
        this.terrainType = worldIn.getWorldInfo().getTerrainType();
        this.generatorSettings = worldIn.getWorldInfo().getGeneratorOptions();
        this.init();
        this.generateLightBrightnessTable();
    }

    protected void generateLightBrightnessTable() {
        float f = 0.0f;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.lightBrightnessTable[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * 1.0f + 0.0f;
        }
    }

    protected void init() {
        this.hasSkyLight = true;
        this.biomeProvider = this.terrainType.getBiomeProvider(this.world);
    }

    public IChunkGenerator createChunkGenerator() {
        return this.terrainType.getChunkGenerator(this.world, this.generatorSettings);
    }

    public boolean canCoordinateBeSpawn(int x, int z) {
        BlockPos blockpos = new BlockPos(x, 0, z);
        if (this.world.getBiome(blockpos).ignorePlayerSpawnSuitability()) {
            return true;
        }
        return this.world.getGroundAboveSeaLevel(blockpos).getBlock() == Blocks.GRASS;
    }

    public float calculateCelestialAngle(long worldTime, float partialTicks) {
        int i = (int)(worldTime % 24000L);
        float f = ((float)i + partialTicks) / 24000.0f - 0.25f;
        if (f < 0.0f) {
            f += 1.0f;
        }
        if (f > 1.0f) {
            f -= 1.0f;
        }
        float f1 = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
        f += (f1 - f) / 3.0f;
        return f;
    }

    public int getMoonPhase(long worldTime) {
        return (int)(worldTime / 24000L % 8L + 8L) % 8;
    }

    public boolean isSurfaceWorld() {
        return true;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public float[] calcSunriseSunsetColors(float celestialAngle, float partialTicks) {
        float f = 0.4f;
        float f1 = MathHelper.cos(celestialAngle * ((float)Math.PI * 2)) - 0.0f;
        float f2 = -0.0f;
        if (f1 >= -0.4f && f1 <= 0.4f) {
            float f3 = (f1 - -0.0f) / 0.4f * 0.5f + 0.5f;
            float f4 = 1.0f - (1.0f - MathHelper.sin(f3 * (float)Math.PI)) * 0.99f;
            f4 *= f4;
            this.colorsSunriseSunset[0] = f3 * 0.3f + 0.7f;
            this.colorsSunriseSunset[1] = f3 * f3 * 0.7f + 0.2f;
            this.colorsSunriseSunset[2] = f3 * f3 * 0.0f + 0.2f;
            this.colorsSunriseSunset[3] = f4;
            return this.colorsSunriseSunset;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(float p_76562_1_, float p_76562_2_) {
        float f = MathHelper.cos(p_76562_1_ * ((float)Math.PI * 2)) * 2.0f + 0.5f;
        f = MathHelper.clamp(f, 0.0f, 1.0f);
        float f1 = 0.7529412f;
        float f2 = 0.84705883f;
        float f3 = 1.0f;
        return new Vec3d(f1 *= f * 0.94f + 0.06f, f2 *= f * 0.94f + 0.06f, f3 *= f * 0.91f + 0.09f);
    }

    public boolean canRespawnHere() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCloudHeight() {
        return this.terrainType.getCloudHeight();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSkyColored() {
        return true;
    }

    @Nullable
    public BlockPos getSpawnCoordinate() {
        return null;
    }

    public int getAverageGroundLevel() {
        return this.terrainType.getMinimumSpawnHeight(this.world);
    }

    @SideOnly(value=Side.CLIENT)
    public double getVoidFogYFactor() {
        return this.terrainType.voidFadeMagnitude();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesXZShowFog(int x, int z) {
        return false;
    }

    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    public boolean doesWaterVaporize() {
        return this.doesWaterVaporize;
    }

    public boolean hasSkyLight() {
        return this.hasSkyLight;
    }

    public boolean isNether() {
        return this.nether;
    }

    public float[] getLightBrightnessTable() {
        return this.lightBrightnessTable;
    }

    public WorldBorder createWorldBorder() {
        return new WorldBorder();
    }

    public void setDimension(int dim) {
        this.dimensionId = dim;
    }

    public int getDimension() {
        return this.dimensionId;
    }

    @Nullable
    public String getSaveFolder() {
        return this.dimensionId == 0 ? null : "DIM" + this.dimensionId;
    }

    public double getMovementFactor() {
        if (this instanceof WorldProviderHell) {
            return 8.0;
        }
        return 1.0;
    }

    public boolean shouldClientCheckLighting() {
        return !(this instanceof WorldProviderSurface);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return this.skyRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSkyRenderer(IRenderHandler skyRenderer) {
        this.skyRenderer = skyRenderer;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        return this.cloudRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public void setCloudRenderer(IRenderHandler renderer) {
        this.cloudRenderer = renderer;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        return this.weatherRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public void setWeatherRenderer(IRenderHandler renderer) {
        this.weatherRenderer = renderer;
    }

    public void getLightmapColors(float partialTicks, float sunBrightness, float skyLight, float blockLight, float[] colors) {
    }

    public BlockPos getRandomizedSpawnPoint() {
        BlockPos ret = this.world.getSpawnPoint();
        boolean isAdventure = this.world.getWorldInfo().getGameType() == GameType.ADVENTURE;
        int spawnFuzz = this.world instanceof WorldServer ? this.terrainType.getSpawnFuzz((WorldServer)this.world, this.world.getMinecraftServer()) : 1;
        int border = MathHelper.floor(this.world.getWorldBorder().getClosestDistance(ret.getX(), ret.getZ()));
        if (border < spawnFuzz) {
            spawnFuzz = border;
        }
        if (!this.isNether() && !isAdventure && spawnFuzz != 0) {
            if (spawnFuzz < 2) {
                spawnFuzz = 2;
            }
            int spawnFuzzHalf = spawnFuzz / 2;
            ret = this.world.getTopSolidOrLiquidBlock(ret.add(spawnFuzzHalf - this.world.rand.nextInt(spawnFuzz), 0, spawnFuzzHalf - this.world.rand.nextInt(spawnFuzz)));
        }
        return ret;
    }

    public boolean shouldMapSpin(String entity, double x, double z, double rotation) {
        return this.dimensionId < 0;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        return player.getSpawnDimension();
    }

    @Nullable
    public ICapabilityProvider initCapabilities() {
        return null;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public MusicTicker.MusicType getMusicType() {
        return null;
    }

    public WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
        return this.canRespawnHere() && this.world.getBiome(pos) != Biomes.HELL ? WorldSleepResult.ALLOW : WorldSleepResult.BED_EXPLODES;
    }

    public Biome getBiomeForCoords(BlockPos pos) {
        return this.world.getBiomeForCoordsBody(pos);
    }

    public boolean isDaytime() {
        return this.world.getSkylightSubtracted() < 4;
    }

    public float getSunBrightnessFactor(float par1) {
        return this.world.getSunBrightnessFactor(par1);
    }

    public float getCurrentMoonPhaseFactor() {
        return this.world.getCurrentMoonPhaseFactorBody();
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        return this.world.getSkyColorBody(cameraEntity, partialTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getCloudColor(float partialTicks) {
        return this.world.getCloudColorBody(partialTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        return this.world.getSunBrightnessBody(par1);
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        return this.world.getStarBrightnessBody(par1);
    }

    public void setAllowedSpawnTypes(boolean allowHostile, boolean allowPeaceful) {
        this.world.spawnHostileMobs = allowHostile;
        this.world.spawnPeacefulMobs = allowPeaceful;
    }

    public void calculateInitialWeather() {
        this.world.calculateInitialWeatherBody();
    }

    public void updateWeather() {
        this.world.updateWeatherBody();
    }

    public boolean canBlockFreeze(BlockPos pos, boolean byWater) {
        return this.world.canBlockFreezeBody(pos, byWater);
    }

    public boolean canSnowAt(BlockPos pos, boolean checkLight) {
        return this.world.canSnowAtBody(pos, checkLight);
    }

    public void setWorldTime(long time) {
        this.world.worldInfo.setWorldTime(time);
    }

    public long getSeed() {
        return this.world.worldInfo.getSeed();
    }

    public long getWorldTime() {
        return this.world.worldInfo.getWorldTime();
    }

    public BlockPos getSpawnPoint() {
        WorldInfo info = this.world.worldInfo;
        return new BlockPos(info.getSpawnX(), info.getSpawnY(), info.getSpawnZ());
    }

    public void setSpawnPoint(BlockPos pos) {
        this.world.worldInfo.setSpawn(pos);
    }

    public boolean canMineBlock(EntityPlayer player, BlockPos pos) {
        return this.world.canMineBlockBody(player, pos);
    }

    public boolean isBlockHighHumidity(BlockPos pos) {
        return this.world.getBiome(pos).isHighHumidity();
    }

    public int getHeight() {
        return 256;
    }

    public int getActualHeight() {
        return this.nether ? 128 : 256;
    }

    public double getHorizon() {
        return this.world.worldInfo.getTerrainType().getHorizon(this.world);
    }

    public void resetRainAndThunder() {
        this.world.worldInfo.setRainTime(0);
        this.world.worldInfo.setRaining(false);
        this.world.worldInfo.setThunderTime(0);
        this.world.worldInfo.setThundering(false);
    }

    public boolean canDoLightning(Chunk chunk) {
        return true;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return true;
    }

    public void onPlayerAdded(EntityPlayerMP player) {
    }

    public void onPlayerRemoved(EntityPlayerMP player) {
    }

    public abstract DimensionType getDimensionType();

    public void onWorldSave() {
    }

    public void onWorldUpdateEntities() {
    }

    public boolean canDropChunk(int x, int z) {
        return true;
    }

    public static enum WorldSleepResult {
        ALLOW,
        DENY,
        BED_EXPLODES;

    }
}

