/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateFlatWorld;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiCustomizeWorldScreen;
import net.minecraft.init.Biomes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.gen.ChunkGeneratorDebug;
import net.minecraft.world.gen.ChunkGeneratorFlat;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerBiome;
import net.minecraft.world.gen.layer.GenLayerBiomeEdge;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldType {
    public static WorldType[] WORLD_TYPES = new WorldType[16];
    public static final WorldType DEFAULT = new WorldType(0, "default", 1).setVersioned();
    public static final WorldType FLAT = new WorldType(1, "flat");
    public static final WorldType LARGE_BIOMES = new WorldType(2, "largeBiomes");
    public static final WorldType AMPLIFIED = new WorldType(3, "amplified").enableInfoNotice();
    public static final WorldType CUSTOMIZED = new WorldType(4, "customized");
    public static final WorldType DEBUG_ALL_BLOCK_STATES = new WorldType(5, "debug_all_block_states");
    public static final WorldType DEFAULT_1_1 = new WorldType(8, "default_1_1", 0).setCanBeCreated(false);
    private final int id;
    private final String name;
    private final int version;
    private boolean canBeCreated;
    private boolean versioned;
    private boolean hasInfoNotice;

    private WorldType(int id, String name) {
        this(id, name, 0);
    }

    private WorldType(int id, String name, int version) {
        if (name.length() > 16 && DEBUG_ALL_BLOCK_STATES != null) {
            throw new IllegalArgumentException("World type names must not be longer then 16: " + name);
        }
        this.name = name;
        this.version = version;
        this.canBeCreated = true;
        this.id = id;
        WorldType.WORLD_TYPES[id] = this;
    }

    public String getName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public String getTranslationKey() {
        return "generator." + this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public String getInfoTranslationKey() {
        return this.getTranslationKey() + ".info";
    }

    public int getVersion() {
        return this.version;
    }

    public WorldType getWorldTypeForGeneratorVersion(int version) {
        return this == DEFAULT && version == 0 ? DEFAULT_1_1 : this;
    }

    private WorldType setCanBeCreated(boolean enable) {
        this.canBeCreated = enable;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canBeCreated() {
        return this.canBeCreated;
    }

    private WorldType setVersioned() {
        this.versioned = true;
        return this;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public static WorldType byName(String type) {
        for (WorldType worldtype : WORLD_TYPES) {
            if (worldtype == null || !worldtype.name.equalsIgnoreCase(type)) continue;
            return worldtype;
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasInfoNotice() {
        return this.hasInfoNotice;
    }

    private WorldType enableInfoNotice() {
        this.hasInfoNotice = true;
        return this;
    }

    public BiomeProvider getBiomeProvider(World world) {
        if (this == FLAT) {
            FlatGeneratorInfo flatgeneratorinfo = FlatGeneratorInfo.createFlatGeneratorFromString(world.getWorldInfo().getGeneratorOptions());
            return new BiomeProviderSingle(Biome.getBiome(flatgeneratorinfo.getBiome(), Biomes.DEFAULT));
        }
        if (this == DEBUG_ALL_BLOCK_STATES) {
            return new BiomeProviderSingle(Biomes.PLAINS);
        }
        return new BiomeProvider(world.getWorldInfo());
    }

    public IChunkGenerator getChunkGenerator(World world, String generatorOptions) {
        if (this == FLAT) {
            return new ChunkGeneratorFlat(world, world.getSeed(), world.getWorldInfo().isMapFeaturesEnabled(), generatorOptions);
        }
        if (this == DEBUG_ALL_BLOCK_STATES) {
            return new ChunkGeneratorDebug(world);
        }
        if (this == CUSTOMIZED) {
            return new ChunkGeneratorOverworld(world, world.getSeed(), world.getWorldInfo().isMapFeaturesEnabled(), generatorOptions);
        }
        return new ChunkGeneratorOverworld(world, world.getSeed(), world.getWorldInfo().isMapFeaturesEnabled(), generatorOptions);
    }

    public int getMinimumSpawnHeight(World world) {
        return this == FLAT ? 4 : world.getSeaLevel() + 1;
    }

    public double getHorizon(World world) {
        return this == FLAT ? 0.0 : 63.0;
    }

    public double voidFadeMagnitude() {
        return this == FLAT ? 1.0 : 0.03125;
    }

    public boolean handleSlimeSpawnReduction(Random random, World world) {
        return this == FLAT ? random.nextInt(4) != 1 : false;
    }

    private static int getNextID() {
        for (int x = 0; x < WORLD_TYPES.length; ++x) {
            if (WORLD_TYPES[x] != null) continue;
            return x;
        }
        int oldLen = WORLD_TYPES.length;
        WORLD_TYPES = Arrays.copyOf(WORLD_TYPES, oldLen + 16);
        return oldLen;
    }

    public WorldType(String name) {
        this(WorldType.getNextID(), name);
    }

    public void onGUICreateWorldPress() {
    }

    public int getSpawnFuzz(WorldServer world, MinecraftServer server) {
        return Math.max(0, server.getSpawnRadius(world));
    }

    @SideOnly(value=Side.CLIENT)
    public void onCustomizeButton(Minecraft mc, GuiCreateWorld guiCreateWorld) {
        if (this == FLAT) {
            mc.displayGuiScreen(new GuiCreateFlatWorld(guiCreateWorld, guiCreateWorld.chunkProviderSettingsJson));
        } else if (this == CUSTOMIZED) {
            mc.displayGuiScreen(new GuiCustomizeWorldScreen(guiCreateWorld, guiCreateWorld.chunkProviderSettingsJson));
        }
    }

    public boolean isCustomizable() {
        return this == FLAT || this == CUSTOMIZED;
    }

    public float getCloudHeight() {
        return 128.0f;
    }

    public GenLayer getBiomeLayer(long worldSeed, GenLayer parentLayer, ChunkGeneratorSettings chunkSettings) {
        GenLayer ret = new GenLayerBiome(200L, parentLayer, this, chunkSettings);
        ret = GenLayerZoom.magnify(1000L, ret, 2);
        ret = new GenLayerBiomeEdge(1000L, ret);
        return ret;
    }
}

