/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import java.nio.ByteBuffer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.ForgeModContainer;

public class CloudRenderer
implements ISelectiveResourceReloadListener {
    private static final float PX_SIZE = 0.00390625f;
    private static final VertexFormat FORMAT = DefaultVertexFormats.POSITION_TEX_COLOR;
    private static final int TOP_SECTIONS = 12;
    private static final int HEIGHT = 4;
    private static final float INSET = 0.001f;
    private static final float ALPHA = 0.8f;
    private static final boolean WIREFRAME = false;
    private final Minecraft mc = Minecraft.getMinecraft();
    private final ResourceLocation texture = new ResourceLocation("textures/environment/clouds.png");
    private int displayList = -1;
    private VertexBuffer vbo;
    private int cloudMode = -1;
    private int renderDistance = -1;
    private DynamicTexture COLOR_TEX = null;
    private int texW;
    private int texH;

    public CloudRenderer() {
        ((IReloadableResourceManager)this.mc.getResourceManager()).registerReloadListener(this);
    }

    private int getScale() {
        return this.cloudMode == 2 ? 12 : 8;
    }

    private float ceilToScale(float value) {
        float scale = this.getScale();
        return (float)MathHelper.ceil(value / scale) * scale;
    }

    private void vertices(BufferBuilder buffer) {
        float sectX0;
        boolean fancy = this.cloudMode == 2;
        float scale = this.getScale();
        float CULL_DIST = 2.0f * scale;
        float bCol = fancy ? 0.7f : 1.0f;
        float sectEnd = this.ceilToScale(this.renderDistance * 2 * 16);
        float sectStart = -sectEnd;
        float sectStep = this.ceilToScale(sectEnd * 2.0f / 12.0f);
        float sectPx = 0.00390625f / scale;
        buffer.begin(7, FORMAT);
        float sectX1 = sectX0 = sectStart;
        while (sectX1 < sectEnd) {
            float sectZ0;
            if ((sectX1 += sectStep) > sectEnd) {
                sectX1 = sectEnd;
            }
            float sectZ1 = sectZ0 = sectStart;
            while (sectZ1 < sectEnd) {
                if ((sectZ1 += sectStep) > sectEnd) {
                    sectZ1 = sectEnd;
                }
                float u0 = sectX0 * sectPx;
                float u1 = sectX1 * sectPx;
                float v0 = sectZ0 * sectPx;
                float v1 = sectZ1 * sectPx;
                buffer.pos(sectX0, 0.0, sectZ0).tex(u0, v0).color(bCol, bCol, bCol, 0.8f).endVertex();
                buffer.pos(sectX1, 0.0, sectZ0).tex(u1, v0).color(bCol, bCol, bCol, 0.8f).endVertex();
                buffer.pos(sectX1, 0.0, sectZ1).tex(u1, v1).color(bCol, bCol, bCol, 0.8f).endVertex();
                buffer.pos(sectX0, 0.0, sectZ1).tex(u0, v1).color(bCol, bCol, bCol, 0.8f).endVertex();
                if (fancy) {
                    float sliceCoord1;
                    float sliceCoord0;
                    buffer.pos(sectX0, 4.0, sectZ0).tex(u0, v0).color(1.0f, 1.0f, 1.0f, 0.8f).endVertex();
                    buffer.pos(sectX0, 4.0, sectZ1).tex(u0, v1).color(1.0f, 1.0f, 1.0f, 0.8f).endVertex();
                    buffer.pos(sectX1, 4.0, sectZ1).tex(u1, v1).color(1.0f, 1.0f, 1.0f, 0.8f).endVertex();
                    buffer.pos(sectX1, 4.0, sectZ0).tex(u1, v0).color(1.0f, 1.0f, 1.0f, 0.8f).endVertex();
                    float slice = sectX0;
                    while (slice < sectX1) {
                        sliceCoord0 = slice * sectPx;
                        sliceCoord1 = sliceCoord0 + 0.00390625f;
                        if (slice > -CULL_DIST) {
                            buffer.pos(slice += 0.001f, 0.0, sectZ1).tex(sliceCoord0, v1).color(0.9f, 0.9f, 0.9f, 0.8f).endVertex();
                            buffer.pos(slice, 4.0, sectZ1).tex(sliceCoord1, v1).color(0.9f, 0.9f, 0.9f, 0.8f).endVertex();
                            buffer.pos(slice, 4.0, sectZ0).tex(sliceCoord1, v0).color(0.9f, 0.9f, 0.9f, 0.8f).endVertex();
                            buffer.pos(slice, 0.0, sectZ0).tex(sliceCoord0, v0).color(0.9f, 0.9f, 0.9f, 0.8f).endVertex();
                            slice -= 0.001f;
                        }
                        if (!((slice += scale) <= CULL_DIST)) continue;
                        buffer.pos(slice -= 0.001f, 0.0, sectZ0).tex(sliceCoord0, v0).color(0.9f, 0.9f, 0.9f, 0.8f).endVertex();
                        buffer.pos(slice, 4.0, sectZ0).tex(sliceCoord1, v0).color(0.9f, 0.9f, 0.9f, 0.8f).endVertex();
                        buffer.pos(slice, 4.0, sectZ1).tex(sliceCoord1, v1).color(0.9f, 0.9f, 0.9f, 0.8f).endVertex();
                        buffer.pos(slice, 0.0, sectZ1).tex(sliceCoord0, v1).color(0.9f, 0.9f, 0.9f, 0.8f).endVertex();
                        slice += 0.001f;
                    }
                    slice = sectZ0;
                    while (slice < sectZ1) {
                        sliceCoord0 = slice * sectPx;
                        sliceCoord1 = sliceCoord0 + 0.00390625f;
                        if (slice > -CULL_DIST) {
                            buffer.pos(sectX0, 0.0, slice += 0.001f).tex(u0, sliceCoord0).color(0.8f, 0.8f, 0.8f, 0.8f).endVertex();
                            buffer.pos(sectX0, 4.0, slice).tex(u0, sliceCoord1).color(0.8f, 0.8f, 0.8f, 0.8f).endVertex();
                            buffer.pos(sectX1, 4.0, slice).tex(u1, sliceCoord1).color(0.8f, 0.8f, 0.8f, 0.8f).endVertex();
                            buffer.pos(sectX1, 0.0, slice).tex(u1, sliceCoord0).color(0.8f, 0.8f, 0.8f, 0.8f).endVertex();
                            slice -= 0.001f;
                        }
                        if (!((slice += scale) <= CULL_DIST)) continue;
                        buffer.pos(sectX1, 0.0, slice -= 0.001f).tex(u1, sliceCoord0).color(0.8f, 0.8f, 0.8f, 0.8f).endVertex();
                        buffer.pos(sectX1, 4.0, slice).tex(u1, sliceCoord1).color(0.8f, 0.8f, 0.8f, 0.8f).endVertex();
                        buffer.pos(sectX0, 4.0, slice).tex(u0, sliceCoord1).color(0.8f, 0.8f, 0.8f, 0.8f).endVertex();
                        buffer.pos(sectX0, 0.0, slice).tex(u0, sliceCoord0).color(0.8f, 0.8f, 0.8f, 0.8f).endVertex();
                        slice += 0.001f;
                    }
                }
                sectZ0 = sectZ1;
            }
            sectX0 = sectX1;
        }
    }

    private void dispose() {
        if (this.vbo != null) {
            this.vbo.deleteGlBuffers();
            this.vbo = null;
        }
        if (this.displayList >= 0) {
            GLAllocation.deleteDisplayLists(this.displayList);
            this.displayList = -1;
        }
    }

    private void build() {
        Tessellator tess = Tessellator.getInstance();
        BufferBuilder buffer = tess.getBuffer();
        if (OpenGlHelper.useVbo()) {
            this.vbo = new VertexBuffer(FORMAT);
        } else {
            this.displayList = GLAllocation.generateDisplayLists(1);
            GlStateManager.glNewList(this.displayList, 4864);
        }
        this.vertices(buffer);
        if (OpenGlHelper.useVbo()) {
            buffer.finishDrawing();
            buffer.reset();
            this.vbo.bufferData(buffer.getByteBuffer());
        } else {
            tess.draw();
            GlStateManager.glEndList();
        }
    }

    private int fullCoord(double coord, int scale) {
        return (int)coord / scale - (coord < 0.0 ? 1 : 0);
    }

    private boolean isBuilt() {
        return OpenGlHelper.useVbo() ? this.vbo != null : this.displayList >= 0;
    }

    public void checkSettings() {
        boolean newEnabled;
        boolean bl = newEnabled = ForgeModContainer.forgeCloudsEnabled && this.mc.gameSettings.shouldRenderClouds() != 0 && this.mc.world != null && this.mc.world.provider.isSurfaceWorld();
        if (this.isBuilt() && (!newEnabled || this.mc.gameSettings.shouldRenderClouds() != this.cloudMode || this.mc.gameSettings.renderDistanceChunks != this.renderDistance)) {
            this.dispose();
        }
        this.cloudMode = this.mc.gameSettings.shouldRenderClouds();
        this.renderDistance = this.mc.gameSettings.renderDistanceChunks;
        if (newEnabled && !this.isBuilt()) {
            this.build();
        }
    }

    public boolean render(int cloudTicks, float partialTicks) {
        int i;
        if (!this.isBuilt()) {
            return false;
        }
        Entity entity = this.mc.getRenderViewEntity();
        double totalOffset = (float)cloudTicks + partialTicks;
        double x = entity.prevPosX + (entity.posX - entity.prevPosX) * (double)partialTicks + totalOffset * 0.03;
        double y = (double)this.mc.world.provider.getCloudHeight() - (entity.lastTickPosY + (entity.posY - entity.lastTickPosY) * (double)partialTicks) + 0.33;
        double z = entity.prevPosZ + (entity.posZ - entity.prevPosZ) * (double)partialTicks;
        int scale = this.getScale();
        if (this.cloudMode == 2) {
            z += 0.33 * (double)scale;
        }
        int offU = this.fullCoord(x, scale);
        int offV = this.fullCoord(z, scale);
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)(offU * scale) - x, y, (double)(offV * scale) - z);
        GlStateManager.matrixMode(5890);
        GlStateManager.translate((float)(offU %= this.texW) * 0.00390625f, (float)(offV %= this.texH) * 0.00390625f, 0.0f);
        GlStateManager.matrixMode(5888);
        GlStateManager.disableCull();
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        Vec3d color = this.mc.world.getCloudColour(partialTicks);
        float r = (float)color.x;
        float g = (float)color.y;
        float b = (float)color.z;
        if (this.mc.gameSettings.anaglyph) {
            float tempR = r * 0.3f + g * 0.59f + b * 0.11f;
            float tempG = r * 0.3f + g * 0.7f;
            float tempB = r * 0.3f + b * 0.7f;
            r = tempR;
            g = tempG;
            b = tempB;
        }
        if (this.COLOR_TEX == null) {
            this.COLOR_TEX = new DynamicTexture(1, 1);
        }
        this.COLOR_TEX.getTextureData()[0] = 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
        this.COLOR_TEX.updateDynamicTexture();
        GlStateManager.setActiveTexture(OpenGlHelper.lightmapTexUnit);
        GlStateManager.bindTexture(this.COLOR_TEX.getGlTextureId());
        GlStateManager.enableTexture2D();
        GlStateManager.setActiveTexture(OpenGlHelper.defaultTexUnit);
        this.mc.renderEngine.bindTexture(this.texture);
        ByteBuffer buffer = Tessellator.getInstance().getBuffer().getByteBuffer();
        if (OpenGlHelper.useVbo()) {
            this.vbo.bindBuffer();
            int stride = FORMAT.getSize();
            GlStateManager.glVertexPointer(3, 5126, stride, 0);
            GlStateManager.glEnableClientState(32884);
            GlStateManager.glTexCoordPointer(2, 5126, stride, 12);
            GlStateManager.glEnableClientState(32888);
            GlStateManager.glColorPointer(4, 5121, stride, 20);
            GlStateManager.glEnableClientState(32886);
        } else {
            buffer.limit(FORMAT.getSize());
            for (i = 0; i < FORMAT.getElementCount(); ++i) {
                FORMAT.getElements().get(i).getUsage().preDraw(FORMAT, i, FORMAT.getSize(), buffer);
            }
            buffer.position(0);
        }
        GlStateManager.colorMask(false, false, false, false);
        if (OpenGlHelper.useVbo()) {
            this.vbo.drawArrays(7);
        } else {
            GlStateManager.callList(this.displayList);
        }
        if (!this.mc.gameSettings.anaglyph) {
            GlStateManager.colorMask(true, true, true, true);
        } else {
            switch (EntityRenderer.anaglyphField) {
                case 0: {
                    GlStateManager.colorMask(false, true, true, true);
                    break;
                }
                case 1: {
                    GlStateManager.colorMask(true, false, false, true);
                }
            }
        }
        if (OpenGlHelper.useVbo()) {
            this.vbo.drawArrays(7);
            this.vbo.unbindBuffer();
        } else {
            GlStateManager.callList(this.displayList);
        }
        buffer.limit(0);
        for (i = 0; i < FORMAT.getElementCount(); ++i) {
            FORMAT.getElements().get(i).getUsage().postDraw(FORMAT, i, FORMAT.getSize(), buffer);
        }
        buffer.position(0);
        GlStateManager.setActiveTexture(OpenGlHelper.lightmapTexUnit);
        GlStateManager.disableTexture2D();
        GlStateManager.setActiveTexture(OpenGlHelper.defaultTexUnit);
        GlStateManager.matrixMode(5890);
        GlStateManager.loadIdentity();
        GlStateManager.matrixMode(5888);
        GlStateManager.disableBlend();
        GlStateManager.enableCull();
        GlStateManager.popMatrix();
        return true;
    }

    private void reloadTextures() {
        if (this.mc.renderEngine != null) {
            this.mc.renderEngine.bindTexture(this.texture);
            this.texW = GlStateManager.glGetTexLevelParameteri(3553, 0, 4096);
            this.texH = GlStateManager.glGetTexLevelParameteri(3553, 0, 4097);
        }
    }

    @Override
    public void onResourceManagerReload(@Nonnull IResourceManager resourceManager, @Nonnull Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test(VanillaResourceType.TEXTURES)) {
            this.reloadTextures();
        }
    }
}

