/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.cleanroommc.client.IMEHandler;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.gui.inventory.GuiEditSign;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraftforge.client.FluidContainerColorer;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ForgeClientHandler {
    private static final Set<String> classList = Arrays.stream(ForgeModContainer.inputMethodGuiWhiteList).collect(Collectors.toSet());

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        if (FluidRegistry.isUniversalBucketEnabled()) {
            ModelLoader.setBucketModelDefinition(ForgeModContainer.getInstance().universalBucket);
        }
    }

    @SubscribeEvent
    public static void registerItemHandlers(ColorHandlerEvent.Item event) {
        if (FluidRegistry.isUniversalBucketEnabled()) {
            event.getItemColors().registerItemColorHandler((IItemColor)new FluidContainerColorer(), ForgeModContainer.getInstance().universalBucket);
        }
    }

    @SubscribeEvent
    public static void didChangeGui(GuiOpenEvent event) {
        boolean canInput;
        GuiScreen gui = event.getGui();
        if (gui == null) {
            canInput = false;
        } else {
            if (gui instanceof GuiChat) {
                return;
            }
            canInput = gui instanceof GuiScreenBook || gui instanceof GuiEditSign || ForgeClientHandler.guiInWhiteList(gui);
        }
        IMEHandler.setIME(canInput);
    }

    private static boolean guiInWhiteList(GuiScreen gui) {
        String current = gui.getClass().getName();
        return classList.contains(current);
    }
}

