/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.Maps;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.gui.BossInfoClient;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.FoliageColorReloadListener;
import net.minecraft.client.resources.GrassColorReloadListener;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.MovementInput;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.SelectiveReloadStateHandler;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.core.async.ThreadNameCachingStrategy;
import org.apache.logging.log4j.core.impl.ReusableLogEventFactory;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class ForgeHooksClient {
    static int renderPass = -1;
    static final ThreadLocal<BlockRenderLayer> renderLayer = new ThreadLocal();
    private static int skyX;
    private static int skyZ;
    private static boolean skyInit;
    private static int skyRGBMultiplier;
    private static int updatescrollcounter;
    static int worldRenderPass;
    private static final Matrix4f flipX;
    private static final FloatBuffer matrixBuf;
    private static Map<Pair<Item, Integer>, Class<? extends TileEntity>> tileItemMap;
    private static final LightGatheringTransformer lightGatherer;
    private static int slotMainHand;

    static TextureManager engine() {
        return FMLClientHandler.instance().getClient().renderEngine;
    }

    public static String getArmorTexture(Entity entity, ItemStack armor, String _default, EntityEquipmentSlot slot, String type) {
        String result = armor.getItem().getArmorTexture(armor, entity, slot, type);
        return result != null ? result : _default;
    }

    public static void orientBedCamera(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity) {
        Block block = state.getBlock();
        if (block != null && block.isBed(state, world, pos, entity)) {
            GL11.glRotatef((float)(block.getBedDirection(state, world, pos).getHorizontalIndex() * 90), (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    public static boolean onDrawBlockHighlight(RenderGlobal context, EntityPlayer player, RayTraceResult target, int subID, float partialTicks) {
        return MinecraftForge.EVENT_BUS.post(new DrawBlockHighlightEvent(context, player, target, subID, partialTicks));
    }

    public static void dispatchRenderLast(RenderGlobal context, float partialTicks) {
        MinecraftForge.EVENT_BUS.post(new RenderWorldLastEvent(context, partialTicks));
    }

    public static boolean renderFirstPersonHand(RenderGlobal context, float partialTicks, int renderPass) {
        return MinecraftForge.EVENT_BUS.post(new RenderHandEvent(context, partialTicks, renderPass));
    }

    public static boolean renderSpecificFirstPersonHand(EnumHand hand, float partialTicks, float interpPitch, float swingProgress, float equipProgress, ItemStack stack) {
        return MinecraftForge.EVENT_BUS.post(new RenderSpecificHandEvent(hand, partialTicks, interpPitch, swingProgress, equipProgress, stack));
    }

    public static void onTextureStitchedPre(TextureMap map) {
        MinecraftForge.EVENT_BUS.post(new TextureStitchEvent.Pre(map));
        ModelLoader.White.INSTANCE.register(map);
        ModelDynBucket.LoaderDynBucket.INSTANCE.register(map);
    }

    public static void onTextureStitchedPost(TextureMap map) {
        MinecraftForge.EVENT_BUS.post(new TextureStitchEvent.Post(map));
    }

    public static void onBlockColorsInit(BlockColors blockColors) {
        MinecraftForge.EVENT_BUS.post(new ColorHandlerEvent.Block(blockColors));
    }

    public static void onItemColorsInit(ItemColors itemColors, BlockColors blockColors) {
        MinecraftForge.EVENT_BUS.post(new ColorHandlerEvent.Item(itemColors, blockColors));
    }

    public static void setRenderPass(int pass) {
        renderPass = pass;
    }

    public static void setRenderLayer(BlockRenderLayer layer) {
        renderLayer.set(layer);
    }

    public static ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot slot, ModelBiped _default) {
        ModelBiped model = itemStack.getItem().getArmorModel(entityLiving, itemStack, slot, _default);
        return model == null ? _default : model;
    }

    public static String fixDomain(String base, String complex) {
        int idx = complex.indexOf(58);
        if (idx == -1) {
            return base + complex;
        }
        String name = complex.substring(idx + 1, complex.length());
        if (idx > 1) {
            String domain = complex.substring(0, idx);
            return domain + ":" + base + name;
        }
        return base + name;
    }

    public static boolean postMouseEvent() {
        return MinecraftForge.EVENT_BUS.post(new MouseEvent());
    }

    public static float getOffsetFOV(EntityPlayer entity, float fov) {
        FOVUpdateEvent fovUpdateEvent = new FOVUpdateEvent(entity, fov);
        MinecraftForge.EVENT_BUS.post(fovUpdateEvent);
        return fovUpdateEvent.getNewfov();
    }

    public static float getFOVModifier(EntityRenderer renderer, Entity entity, IBlockState state, double renderPartialTicks, float fov) {
        EntityViewRenderEvent.FOVModifier event = new EntityViewRenderEvent.FOVModifier(renderer, entity, state, renderPartialTicks, fov);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getFOV();
    }

    public static int getSkyBlendColour(World world, BlockPos center) {
        if (center.getX() == skyX && center.getZ() == skyZ && skyInit) {
            return skyRGBMultiplier;
        }
        skyInit = true;
        GameSettings settings = Minecraft.getMinecraft().gameSettings;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 0;
        if (settings.fancyGraphics && ranges.length > 0) {
            distance = ranges[MathHelper.clamp(settings.renderDistanceChunks, 0, ranges.length - 1)];
        }
        int r = 0;
        int g = 0;
        int b = 0;
        int divider = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                BlockPos pos = center.add(x, 0, z);
                Biome biome = world.getBiome(pos);
                int colour = biome.getSkyColorByTemp(biome.getTemperature(pos));
                r += (colour & 0xFF0000) >> 16;
                g += (colour & 0xFF00) >> 8;
                b += colour & 0xFF;
                ++divider;
            }
        }
        int multiplier = (r / divider & 0xFF) << 16 | (g / divider & 0xFF) << 8 | b / divider & 0xFF;
        skyX = center.getX();
        skyZ = center.getZ();
        skyRGBMultiplier = multiplier;
        return skyRGBMultiplier;
    }

    public static String renderMainMenu(GuiMainMenu gui, FontRenderer font, int width, int height, String splashText) {
        return splashText;
    }

    public static ISound playSound(SoundManager manager, ISound sound) {
        PlaySoundEvent e = new PlaySoundEvent(manager, sound);
        MinecraftForge.EVENT_BUS.post(e);
        return e.getResultSound();
    }

    public static int getWorldRenderPass() {
        return worldRenderPass;
    }

    public static void drawScreen(GuiScreen screen, int mouseX, int mouseY, float partialTicks) {
        if (!MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.DrawScreenEvent.Pre(screen, mouseX, mouseY, partialTicks))) {
            screen.drawScreen(mouseX, mouseY, partialTicks);
        }
        MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.DrawScreenEvent.Post(screen, mouseX, mouseY, partialTicks));
    }

    public static float getFogDensity(EntityRenderer renderer, Entity entity, IBlockState state, float partial, float density) {
        EntityViewRenderEvent.FogDensity event = new EntityViewRenderEvent.FogDensity(renderer, entity, state, partial, density);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return event.getDensity();
        }
        return -1.0f;
    }

    public static void onFogRender(EntityRenderer renderer, Entity entity, IBlockState state, float partial, int mode, float distance) {
        MinecraftForge.EVENT_BUS.post(new EntityViewRenderEvent.RenderFogEvent(renderer, entity, state, partial, mode, distance));
    }

    public static void onModelBake(ModelManager modelManager, IRegistry<ModelResourceLocation, IBakedModel> modelRegistry, ModelLoader modelLoader) {
        MinecraftForge.EVENT_BUS.post(new ModelBakeEvent(modelManager, modelRegistry, modelLoader));
        modelLoader.onPostBakeEvent(modelRegistry);
    }

    public static IBakedModel handleCameraTransforms(IBakedModel model, ItemCameraTransforms.TransformType cameraTransformType, boolean leftHandHackery) {
        Pair<? extends IBakedModel, Matrix4f> pair = model.handlePerspective(cameraTransformType);
        if (pair.getRight() != null) {
            Matrix4f matrix = new Matrix4f((Matrix4f)pair.getRight());
            if (leftHandHackery) {
                matrix.mul(flipX, matrix);
                matrix.mul(matrix, flipX);
            }
            ForgeHooksClient.multiplyCurrentGlMatrix(matrix);
        }
        return (IBakedModel)pair.getLeft();
    }

    public static void multiplyCurrentGlMatrix(Matrix4f matrix) {
        matrixBuf.clear();
        float[] t = new float[4];
        for (int i = 0; i < 4; ++i) {
            matrix.getColumn(i, t);
            matrixBuf.put(t);
        }
        matrixBuf.flip();
        GL11.glMultMatrix((FloatBuffer)matrixBuf);
    }

    public static void preDraw(VertexFormatElement.EnumUsage attrType, VertexFormat format, int element, int stride, ByteBuffer buffer) {
        VertexFormatElement attr = format.getElement(element);
        int count = attr.getElementCount();
        int constant = attr.getType().getGlConstant();
        buffer.position(format.getOffset(element));
        switch (attrType) {
            case POSITION: {
                GlStateManager.glVertexPointer(count, constant, stride, buffer);
                GlStateManager.glEnableClientState(32884);
                break;
            }
            case NORMAL: {
                if (count != 3) {
                    throw new IllegalArgumentException("Normal attribute should have the size 3: " + String.valueOf(attr));
                }
                GlStateManager.glNormalPointer(constant, stride, buffer);
                GlStateManager.glEnableClientState(32885);
                break;
            }
            case COLOR: {
                GlStateManager.glColorPointer(count, constant, stride, buffer);
                GlStateManager.glEnableClientState(32886);
                break;
            }
            case UV: {
                OpenGlHelper.setClientActiveTexture(OpenGlHelper.defaultTexUnit + attr.getIndex());
                GlStateManager.glTexCoordPointer(count, constant, stride, buffer);
                GlStateManager.glEnableClientState(32888);
                OpenGlHelper.setClientActiveTexture(OpenGlHelper.defaultTexUnit);
                break;
            }
            case PADDING: {
                break;
            }
            case GENERIC: {
                GL20.glEnableVertexAttribArray((int)attr.getIndex());
                GL20.glVertexAttribPointer((int)attr.getIndex(), (int)count, (int)constant, (boolean)false, (int)stride, (ByteBuffer)buffer);
                break;
            }
            default: {
                FMLLog.log.fatal("Unimplemented vanilla attribute upload: {}", (Object)attrType.getDisplayName());
            }
        }
    }

    public static void postDraw(VertexFormatElement.EnumUsage attrType, VertexFormat format, int element, int stride, ByteBuffer buffer) {
        VertexFormatElement attr = format.getElement(element);
        switch (attrType) {
            case POSITION: {
                GlStateManager.glDisableClientState(32884);
                break;
            }
            case NORMAL: {
                GlStateManager.glDisableClientState(32885);
                break;
            }
            case COLOR: {
                GlStateManager.glDisableClientState(32886);
                GlStateManager.resetColor();
                break;
            }
            case UV: {
                OpenGlHelper.setClientActiveTexture(OpenGlHelper.defaultTexUnit + attr.getIndex());
                GlStateManager.glDisableClientState(32888);
                OpenGlHelper.setClientActiveTexture(OpenGlHelper.defaultTexUnit);
                break;
            }
            case PADDING: {
                break;
            }
            case GENERIC: {
                GL20.glDisableVertexAttribArray((int)attr.getIndex());
                break;
            }
            default: {
                FMLLog.log.fatal("Unimplemented vanilla attribute upload: {}", (Object)attrType.getDisplayName());
            }
        }
    }

    public static void transform(org.lwjgl.util.vector.Vector3f vec, Matrix4f m) {
        Vector4f tmp = new Vector4f(vec.x, vec.y, vec.z, 1.0f);
        m.transform((Tuple4f)tmp);
        if ((double)Math.abs(tmp.w - 1.0f) > 1.0E-5) {
            tmp.scale(1.0f / tmp.w);
        }
        vec.set(tmp.x, tmp.y, tmp.z);
    }

    public static Matrix4f getMatrix(ModelRotation modelRotation) {
        Matrix4f ret = new Matrix4f(TRSRTransformation.toVecmath(modelRotation.matrix()));
        Matrix4f tmp = new Matrix4f();
        tmp.setIdentity();
        tmp.m23 = 0.5f;
        tmp.m13 = 0.5f;
        tmp.m03 = 0.5f;
        ret.mul(tmp, ret);
        tmp.invert();
        ret.mul(tmp);
        return ret;
    }

    public static void putQuadColor(BufferBuilder renderer, BakedQuad quad, int color) {
        float cb = color & 0xFF;
        float cg = color >>> 8 & 0xFF;
        float cr = color >>> 16 & 0xFF;
        float ca = color >>> 24 & 0xFF;
        VertexFormat format = quad.getFormat();
        int size = format.getIntegerSize();
        int offset = format.getColorOffset() / 4;
        boolean hasColor = format.hasColor();
        for (int i = 0; i < 4; ++i) {
            int vc = hasColor ? quad.getVertexData()[offset + size * i] : -1;
            float vcr = vc & 0xFF;
            float vcg = vc >>> 8 & 0xFF;
            float vcb = vc >>> 16 & 0xFF;
            float vca = vc >>> 24 & 0xFF;
            int ncr = Math.min(255, (int)(cr * vcr / 255.0f));
            int ncg = Math.min(255, (int)(cg * vcg / 255.0f));
            int ncb = Math.min(255, (int)(cb * vcb / 255.0f));
            int nca = Math.min(255, (int)(ca * vca / 255.0f));
            renderer.putColorRGBA(renderer.getColorIndex(4 - i), ncr, ncg, ncb, nca);
        }
    }

    public static void renderTileItem(Item item, int metadata) {
        TileEntitySpecialRenderer<Object> r;
        Class<? extends TileEntity> tileClass = tileItemMap.get(Pair.of((Object)item, (Object)metadata));
        if (tileClass != null && (r = TileEntityRendererDispatcher.instance.getRenderer(tileClass)) != null) {
            r.render(null, 0.0, 0.0, 0.0, 0.0f, -1, 0.0f);
        }
    }

    @Deprecated
    public static void registerTESRItemStack(Item item, int metadata, Class<? extends TileEntity> TileClass) {
        tileItemMap.put((Pair<Item, Integer>)Pair.of((Object)item, (Object)metadata), TileClass);
    }

    public static void renderLitItem(RenderItem ri, IBakedModel model, int color, ItemStack stack) {
        ArrayList<BakedQuad> allquads = new ArrayList<BakedQuad>();
        for (EnumFacing enumfacing : EnumFacing.VALUES) {
            allquads.addAll(model.getQuads(null, enumfacing, 0L));
        }
        allquads.addAll(model.getQuads(null, null, 0L));
        if (allquads.isEmpty()) {
            return;
        }
        ArrayList<BakedQuad> segment = new ArrayList<BakedQuad>();
        int segmentBlockLight = 0;
        int segmentSkyLight = 0;
        boolean segmentShading = true;
        boolean segmentLightingDirty = false;
        boolean segmentShadingDirty = false;
        boolean hasLighting = false;
        for (int i = 0; i < allquads.size(); ++i) {
            boolean shadeDirty;
            BakedQuad q = (BakedQuad)allquads.get(i);
            int bl = 0;
            int sl = 0;
            if (q.getFormat() != DefaultVertexFormats.ITEM && q.getFormat().hasUvOffset(1)) {
                q.pipe(lightGatherer);
                if (lightGatherer.hasLighting()) {
                    bl = ForgeHooksClient.lightGatherer.blockLight;
                    sl = ForgeHooksClient.lightGatherer.skyLight;
                }
            }
            boolean shade = q.shouldApplyDiffuseLighting();
            boolean lightingDirty = segmentBlockLight != bl || segmentSkyLight != sl;
            boolean bl2 = shadeDirty = shade != segmentShading;
            if (lightingDirty || shadeDirty) {
                if (i > 0) {
                    ForgeHooksClient.drawSegment(ri, color, stack, segment, segmentBlockLight, segmentSkyLight, segmentShading, segmentLightingDirty && (hasLighting || segment.size() < i), segmentShadingDirty);
                }
                segmentBlockLight = bl;
                segmentSkyLight = sl;
                segmentShading = shade;
                segmentLightingDirty = lightingDirty;
                segmentShadingDirty = shadeDirty;
                hasLighting = segmentBlockLight > 0 || segmentSkyLight > 0 || !segmentShading;
            }
            segment.add(q);
        }
        ForgeHooksClient.drawSegment(ri, color, stack, segment, segmentBlockLight, segmentSkyLight, segmentShading, segmentLightingDirty && (hasLighting || segment.size() < allquads.size()), segmentShadingDirty);
        if (hasLighting) {
            OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, OpenGlHelper.lastBrightnessX, OpenGlHelper.lastBrightnessY);
            GlStateManager.enableLighting();
        }
    }

    private static void drawSegment(RenderItem ri, int baseColor, ItemStack stack, List<BakedQuad> segment, int bl, int sl, boolean shade, boolean updateLighting, boolean updateShading) {
        BufferBuilder bufferbuilder = Tessellator.getInstance().getBuffer();
        bufferbuilder.begin(7, DefaultVertexFormats.ITEM);
        float lastBl = OpenGlHelper.lastBrightnessX;
        float lastSl = OpenGlHelper.lastBrightnessY;
        if (updateShading) {
            if (shade) {
                GlStateManager.enableLighting();
            } else {
                GlStateManager.disableLighting();
            }
        }
        if (updateLighting) {
            OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, Math.max((float)bl, lastBl), Math.max((float)sl, lastSl));
        }
        ri.renderQuads(bufferbuilder, segment, baseColor, stack);
        Tessellator.getInstance().draw();
        OpenGlHelper.lastBrightnessX = lastBl;
        OpenGlHelper.lastBrightnessY = lastSl;
        segment.clear();
    }

    public static void fillNormal(int[] faceData, EnumFacing facing) {
        Vector3f v1 = ForgeHooksClient.getVertexPos(faceData, 3);
        Vector3f t = ForgeHooksClient.getVertexPos(faceData, 1);
        Vector3f v2 = ForgeHooksClient.getVertexPos(faceData, 2);
        v1.sub((Tuple3f)t);
        t.set((Tuple3f)ForgeHooksClient.getVertexPos(faceData, 0));
        v2.sub((Tuple3f)t);
        v1.cross(v2, v1);
        v1.normalize();
        int x = (byte)Math.round(v1.x * 127.0f) & 0xFF;
        int y = (byte)Math.round(v1.y * 127.0f) & 0xFF;
        int z = (byte)Math.round(v1.z * 127.0f) & 0xFF;
        int normal = x | y << 8 | z << 16;
        for (int i = 0; i < 4; ++i) {
            faceData[i * 7 + 6] = normal;
        }
    }

    private static Vector3f getVertexPos(int[] data, int vertex) {
        int idx = vertex * 7;
        float x = Float.intBitsToFloat(data[idx]);
        float y = Float.intBitsToFloat(data[idx + 1]);
        float z = Float.intBitsToFloat(data[idx + 2]);
        return new Vector3f(x, y, z);
    }

    public static Optional<TRSRTransformation> applyTransform(ItemTransformVec3f transform, Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(TRSRTransformation.blockCenterToCorner(TRSRTransformation.from(transform)));
    }

    public static Optional<TRSRTransformation> applyTransform(ModelRotation rotation, Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(TRSRTransformation.from(rotation));
    }

    public static Optional<TRSRTransformation> applyTransform(Matrix4f matrix, Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new TRSRTransformation(matrix));
    }

    public static void loadEntityShader(Entity entity, EntityRenderer entityRenderer) {
        ResourceLocation shader;
        if (entity != null && (shader = ClientRegistry.getEntityShader(entity.getClass())) != null) {
            entityRenderer.loadShader(shader);
        }
    }

    public static IBakedModel getDamageModel(IBakedModel ibakedmodel, TextureAtlasSprite texture, IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.getBlock().getExtendedState(state, world, pos);
        return new SimpleBakedModel.Builder(state, ibakedmodel, texture, pos).makeBakedModel();
    }

    public static boolean shouldCauseReequipAnimation(@Nonnull ItemStack from, @Nonnull ItemStack to, int slot) {
        boolean fromInvalid = from.isEmpty();
        boolean toInvalid = to.isEmpty();
        if (fromInvalid && toInvalid) {
            return false;
        }
        if (fromInvalid || toInvalid) {
            return true;
        }
        boolean changed = false;
        if (slot != -1) {
            changed = slot != slotMainHand;
            slotMainHand = slot;
        }
        return from.getItem().shouldCauseReequipAnimation(from, to, changed);
    }

    public static boolean shouldCauseBlockBreakReset(@Nonnull ItemStack from, @Nonnull ItemStack to) {
        return from.getItem().shouldCauseBlockBreakReset(from, to);
    }

    public static BlockFaceUV applyUVLock(BlockFaceUV blockFaceUV, EnumFacing originalSide, ITransformation rotation) {
        float t;
        TRSRTransformation global = new TRSRTransformation(rotation.getMatrix());
        Matrix4f uv = global.getUVLockTransform(originalSide).getMatrix();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        float u0 = blockFaceUV.getVertexU(blockFaceUV.getVertexRotatedRev(0));
        float v0 = blockFaceUV.getVertexV(blockFaceUV.getVertexRotatedRev(0));
        vec.x = u0 / 16.0f;
        vec.y = v0 / 16.0f;
        uv.transform((Tuple4f)vec);
        float uMin = 16.0f * vec.x;
        float vMin = 16.0f * vec.y;
        float u1 = blockFaceUV.getVertexU(blockFaceUV.getVertexRotatedRev(2));
        float v1 = blockFaceUV.getVertexV(blockFaceUV.getVertexRotatedRev(2));
        vec.x = u1 / 16.0f;
        vec.y = v1 / 16.0f;
        vec.z = 0.0f;
        vec.w = 1.0f;
        uv.transform((Tuple4f)vec);
        float uMax = 16.0f * vec.x;
        float vMax = 16.0f * vec.y;
        if (uMin > uMax && u0 < u1 || uMin < uMax && u0 > u1) {
            t = uMin;
            uMin = uMax;
            uMax = t;
        }
        if (vMin > vMax && v0 < v1 || vMin < vMax && v0 > v1) {
            t = vMin;
            vMin = vMax;
            vMax = t;
        }
        float a = (float)Math.toRadians(blockFaceUV.rotation);
        Vector3f rv = new Vector3f(MathHelper.cos(a), MathHelper.sin(a), 0.0f);
        Matrix3f rot = new Matrix3f();
        uv.getRotationScale(rot);
        rot.transform((Tuple3f)rv);
        int angle = MathHelper.normalizeAngle(-((int)Math.round(Math.toDegrees(Math.atan2(rv.y, rv.x)) / 90.0)) * 90, 360);
        return new BlockFaceUV(new float[]{uMin, vMin, uMax, vMax}, angle);
    }

    public static RenderGameOverlayEvent.BossInfo bossBarRenderPre(ScaledResolution res, BossInfoClient bossInfo, int x, int y, int increment) {
        RenderGameOverlayEvent.BossInfo evt = new RenderGameOverlayEvent.BossInfo(new RenderGameOverlayEvent(Animation.getPartialTickTime(), res), RenderGameOverlayEvent.ElementType.BOSSINFO, bossInfo, x, y, increment);
        MinecraftForge.EVENT_BUS.post(evt);
        return evt;
    }

    public static void bossBarRenderPost(ScaledResolution res) {
        MinecraftForge.EVENT_BUS.post(new RenderGameOverlayEvent.Post(new RenderGameOverlayEvent(Animation.getPartialTickTime(), res), RenderGameOverlayEvent.ElementType.BOSSINFO));
    }

    public static ScreenshotEvent onScreenshot(BufferedImage image, File screenshotFile) {
        ScreenshotEvent event = new ScreenshotEvent(image, screenshotFile);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static Pair<? extends IBakedModel, Matrix4f> handlePerspective(IBakedModel model, ItemCameraTransforms.TransformType type) {
        TRSRTransformation tr = TRSRTransformation.from(model.getItemCameraTransforms().getTransform(type));
        Matrix4f mat = null;
        if (!tr.isIdentity()) {
            mat = tr.getMatrix();
        }
        return Pair.of((Object)model, (Object)mat);
    }

    public static void onInputUpdate(EntityPlayer player, MovementInput movementInput) {
        MinecraftForge.EVENT_BUS.post(new InputUpdateEvent(player, movementInput));
    }

    public static String getHorseArmorTexture(EntityHorse horse, ItemStack armorStack) {
        String texture = armorStack.getItem().getHorseArmorTexture(horse, armorStack);
        if (texture == null) {
            texture = horse.getHorseArmorType().getTextureName();
        }
        return texture;
    }

    public static boolean shouldUseVanillaReloadableListener(IResourceManagerReloadListener listener) {
        Predicate<IResourceType> predicate = SelectiveReloadStateHandler.INSTANCE.get();
        if (listener instanceof ModelManager || listener instanceof RenderItem) {
            return predicate.test(VanillaResourceType.MODELS);
        }
        if (listener instanceof BlockRendererDispatcher || listener instanceof RenderGlobal) {
            return predicate.test(VanillaResourceType.MODELS);
        }
        if (listener instanceof TextureManager || listener instanceof FontRenderer) {
            return predicate.test(VanillaResourceType.TEXTURES);
        }
        if (listener instanceof FoliageColorReloadListener || listener instanceof GrassColorReloadListener) {
            return predicate.test(VanillaResourceType.TEXTURES);
        }
        if (listener instanceof SoundHandler) {
            return predicate.test(VanillaResourceType.SOUNDS);
        }
        if (listener instanceof EntityRenderer) {
            return predicate.test(VanillaResourceType.SHADERS);
        }
        if (listener instanceof LanguageManager || listener instanceof SearchTreeManager) {
            return predicate.test(VanillaResourceType.LANGUAGES);
        }
        return true;
    }

    public static void invalidateLog4jThreadCache() {
        try {
            Field nameField = ThreadNameCachingStrategy.class.getDeclaredField("THREADLOCAL_NAME");
            Field logEventField = ReusableLogEventFactory.class.getDeclaredField("mutableLogEventThreadLocal");
            nameField.setAccessible(true);
            logEventField.setAccessible(true);
            ((ThreadLocal)nameField.get(null)).set(null);
            ((ThreadLocal)logEventField.get(null)).set(null);
        }
        catch (NoClassDefFoundError | ReflectiveOperationException e) {
            FMLLog.log.error("Unable to invalidate log4j thread cache, thread fields in logs may be inaccurate", e);
        }
    }

    static {
        updatescrollcounter = 0;
        flipX = new Matrix4f();
        flipX.setIdentity();
        ForgeHooksClient.flipX.m00 = -1.0f;
        matrixBuf = BufferUtils.createFloatBuffer((int)16);
        tileItemMap = Maps.newHashMap();
        lightGatherer = new LightGatheringTransformer();
        slotMainHand = 0;
    }

    private static class LightGatheringTransformer
    extends QuadGatheringTransformer {
        private static final VertexFormat FORMAT = new VertexFormat().addElement(DefaultVertexFormats.TEX_2F).addElement(DefaultVertexFormats.TEX_2S);
        int blockLight;
        int skyLight;

        private LightGatheringTransformer() {
            this.setVertexFormat(FORMAT);
        }

        boolean hasLighting() {
            return this.dataLength[1] >= 2;
        }

        @Override
        protected void processQuad() {
            this.blockLight = 0;
            this.skyLight = 0;
            for (int i = 0; i < 4; ++i) {
                this.blockLight += (int)(this.quadData[1][i][0] * 65535.0f / 32.0f);
                this.skyLight += (int)(this.quadData[1][i][1] * 65535.0f / 32.0f);
            }
            this.blockLight *= 4;
            this.skyLight *= 4;
        }

        @Override
        public void setQuadTint(int tint) {
        }

        @Override
        public void setQuadOrientation(EnumFacing orientation) {
        }

        @Override
        public void setApplyDiffuseLighting(boolean diffuse) {
        }

        @Override
        public void setTexture(TextureAtlasSprite texture) {
        }
    }
}

